/*
 * SD card manager 0.0.4
 * http://www.pdaXrom.org
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/errno.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/arch/irqs.h>
#include <linux/kmod.h>

#if defined(CONFIG_ARCH_SHARP_SL) && defined(CONFIG_APM_CPU_IDLE)
#include <asm/sharp_apm.h>
#endif

#ifndef CONFIG_HOTPLUG
#error "Enable HOTPLUG support!!!"
#endif

static DECLARE_WAIT_QUEUE_HEAD(sdcard_proc);
static int sdcardmgr_running;
static int sdcardmgr_exit_flag;

static void sdcard_hotplug(int insert)
{
    char *argv[3], *envp[8];
    int i;

    if (!hotplug_path[0])
	return;

    i = 0;
    argv[i++] = hotplug_path;
    argv[i++] = "mmcsd";
    argv[i] = 0;

    i = 0;
    envp[i++] = "HOME=/";
    envp[i++] = "PATH=/sbin:/bin:/usr/sbin:/usr/bin";

    if (insert)
	envp[i++] = "ACTION=add";
    else
	envp[i++] = "ACTION=remove";
    envp[i] = 0;

    call_usermodehelper (argv [0], argv, envp);
}

static int sdcardmgr_getstatus(void)
{
#ifdef CONFIG_ARCH_PXA_AKITA
    if ( GPLR(GPIO9_MMCCS1) & GPIO_bit(GPIO9_MMCCS1) ) {
#elif CONFIG_ARCH_PXA_CORGI
    if ( GPLR(GPIO9_MMCCS1) & GPIO_bit(GPIO9_MMCCS1) ) {
#elif CONFIG_ARCH_PXA_TOSA
    if ( GPLR(GPIO9_MMCCS1) & GPIO_bit(GPIO9_MMCCS1) ) {
#elif CONFIG_SA1100_COLLIE
    if ( LCM_GPL & LCM_GPIO13 ) {
#else
#error "Unknown arch!"
#endif
	printk(KERN_NOTICE "sdcardmgr: SD card ejected!\n");
	return 0;
    } else {
	printk(KERN_NOTICE "sdcardmgr: SD card inserted!\n");
	return 1;
    }
}

static void sdcardmgr_thread(void)
{
    sdcardmgr_running = 1;
    daemonize();
    strcpy(current->comm, "sdcardmgr");
    sigfillset(&current->blocked);
    while(1) {
	interruptible_sleep_on(&sdcard_proc);
	if (sdcardmgr_exit_flag)
	    break;
	sdcard_hotplug(sdcardmgr_getstatus());
    }
    sdcardmgr_running = 0;
}

static void sdcardirq_handler()
{
    wake_up(&sdcard_proc);
}

static int install_sdcardirq(void)
{
#ifdef CONFIG_ARCH_PXA_AKITA
    CKEN &= ~CKEN12_MMC;
#elif CONFIG_ARCH_PXA_CORGI
    CKEN &= ~CKEN12_MMC;
#elif CONFIG_ARCH_PXA_TOSA
    CKEN &= ~CKEN12_MMC;
#endif

#if defined(CONFIG_ARCH_SHARP_SL) && defined(CONFIG_APM_CPU_IDLE)
    lock_FCS(LOCK_FCS_MMC, 0);
#endif

#ifdef CONFIG_ARCH_PXA_AKITA
    set_GPIO_mode( GPIO32_MMCCLK_MD );
    set_GPIO_IRQ_edge( GPIO_nSD_DETECT, GPIO_BOTH_EDGES );
    GPDR(GPIO9_MMCCS1) &= ~GPIO_bit(GPIO9_MMCCS1);
    if (request_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler, SA_SHIRQ, "sdcardirq", sdcardirq_handler)) {
	printk(KERN_NOTICE "sdcardmgr: Couldn't get irq %d\n", IRQ_GPIO_nSD_DETECT);
#elif CONFIG_ARCH_PXA_CORGI
    set_GPIO_mode( GPIO6_MMCCLK_MD );
    set_GPIO_IRQ_edge( GPIO_nSD_DETECT, GPIO_BOTH_EDGES );
    GPDR(GPIO9_MMCCS1) &= ~GPIO_bit(GPIO9_MMCCS1);
    if (request_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler, SA_SHIRQ, "sdcardirq", sdcardirq_handler)) {
	printk(KERN_NOTICE "sdcardmgr: Couldn't get irq %d\n", IRQ_GPIO_nSD_DETECT);
#elif CONFIG_ARCH_PXA_TOSA
    set_GPIO_mode( GPIO6_MMCCLK_MD );
    set_GPIO_IRQ_edge( GPIO_nSD_DETECT, GPIO_BOTH_EDGES );
    GPDR(GPIO9_MMCCS1) &= ~GPIO_bit(GPIO9_MMCCS1);
    if (request_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler, SA_SHIRQ, "sdcardirq", sdcardirq_handler)) {
	printk(KERN_NOTICE "sdcardmgr: Couldn't get irq %d\n", IRQ_GPIO_nSD_DETECT);
#elif CONFIG_SA1100_COLLIE
    LCM_GPD |= LCM_GPIO13;
    LCM_GPE |= LCM_GPIO13;
    LCM_GRIE |= LCM_GPIO13;
    LCM_GFIE |= LCM_GPIO13;
    
//    enable_irq(IRQ_LCM_GPIO_nSD_DETECT);
    if (request_irq(IRQ_LCM_GPIO_nSD_DETECT, sdcardirq_handler, SA_SHIRQ, "sdcardirq", sdcardirq_handler)) {
	printk(KERN_NOTICE "sdcardmgr: Couldn't get irq %d\n", IRQ_LCM_GPIO_nSD_DETECT);
#else
#error "Unknown arch!"
#endif
	return -ENODEV;
    }
    return 0;
}

static int deinstall_sdcardirq(void)
{
#ifdef CONFIG_ARCH_PXA_AKITA
    free_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler);
#elif CONFIG_ARCH_PXA_CORGI
    free_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler);
#elif CONFIG_ARCH_PXA_TOSA
    free_irq(IRQ_GPIO_nSD_DETECT, sdcardirq_handler);
#elif CONFIG_SA1100_COLLIE
    free_irq(IRQ_LCM_GPIO_nSD_DETECT, sdcardirq_handler);
#else
#error "Unknown arch!"
#endif
    return 0;
}

static int __init sdcardmgr_init(void)
{
    sdcardmgr_exit_flag = 0;
    if (install_sdcardirq())
	return -EINVAL;
    kernel_thread(sdcardmgr_thread,  NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND | SIGCHLD);
    sdcard_hotplug(sdcardmgr_getstatus());
    printk(KERN_NOTICE "SD card manager installed.\n");
    return 0;
}

static void __exit sdcardmgr_exit(void)
{
    deinstall_sdcardirq();
    sdcardmgr_exit_flag = 1;
    wake_up(&sdcard_proc);
    while(sdcardmgr_running)
	schedule();
    printk(KERN_NOTICE "SD card manager uninstalled.\n");
}

module_init (sdcardmgr_init);
module_exit (sdcardmgr_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR ("sash@pdaXrom.org");
MODULE_DESCRIPTION ("SD Card hotplug manager");
