// #undef BUILD_AS_QPE_APP
#define BUILD_AS_QPE_APP

#include <qwidget.h>
#include <qpainter.h>
#include <qimage.h>
#include <qtimer.h>
#include <qmainwindow.h>
#include <qmessagebox.h>
#include <stdio.h>

#ifdef BUILD_AS_QPE_APP
#include <qpe/qpeapplication.h>
#else
#include <qapplication.h>
#endif


extern "C" {
typedef unsigned char byte;
typedef enum { quakeFalse, quakeTrue } qboolean;
#include "vid.h"
#include "keys.h"
void CreateQtWindow(void);
void KillQtApp(void);
void RepaintQtWindow(void);
void SetQtPalette(unsigned char *palette);
void DoQtEventLoop(void);
void ProcessOneQtEvent(void);
void Vid_ShowError( const char *string );
};


int TranslateQtKeyCode( int key )
{
    int rc = -1;
    
    switch ( key ) {
	case 4144: // 1st ipaq button
	case Qt::Key_Escape:	    rc = K_ESCAPE;	break;
	case Qt::Key_Tab:	    rc = K_TAB;		break;

	case Qt::Key_Left:	    rc = K_LEFTARROW;   break;
	case Qt::Key_Right:	    rc = K_RIGHTARROW;  break;
	case Qt::Key_Up:	    rc = K_UPARROW;     break;
	case Qt::Key_Down:	    rc = K_DOWNARROW;   break;

/*
	// Rotated keyboard
	case Qt::Key_Left:	    rc = K_UPARROW;	break;
	case Qt::Key_Right:	    rc = K_DOWNARROW;	break;
	case Qt::Key_Up:	    rc = K_RIGHTARROW;  break;
	case Qt::Key_Down:	    rc = K_LEFTARROW;   break;
*/

	case Qt::Key_Backspace:	    rc = K_BACKSPACE;   break;
	case 4145: // 2nd ipaq button
	case Qt::Key_Enter:	    rc = K_ENTER;	break;
	case Qt::Key_Return:	    rc = K_ENTER;	break;
	case 4146: // 3rd ipaq button
	case Qt::Key_Shift:	    rc = K_SHIFT;	break;
	case Qt::Key_Alt:	    rc = K_ALT;		break;
	case 4147: // 4th ipaq button
	case Qt::Key_Control:	    rc = K_CTRL;	break;

	case Qt::Key_F5:	    rc = K_F5;		break;
	case Qt::Key_F6:	    rc = K_F6;		break;
	case Qt::Key_F7:	    rc = K_F7;		break;
	case Qt::Key_F8:	    rc = K_F8;		break;
	case Qt::Key_F9:	    rc = K_F9;		break;
	case Qt::Key_F10:	    rc = K_F10;		break;
	case Qt::Key_F11:	    rc = K_F11;		break;
	case Qt::Key_F12:	    rc = K_F12;		break;

	case 126:		    rc = '~';		break;
	default:
	    if ( key >= Qt::Key_A && key <= Qt::Key_Z )
		rc = key - Qt::Key_A + 'a';
	    else
		rc = 'a';
    }

    return rc;
}


class QuakeWindow : public QWidget
{
    public:
	QuakeWindow() { }
    protected:
	void keyReleaseEvent(QKeyEvent *ke)
	{
	    int key = TranslateQtKeyCode( ke->key() );
	    Key_Event( key, quakeFalse );
	}

	void keyPressEvent(QKeyEvent *ke)
	{
	    int key = TranslateQtKeyCode( ke->key() );
	    Key_Event( key, quakeTrue );
	}

	void closeEvent(QCloseEvent *)
	{
	    qApp->quit();
	    exit(0);
	}
};


QuakeWindow *g_mw;
QRgb g_colors[256];
bool haveQApp = FALSE;

void CreateQtWindow(void)
{
    int argc = 1;
    char *argv[] = { "Quake" };

#ifdef BUILD_AS_QPE_APP
    QPEApplication *a = new QPEApplication(argc, argv);
#else
    QApplication *a = new QApplication(argc, argv);
#endif

    haveQApp = TRUE;

    g_mw = new QuakeWindow();
    g_mw->setCaption( "HandheldQuake" );
    a->showMainWidget( g_mw );
    qApp->processEvents();
}


void DoQtEventLoop(void)
{
    qApp->exec();
}


void ProcessOneQtEvent(void)
{
    qApp->processEvents();
}


void KillQtApp(void)
{
    qApp->quit();
}


QImage *img;

void RepaintQtWindow(void)
{
    //printf("repainting\n");
    QPainter p( g_mw );
    if (!img)
	img = new QImage( (uchar*)vid.buffer, vid.rowbytes, vid.height, 8, g_colors, 256, QImage::IgnoreEndian ); 
    p.drawImage( 0, 0, *img, 0, 0, vid.width, vid.height );
}


void SetQtPalette(unsigned char *palette)
{
    for (int i = 0; i < 256; i++)
    {
	g_colors[i] = qRgb( palette[i*3], palette[i*3+1], palette[i*3+2] );
    }
}


void Vid_ShowError( const char *string )
{
    int argc = 1;
    char *argv[] = { "Quake" };
    if ( haveQApp == FALSE )
#ifdef BUILD_AS_QPE_APP
        new QPEApplication(argc, argv);
#else
        new QApplication(argc, argv);
#endif
    QMessageBox::critical( 0, "Quake Error", QString( "The following error occured:<br>" ) + string + "<p>Visit <br> http://handheldquake.sf.net/ <br> for more info and help.<p>" );
}

