/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the motif module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QMOTIFWIDGET_H
#define QMOTIFWIDGET_H

#include <qwidget.h>

#include <X11/Intrinsic.h>
#undef Bool
#undef Int

class QMotifWidgetPrivate;
class QKeyEvent;

class QMotifWidget : public QWidget
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QMotifWidget);

public:
    QMotifWidget(const char *name, WidgetClass widgetClass, QWidget *parent,
                 ArgList args = NULL, Cardinal argCount = 0,
                 Qt::WFlags flags = 0);
    ~QMotifWidget();

    Widget motifWidget() const;

    void show();
    void hide();

protected:
    bool event(QEvent *);
    bool eventFilter(QObject *object, QEvent *event);
    bool x11Event(XEvent *event);

private:
    void realize(Widget);

    friend void qmotif_widget_shell_destroy(Widget w);
    friend void qmotif_widget_shell_realize(Widget, XtValueMask *,
                                             XSetWindowAttributes *);
    friend void qmotif_widget_shell_change_managed(Widget);
    static bool dispatchQEvent(QEvent*, QWidget*);
    friend class QMotifDialog;
};

#endif // QMOTIFWIDGET_H
