/*
 * Copyright (C) 2003 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#ifndef WebCoreTextRendererFactory_h
#define WebCoreTextRendererFactory_h

#include <glib.h>
#include "WebCoreFoundation.h"

class WebCoreTextRenderer;

class NSFont : public WebCoreNSObject
{
 public:
  
};

enum NSFontTraitMask
{
  NSBoldFontMask = 1,
  NSItalicFontMask = 2  
};

class WebCoreTextRendererFactory
{
    
public:
    static WebCoreTextRendererFactory* sharedFactory() { return m_sharedFactory; }

    virtual NSFont* fontWithFamilies(const gchar * const * families, NSFontTraitMask traits, float size) = 0;
    virtual WebCoreTextRenderer* rendererWithFont(NSFont *font, bool isPrinterFont) = 0;
    virtual bool isFontFixedPitch(NSFont* f) =0;
    
protected:
    WebCoreTextRendererFactory() {};
    virtual ~WebCoreTextRendererFactory() {};

    static WebCoreTextRendererFactory* m_sharedFactory;

private:
    WebCoreTextRendererFactory(const WebCoreTextRendererFactory&);
    WebCoreTextRendererFactory& operator=(const WebCoreTextRendererFactory&);
	
};


#endif
