/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2006 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Tight_H
#define Tight_H

#include "NXpack.h"

#include "Unpack.h"
#include "Transport.h"
#include "WriteBuffer.h"

#define TIGHT_PACK_HEADER 14

#define CONCAT2(a,b) a##b
#define CONCAT2E(a,b) CONCAT2(a,b)

class Tight
{
  public:

  Tight();

  ~Tight();

  int ResizeFinal(unsigned int size);

  void CleanFinal();

  unsigned char *ResizeDecomp(unsigned int size);

  void CleanDecomp();

  //
  // This method is used to unpack images coming from
  // native VNC servers. It is unreasonably complex as
  // it needs to unpack images that can be larger than
  // the maximum size allowed for a single X request
  // and it was not designed to do so at the beginning.
  // Parameters grew in number as long as we found that
  // we needed some more information. It should be, at
  // least, redesigned or use BIG-REQUESTS.
  //

  int UnpackTight(unsigned char method, T_colormap *new_colormap,
                      unsigned char *tightData, unsigned int src_length,
                          unsigned short src_height, unsigned short src_width,
                              unsigned char *dstData, unsigned int dst_length,
                                  unsigned short dst_height, unsigned short dst_width,
                                      int dstBitsPerPixel, unsigned int drawable,
                                          unsigned int gcontext, short int dst_x, short int dst_y,
                                              unsigned char dst_depth, WriteBuffer *writeBuffer,
                                                  Transport *transport, int bigEndian,
                                                      unsigned char *buffer);

  //
  // This method is used to unpack images that were
  // compressed by the NX X agent (using the compext
  // library) with the Tight algorithm. Currently it
  // is not used as it doesn't offer much advantages
  // compared to PNG.
  //

  int UnpackTight(T_geometry *geometry, T_colormap *new_colormap,
                      unsigned char method, unsigned char *src_data,
                          int src_size, int dst_depth, int dst_bpp, int
                              dst_width, int dst_height, unsigned char *dst_data,
                                  int dst_size);

  void FilterCopy8(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterCopy16(int numRows, unsigned char *buffer, CARD16 *dst);

  void FilterCopy24(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterCopy32(int numRows, unsigned char *buffer, CARD32 *dst);

  void FilterGradient8(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterGradient16(int numRows, unsigned char *buffer, CARD16 *dst);

  void FilterGradient24(int numRows, unsigned char *buffer, CARD32 *dst);

  void FilterGradient24bpp(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterGradient32(int numRows, unsigned char *buffer, CARD32 *dst);

  void FilterPalette8(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterPalette16(int numRows, unsigned char *buffer, CARD16 *dst);

  void FilterPalette24(int numRows, unsigned char *buffer, CARD8 *dst);

  void FilterPalette32(int numRows, unsigned char *buffer, CARD32 *dst);

  void HandleTight8(int filterType, unsigned char *buffer, int rw, int rh);

  void HandleTight16(int filterType, unsigned char *buffer, int rw, int rh);

  void HandleTight24(int filterType, unsigned char *buffer, int rw, int rh);

  void HandleTight32(int filterType, unsigned char *buffer, int rw, int rh);

  int FlushBuffer(WriteBuffer *writeBuffer, Transport *transport);

  private:

  z_stream zlibStream[4];
  bool     zlibStreamActive[4];

  bool     cutZeros;
  int      rectWidth, rectColors;
  unsigned int *tightPalette;
  CARD8    tightPrevRow[2048*3*sizeof(CARD16)];
  CARD16   srcRedMax, srcGreenMax, srcBlueMax;
  CARD8    srcRedShift, srcGreenShift, srcBlueShift, srcDepth;

  unsigned int   finalSize,    tightDecompSize;
  unsigned char *finalBuffer, *tightDecompBuffer;
};

#endif
