/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef RenderExtension_H
#define RenderExtension_H

#include "Message.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  DUMP

//
// Compression of data part is not enabled as
// most messages of this type are smaller than
// the current data size compression threshold.
//

#define RENDEREXTENSION_ENABLE_CACHE               1
#define RENDEREXTENSION_ENABLE_DATA                0
#define RENDEREXTENSION_ENABLE_SPLIT               0
#define RENDEREXTENSION_ENABLE_COMPRESS            0

#define RENDEREXTENSION_DATA_LIMIT                 1536
#define RENDEREXTENSION_DATA_OFFSET                36

#define RENDEREXTENSION_CACHE_SLOTS                6000
#define RENDEREXTENSION_CACHE_THRESHOLD            20
#define RENDEREXTENSION_CACHE_LOWER_THRESHOLD      10

//
// The message class.
//

class RenderExtensionMessage : public Message
{
  friend class RenderExtensionStore;

  public:

  RenderExtensionMessage()
  {
  }

  ~RenderExtensionMessage()
  {
  }

  //
  // We consider for this message a data offset of 36,
  // that is size of the biggest among all requests of
  // this extension. The most common requests have a
  // specific differential encoding, others are simply
  // encoded through an array of int or char caches.
  //

  private:

  unsigned char  type;

  unsigned char  op;

  unsigned int   src_id;
  unsigned int   msk_id;
  unsigned int   dst_id;

  unsigned int   format;
  unsigned int   mask;

  unsigned int   glyphset;

  unsigned int   num_glyph;

  unsigned short src_x;
  unsigned short src_y;

  //
  // Keep enough space to encode the whole
  // identity minus the first 4 bytes.
  //

  union
  {
    unsigned char  char_data[32];
    unsigned short short_data[16];
  } raw_data;
};

class RenderExtensionStore : public MessageStore
{
  public:

  RenderExtensionStore(Compressor *compressor, Decompressor *decompressor);

  virtual ~RenderExtensionStore();

  virtual const char *name() const
  {
    return "RenderExtension";
  }

  virtual unsigned char opcode() const
  {
    return opcode_;
  }

  virtual unsigned int storage() const
  {
    return sizeof(RenderExtensionMessage);
  }

  //
  // Message handling methods.
  //

  public:

  virtual Message *create() const
  {
    return new RenderExtensionMessage();
  }

  virtual Message *create(const Message &message) const
  {
    return new RenderExtensionMessage((const RenderExtensionMessage &) message);
  }

  virtual void destroy(Message *message) const
  {
    delete (RenderExtensionMessage *) message;
  }

  virtual int encodeIdentity(EncodeBuffer &encodeBuffer, const unsigned char *buffer,
                                 const unsigned int size, int bigEndian,
                                     ChannelCache *channelCache) const;

  virtual int decodeIdentity(DecodeBuffer &decodeBuffer, unsigned char *&buffer,
                                 unsigned int &size, int bigEndian, WriteBuffer *writeBuffer,
                                     ChannelCache *channelCache) const;

  virtual int parseIdentity(Message *message, const unsigned char *buffer,
                                unsigned int size, int bigEndian) const;

  virtual int unparseIdentity(const Message *message, unsigned char *buffer,
                                  unsigned int size, int bigEndian) const;

  virtual void updateIdentity(EncodeBuffer &encodeBuffer, const Message *message,
                                  const Message *cachedMessage,
                                      ChannelCache *channelCache) const;

  virtual void updateIdentity(DecodeBuffer &decodeBuffer, const Message *message,
                                  ChannelCache *channelCache) const;

  virtual void identityChecksum(const Message *message, const unsigned char *buffer,
                                    unsigned int size, int bigEndian) const;

  virtual void dumpIdentity(const Message *message) const;

  //
  // Internal encode and decode utilities.
  //

  private:

  void encodeIntData(EncodeBuffer &encodeBuffer, const unsigned char *buffer,
                         unsigned int offset, unsigned int size, int bigEndian,
                             ChannelCache *channelCache) const;
 
  void encodeCharData(EncodeBuffer &encodeBuffer, const unsigned char *buffer,
                          unsigned int offset, unsigned int size, int bigEndian,
                              ChannelCache *channelCache) const;

  void decodeIntData(DecodeBuffer &decodeBuffer, unsigned char *buffer,
                         unsigned int offset, unsigned int size, int bigEndian,
                             ChannelCache *channelCache) const;

  void decodeCharData(DecodeBuffer &decodeBuffer, unsigned char *buffer,
                          unsigned int offset, unsigned int size, int bigEndian,
                              ChannelCache *channelCache) const;

  void parseIntData(const Message *message, const unsigned char *buffer,
                        unsigned int offset, unsigned int size,
                            int bigEndian) const;

  void parseCharData(const Message *message, const unsigned char *buffer,
                         unsigned int offset, unsigned int size,
                             int bigEndian) const;

  void unparseIntData(const Message *message, unsigned char *buffer,
                          unsigned int offset, unsigned int size,
                              int bigEndian) const;

  void unparseCharData(const Message *message, unsigned char *buffer,
                           unsigned int offset, unsigned int size,
                               int bigEndian) const;

  void updateIntData(EncodeBuffer &encodeBuffer, const Message *message,
                         const Message *cachedMessage, unsigned int offset,
                             unsigned int size, ChannelCache *channelCache) const;

  void updateCharData(EncodeBuffer &encodeBuffer, const Message *message,
                          const Message *cachedMessage, unsigned int offset,
                             unsigned int size, ChannelCache *channelCache) const;

  void updateIntData(DecodeBuffer &decodeBuffer, const Message *message,
                         unsigned int offset, unsigned int size,
                             ChannelCache *channelCache) const;

  void updateCharData(DecodeBuffer &decodeBuffer, const Message *message,
                          unsigned int offset, unsigned int size,
                              ChannelCache *channelCache) const;

  private:

  unsigned char opcode_;
};

#endif /* RenderExtension_H */
