/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef IntCache_H
#define IntCache_H

extern const unsigned int PARTIAL_INT_MASK[33];

class IntCache
{
  public:

  IntCache(unsigned int size);

  ~IntCache()
  {
    delete [] buffer_;
  }

  unsigned int getSize() const
  {
    return length_;
  }

  int lookup(unsigned int &value, unsigned int &index,
                 unsigned int mask, unsigned int &sameDiff);

  unsigned int get(unsigned int i);

  void insert(unsigned int &value, unsigned int mask);

  unsigned int getLastDiff(unsigned int mask) const
  {
    return lastDiff_;
  }

  unsigned int getBlockSize(unsigned int bits) const
  {
    if (bits > 0)
    {
      return (predictedBlockSize_ < bits ? predictedBlockSize_ : bits);
    }

    return predictedBlockSize_;
  }

  private:

  unsigned int size_;
  unsigned int length_;
  unsigned int *buffer_;
  unsigned int lastDiff_;
  unsigned int lastValueInserted_;
  unsigned int predictedBlockSize_;
};

#endif /* IntCache_H */
