/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef EncodeBuffer_H
#define EncodeBuffer_H

#include "OpcodeCache.h"
#include "StatusCache.h"

class IntCache;
class CharCache;
class XidCache;
class PositionCache;

#define ENCODE_BUFFER_DEFAULT_SIZE        16384

//
// This should match the maximum size of
// a single message added to write buffer
// (see WriteBuffer.h).
//

#define ENCODE_BUFFER_OVERFLOW_SIZE       4194304

//
// Adjust for at least 3 control messages
// and frame length (see in Proxy.cpp).
//

#define ENCODE_BUFFER_PREFIX_SIZE         20

class EncodeBuffer
{
  public:

  EncodeBuffer();

  ~EncodeBuffer();

  void setSize(unsigned int initialSize, unsigned int thresholdSize,
                   unsigned int maximumSize);

  void fullReset();

  void encodeBool(unsigned int value)
  {
    encodeValue(value, 1);
  }

  void encodeValue(unsigned int value, unsigned int numBits,
                       unsigned int blockSize = 0);

  void encodeCachedValue(unsigned int value, unsigned int numBits,
                             IntCache &cache, unsigned int blockSize = 0);

  void encodeCachedValue(unsigned char value, unsigned int numBits,
                             CharCache &cache, unsigned int blockSize = 0);

  void encodeOpcodeValue(unsigned char next, OpcodeCache &cache)
  {
    encodeCachedValue(next, 8, cache.base_[cache.slot_], 8);

    cache.slot_ = next;
  }

  void encodeStatusValue(unsigned char next, StatusCache &cache)
  {
    encodeCachedValue(next, 2, cache.base_[cache.slot_]);

    cache.slot_ = next;
  }

  void encodePositionValue(short int next, PositionCache &cache);

  void encodeXidValue(unsigned int next, XidCache &cache);

  void encodeXidValue(unsigned int next, unsigned int last, XidCache &cache);

  void encodeMemory(const unsigned char *buffer, unsigned int numBytes);

  unsigned char *getData()
  {
    return buffer_;
  }

  unsigned int getLength() const;

  unsigned int getBits();

  private:

  void growBuffer(unsigned int numBytes = 0);

  void alignBuffer();

  unsigned int size_;
  unsigned char *buffer_;

  //
  // This points to byte just
  // beyond end of buffer.
  //

  const unsigned char *end_;

  unsigned char *nextDest_;
  unsigned int destShift_;
  unsigned int cumulativeBits_;

  unsigned int initialSize_;
  unsigned int thresholdSize_;
  unsigned int maximumSize_;
};

#endif /* EncodeBuffer_H */
