/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include <X11/X.h>
#include <X11/Xproto.h>
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "servermd.h"
#include "Agent.h"

#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>

#include "Display.h"
#include "Options.h"
#include "Error.h"
#include "Init.h"
#include "Args.h"
#include "Icon.h"

#ifndef NXAGENT_NEVERSS
#include "screensaver"
#endif

#if defined(NXAGENT_FONTCACHE) || defined(NXAGENT_FONTMATCH)
#include "Font.h"
#endif

#ifdef NXAGENT_RECONNECT
#include "Reconnect.h"
#endif

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  WATCH

#ifdef WATCH
#include "unistd.h"
#endif

Bool nxagentUseNXTrans;

#ifdef NXAGENT_MVFB

Bool nxagentTrue24 = False;

#endif

Display *nxagentDisplay = NULL;
XVisualInfo *nxagentVisuals;
int nxagentNumVisuals;

#ifdef NXAGENT_RECONNECT

static XVisualInfo *nxagentVisualsRecBackup;
static int nxagentNumVisualsRecBackup;
static int nxagentNumDefaultColormapsRecBackup;
static int *nxagentDepthsRecBackup;
static int nxagentNumDepthsRecBackup;
static int nxagentNumPixmapFormatsRecBackup;
static XPixmapFormatValues *nxagentPixmapFormatsRecBackup;
static int DisplayWidthRecBackup;
static int DisplayHeightRecBackup;
static enum
{
  NOTHING = 0,
  OPENED,
  GOT_VISUAL_INFO,
  ALLOC_DEF_COLORMAP,
  GOT_DEPTH_LIST,
  GOT_PIXMAP_FORMAT_LIST,
  EVERYTHING_DONE
} reconnectDisplayState;

extern void NXFreeCache(void);

#endif

int nxagentDefaultVisualIndex;
Colormap *nxagentDefaultColormaps;
int nxagentNumDefaultColormaps;
int *nxagentDepths;
int nxagentNumDepths;
XPixmapFormatValues *nxagentPixmapFormats;
int nxagentNumPixmapFormats;
Pixel nxagentBlackPixel;
Pixel nxagentWhitePixel;
Drawable nxagentDefaultDrawables[MAXDEPTH + 1];
Pixmap nxagentScreenSaverPixmap;

/*
 * Also used in Cursor.c. There are huge problems
 * using GC definition. This is to be reworked.
 */

XlibGC nxagentBitmapGC;

/*
 * The "confine" window is used in the nxagentConstrainCursor
 * procedure. We are currently overriding the original Xnest
 * behaviour. It is unclear what this window is used for.
 */

Window nxagentConfineWindow;

/*
 * Keyboard and pointer are handled as they were real devices by
 * Xnest and we inherit this behaviour. The following mask will
 * contain the event mask selected for the root window of the
 * agent. All the keyboard and pointer events will be translated
 * by the agent and sent to the internal clients according to
 * events selected by the inferior windows.
 */

unsigned long nxagentEventMask = 0x0;

Pixmap nxagentIconPixmap;
Pixmap nxagentIconShape;
Bool useXpmIcon = False;
Bool getNXIcon(Display *display, Pixmap *nxIcon, Pixmap *nxMask);

#ifdef NXAGENT_LOGO
  int nxagent_depth;
  int nxagent_white, nxagent_red, nxagent_black;
  XVisualInfo pV;
  unsigned int r, b, g, or, ob, og, off;
#endif

#ifdef NXAGENT_TIMESTAMP
unsigned long startTime;
#endif

#ifdef NXAGENT_LOGO
  unsigned int nxLogoColor(unsigned int colorin){
      /*
       take a color values in rgb24 0xff0000 0x00ff00 0x0000ff
       and spit you a equivalent for your visual
       */
      int cr=0, cg=0, cb=0;

      cr = (colorin >> or)&r;
      cg = (colorin >> (og-8))&g;
      cb = (colorin >> (ob-16))&b;
      return cr| cg| cb;
  }

  void nxQC(Display *d, Colormap c){
      XColor X;
      X.pixel = 0xff;
      X.pad = 0;
      X.flags = 0;
      XQueryColor(d,c,&X);
      fprintf(stderr, "XQUERY: %x %x %x\n", X.red, X.blue, X.green);
  }

#endif

/*
 * FIXME: This must be moved to Error.c.
 */

int nxagentIOErrorHandler(Display *display)
{
  #ifdef NXAGENT_RECONNECT

  if (nxagentOption(Persistent))
  {
    #ifdef NXAGENT_RECONNECT_DEBUG
    fprintf(stderr, "Display: IOerror handler going to longjmp.\n");
    #endif

    /*
     * FIXME: Should ensure that a jump context has been set.
     */ 

    longjmp(pauseByError, 1);
  }

  #endif

  XSetIOErrorHandler(NULL);

  CloseWellKnownConnections();

  FatalError("NXAGENT: Fatal IO error on display \"%s\".\n", nxagentDisplayName);

  return 0;
}

void nxagentOpenDisplay(argc, argv)
     int argc;
     char *argv[];
{
  XVisualInfo vi;
  long mask;
  int i;

  if (!nxagentDoFullGeneration) return;

#ifdef NXAGENT_TIMESTAMP
  startTime = GetTimeInMillis();
  fprintf(stderr, "Display: Going to open Display on real X server time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
#endif

#ifdef NXAGENT_RECONNECT
  if (nxagentOption(Persistent))
    nxagentInitReconnector();
#endif

  if (*nxagentDisplayName == '\0')
  {
    strncpy(nxagentDisplayName, XDisplayName(NULL), 1023);

    nxagentDisplayName[1023] = '\0';
  }

  XSetIOErrorHandler(nxagentIOErrorHandler);

  nxagentCloseDisplay();

  nxagentDisplay = XOpenDisplay(nxagentDisplayName);

  #ifdef TEST
  fprintf(stderr, "nxagentOpenDisplay: Display image order is [%d] bitmap order is [%d].\n",
              ImageByteOrder(nxagentDisplay), BitmapBitOrder(nxagentDisplay));

  fprintf(stderr, "nxagentOpenDisplay: Display scanline unit is [%d] scanline pad is [%d].\n",
              BitmapUnit(nxagentDisplay), BitmapPad(nxagentDisplay));
  #endif

  if (nxagentDisplay == NULL)
  {
    FatalError("NXAGENT: Unable to open display \"%s\".\n", nxagentDisplayName);
  }
 
  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 1.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
#1   U  1	1	256 bits (0 KB) ->	150 bits (0 KB) ->	256/1 -> 150/1	= 1.707:1
#20     1	1	119104 bits (15 KB) ->	28 bits (0 KB) ->	119104/1 -> 28/1	= 4253.714:1
#98     2		512 bits (0 KB) ->	84 bits (0 KB) ->	256/1 -> 42/1	= 6.095:1
*/

  sleep(60);

  #endif

#ifdef NXAGENT_ERRORH
  XSetErrorHandler((XErrorHandler)nxagentErrorHandler);
#endif

#ifdef NXAGENT_TIMESTAMP
  fprintf(stderr, "Display: display on real X opened, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
#endif

  nxagentUseNXTrans =
      nxagentPostProcessArgs(nxagentDisplayName, nxagentDisplay,
                                 DefaultScreenOfDisplay(nxagentDisplay));

  if (nxagentSynchronize)
    XSynchronize(nxagentDisplay, True);

  mask = VisualScreenMask;
  vi.screen = DefaultScreen(nxagentDisplay);
  nxagentVisuals = XGetVisualInfo(nxagentDisplay, mask, &vi, &nxagentNumVisuals);
  if (nxagentNumVisuals == 0 || nxagentVisuals == NULL)
    FatalError("Unable to find any visuals.\n");

  if (nxagentUserDefaultClass || nxagentUserDefaultDepth) {
    nxagentDefaultVisualIndex = UNDEFINED;
    for (i = 0; i < nxagentNumVisuals; i++)
      if ((!nxagentUserDefaultClass ||
           nxagentVisuals[i].class == nxagentDefaultClass)
          &&
          (!nxagentUserDefaultDepth ||
           nxagentVisuals[i].depth == nxagentDefaultDepth)) {
        nxagentDefaultVisualIndex = i;
        break;
      }
    if (nxagentDefaultVisualIndex == UNDEFINED)
      FatalError("Unable to find desired default visual.\n");
  }
  else {
    vi.visualid = XVisualIDFromVisual(DefaultVisual(nxagentDisplay,
                                      DefaultScreen(nxagentDisplay)));
    nxagentDefaultVisualIndex = 0;
    for (i = 0; i < nxagentNumVisuals; i++)
      if (vi.visualid == nxagentVisuals[i].visualid)
        nxagentDefaultVisualIndex = i;
  }

  nxagentNumDefaultColormaps = nxagentNumVisuals;
  nxagentDefaultColormaps = (Colormap *)xalloc(nxagentNumDefaultColormaps *
                                             sizeof(Colormap));
  for (i = 0; i < nxagentNumDefaultColormaps; i++)
    nxagentDefaultColormaps[i] = XCreateColormap(nxagentDisplay,
                                               DefaultRootWindow(nxagentDisplay),
                                               nxagentVisuals[i].visual,
                                               AllocNone);

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 4.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

  sleep(30);

  #endif

  nxagentBlackPixel = BlackPixel(nxagentDisplay, DefaultScreen(nxagentDisplay));
  nxagentWhitePixel = WhitePixel(nxagentDisplay, DefaultScreen(nxagentDisplay));

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 5.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

  sleep(30);

  #endif

  /*
   * Initialize the agent's event mask that will be requested
   * for the root and all the top level windows. If the nested
   * window is a child of an existing window, we will need to
   * receive StructureNotify events. If we are going to manage
   * the changes in root window's visibility we'll also need
   * VisibilityChange events.
   */

/*
FIXME: Use of nxagentParentWindow is strongly deprecated.
       We need also to clarify which events are selected
       in the diferent operating modes.
*/
  if (nxagentParentWindow != (Window) 0)
  {
    nxagentEventMask |= StructureNotifyMask;
  }
  else
  {
    #ifdef NXAGENT_VISIBILITY

    nxagentEventMask |= (StructureNotifyMask | VisibilityChangeMask);

    #endif
  }

  /*
   * Get the pixmap depths and format supported
   * by the real display.
   */
   
  nxagentGetDepthsAndPixmapFormats();

  /*
   * Create a pixmap for each depth matching the
   * local supported formats with format available
   * on the remote display.
   */
   
  nxagentSetDefaultDrawables();

  /*
   * This GC is referenced in Cursor.c. It can be
   * probably removed.
   */

  nxagentBitmapGC = XCreateGC(nxagentDisplay, nxagentDefaultDrawables[1], 0L, NULL);

  /*
   * Note that this "confine window" is useless at the
   * moment as we reimplement nxagentConstrainCursor()
   * to skip the "constrain" stuff.
   */

  #ifdef TEST
  fprintf(stderr, "nxagentOpenDisplay: Going to create agent's confine window.\n");
  #endif

  nxagentConfineWindow = XCreateWindow(nxagentDisplay,
                                       DefaultRootWindow(nxagentDisplay),
                                       0, 0, 1, 1, 0, 0,
                                       InputOnly,
                                       CopyFromParent,
                                       0L, NULL);

  #ifdef TEST
  fprintf(stderr, "nxagentOpenDisplay: Created agent's confine window with id [%ld].\n",
              nxagentConfineWindow);
  #endif

  if (!(nxagentUserGeometry & XValue))
  {
    nxagentChangeOption(X, 0);
  }

  if (!(nxagentUserGeometry & YValue))
  {
    nxagentChangeOption(Y, 0);
  }

  if (nxagentParentWindow == 0)
  {
    if (!(nxagentUserGeometry & WidthValue))
    {
      nxagentChangeOption(Width, 3 * DisplayWidth(nxagentDisplay,
                                         DefaultScreen(nxagentDisplay)) / 4);
    }

    if (!(nxagentUserGeometry & HeightValue))
    {
      nxagentChangeOption(Height, 3 * DisplayHeight(nxagentDisplay,
                                          DefaultScreen(nxagentDisplay)) / 4);
    }
  }

  if (!nxagentUserBorderWidth)
  {
    nxagentChangeOption(BorderWidth, 1);
  }

#ifndef NXAGENT_LOGO
  nxagentIconPixmap =
    XCreateBitmapFromData(nxagentDisplay,
                          DefaultRootWindow(nxagentDisplay),
                          (char *) nxagentDefaultIconBits,
                          nxagentDefaultIconWidth,
                          nxagentDefaultIconHeight);
#else

  nxagent_depth = DefaultDepth(nxagentDisplay,
                               DefaultScreen(nxagentDisplay)
                              );

  pV = nxagentVisuals[nxagentDefaultVisualIndex];

  r = pV.red_mask;
  g = pV.green_mask;
  b = pV.blue_mask;
  if(!pV.red_mask|| !pV.green_mask|| !pV.blue_mask){
      nxagent_black = 0x000000;
      nxagent_red   = 0xff0000;
      nxagent_white = 0xffffff;
  }
  else
  {
      for(or=0,off=0x800000;(r&(off>>or)) == 0; or++);
      for(og=0,off=0x800000;(g&(off>>og)) == 0; og++);
      for(ob=0,off=0x800000;(b&(off>>ob)) == 0; ob++);
      nxagent_red   = nxLogoColor(0xff0000);
      nxagent_black = nxLogoColor(0x000000);
      /* nxagent_white = nxLogoColor(0xffffff); */
      nxagent_white = 0xffffff;
  }

#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "mask r: %x g: %x b: %x\n", r, g, b);
  fprintf(stderr, "offset r: %d g: %d b: %d\n", or, og, ob);
#endif

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 5.1.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

  sleep(30);

  #endif

  useXpmIcon = getNXIcon(nxagentDisplay, &nxagentIconPixmap, &nxagentIconShape);

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 5.2.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
#84     2		512 bits (0 KB) ->	76 bits (0 KB) ->	256/1 -> 38/1	= 6.737:1
*/

  sleep(30);

  #endif

#endif

#ifndef NXAGENT_NEVERSS
  nxagentScreenSaverPixmap =
    XCreatePixmapFromBitmapData(nxagentDisplay,
                                DefaultRootWindow(nxagentDisplay),
                                (char *)screensaver_bits,
                                screensaver_width,
                                screensaver_height,
                                nxagentWhitePixel,
                                nxagentBlackPixel,
                                DefaultDepth(nxagentDisplay,
                                DefaultScreen(nxagentDisplay)));
#endif

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenDisplay: Watchpoint 6.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

  sleep(30);

  #endif

#ifdef NXAGENT_TIMESTAMP
  fprintf(stderr, "Display: nxagentOpenDisplay finished, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
#endif
#ifdef NXAGENT_RECONNECT
  if (nxagentOption(Persistent))
    reconnectDisplayState = EVERYTHING_DONE;
#endif
}

void nxagentGetDepthsAndPixmapFormats()
{
  nxagentDepths = XListDepths(nxagentDisplay, DefaultScreen(nxagentDisplay),
                                  &nxagentNumDepths);

  nxagentPixmapFormats = XListPixmapFormats(nxagentDisplay, &nxagentNumPixmapFormats);

  if (nxagentDepths == NULL || nxagentPixmapFormats == NULL)
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentGetDepthsAndPixmapFormats: PANIC! Failed to get available depths and pixmap formats.\n");
    #endif

    FatalError("Error: Failed to get available depths and pixmap formats.");
  }

  #ifdef TEST
  fprintf(stderr, "nxagentGetDepthsAndPixmapFormats: Got [%d] depths and [%d] available pixmap formats.\n",
              nxagentNumDepths, nxagentNumPixmapFormats);
  #endif
}

void nxagentSetDefaultDrawables()
{
  int i, j;

  for (i = 0; i <= MAXDEPTH; i++)
  {
    nxagentDefaultDrawables[i] = None;
  }

  for (i = 0; i < nxagentNumPixmapFormats; i++)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentSetDefaultDrawables: Checking remote pixmap format [%d] with depth [%d] "
                "bits per pixel [%d] scanline pad [%d].\n", i, nxagentPixmapFormats[i].depth,
                    nxagentPixmapFormats[i].bits_per_pixel, nxagentPixmapFormats[i].scanline_pad);
    #endif

    if (nxagentPixmapFormats[i].depth == 24)
    {
      if (nxagentPixmapFormats[i].bits_per_pixel == 24)
      {
        #ifdef TEST
        fprintf(stderr, "nxagentSetDefaultDrawables: WARNING! Assuming remote pixmap "
                    "format [%d] as true 24 bits.\n", i);
        #endif

        nxagentTrue24 = True;
      }
    }

    for (j = 0; j < nxagentNumDepths; j++)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentSetDefaultDrawables: Cheching depth at index [%d] with pixmap depth [%d] "
                  "and display depth [%d].\n", j, nxagentPixmapFormats[i].depth, nxagentDepths[j]);
      #endif

      if ((nxagentPixmapFormats[i].depth == 1 ||
              nxagentPixmapFormats[i].depth == nxagentDepths[j]) &&
                  nxagentDefaultDrawables[nxagentPixmapFormats[i].depth] == None)
      {
        nxagentDefaultDrawables[nxagentPixmapFormats[i].depth] =
            XCreatePixmap(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                              1, 1, nxagentPixmapFormats[i].depth);

        #ifdef TEST
        fprintf(stderr, "nxagentSetDefaultDrawables: Created default drawable for depth [%d].\n",
                    nxagentPixmapFormats[i].depth);
        #endif
      }
    }

    if (nxagentDefaultDrawables[nxagentPixmapFormats[i].depth] == None)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentSetDefaultDrawables: WARNING! Forcing default drawable for depth [%d].\n",
                  nxagentPixmapFormats[i].depth);
      #endif

      nxagentDefaultDrawables[nxagentPixmapFormats[i].depth] =
          XCreatePixmap(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                            1, 1, nxagentPixmapFormats[i].depth);
    }
  }
}

void nxagentSetScreenInfo(ScreenInfo *screenInfo)
{
  /*
   * Setup global screen info parameters. In the Xnest
   * server this stuff is done after having opened the
   * real display as Xnest lets the screen reflect the
   * order of the remote end. Agent will instead set
   * the order according to local endianess and swap
   * data whenever it is appropriate.
   *
   * From a standard implementation:
   *
   * screenInfo->imageByteOrder = IMAGE_BYTE_ORDER;
   * screenInfo->bitmapScanlinePad = BITMAP_SCANLINE_PAD;
   * screenInfo->bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
   * screenInfo->bitmapBitOrder = BITMAP_BIT_ORDER;
   *
   * From Xnest implementation:
   *
   * screenInfo -> imageByteOrder = ImageByteOrder(nxagentDisplay);
   * screenInfo -> bitmapScanlineUnit = BitmapUnit(nxagentDisplay);
   * screenInfo -> bitmapScanlinePad = BitmapPad(nxagentDisplay);
   * screenInfo -> bitmapBitOrder = BitmapBitOrder(nxagentDisplay);
   */

  screenInfo -> imageByteOrder = IMAGE_BYTE_ORDER;
  screenInfo -> bitmapScanlinePad = BITMAP_SCANLINE_PAD;
  screenInfo -> bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
  screenInfo -> bitmapBitOrder = BITMAP_BIT_ORDER;

  #ifdef TEST
  fprintf(stderr, "nxagentSetScreenInfo: Server image order is [%d] bitmap order is [%d].\n",
              screenInfo -> imageByteOrder, screenInfo -> bitmapBitOrder);

  fprintf(stderr, "nxagentSetScreenInfo: Server scanline unit is [%d] scanline pad is [%d].\n",
              screenInfo -> bitmapScanlineUnit, screenInfo -> bitmapScanlinePad);
  #endif
}

void nxagentSetPixmapFormats(ScreenInfo *screenInfo)
{
  int i, j, k;

  /*
   * This should be set to a constant and formats created
   * accordingly and not matched from what is supported on
   * the real display. Supporting only what is supported
   * by the remote end makes troublesome to handle migra-
   * tion of session to different displays.
   */

  screenInfo -> numPixmapFormats = 0;

  for (i = 0; i < nxagentNumPixmapFormats; i++)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentSetPixmapFormats: Checking remote pixmap format [%d] with depth [%d] "
                "bits per pixel [%d] scanline pad [%d].\n", i, nxagentPixmapFormats[i].depth,
                    nxagentPixmapFormats[i].bits_per_pixel, nxagentPixmapFormats[i].scanline_pad);
    #endif

    for (j = 0, k = 0; j < nxagentNumDepths; j++)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentSetPixmapFormats: Cheching depth at index [%d] with pixmap depth [%d] "
                  "and display depth [%d].\n", j, nxagentPixmapFormats[i].depth, nxagentDepths[j]);
      #endif

      if ((nxagentPixmapFormats[i].depth == 1) ||
              (nxagentPixmapFormats[i].depth == nxagentDepths[j]))
      {
        screenInfo -> formats[screenInfo -> numPixmapFormats].depth =
                                  nxagentPixmapFormats[i].depth;

        screenInfo -> formats[screenInfo -> numPixmapFormats].bitsPerPixel =
                                  nxagentPixmapFormats[i].bits_per_pixel;

        screenInfo -> formats[screenInfo -> numPixmapFormats].scanlinePad =
                                  nxagentPixmapFormats[i].scanline_pad;

        #ifdef TEST
        fprintf(stderr, "nxagentSetPixmapFormats: Set format at index [%d] to depth [%d] "
                    "bits per pixel [%d] scanline pad [%d].\n", screenInfo -> numPixmapFormats,
                        screenInfo -> formats[screenInfo -> numPixmapFormats].depth,
                            screenInfo -> formats[screenInfo -> numPixmapFormats].bitsPerPixel,
                                screenInfo -> formats[screenInfo -> numPixmapFormats].scanlinePad);
        #endif

        k = 1;

        break;
      }
    }

    if (k == 0)
    {
      #ifdef TEST
      fprintf(stderr, "nxagentSetPixmapFormats: WARNING! Couldn't set remote pixmap format with depth [%d].\n",
                  nxagentPixmapFormats[i].depth);
      #endif

      screenInfo -> formats[screenInfo -> numPixmapFormats].depth =
                                nxagentPixmapFormats[i].depth;

      screenInfo -> formats[screenInfo -> numPixmapFormats].bitsPerPixel =
                                nxagentPixmapFormats[i].bits_per_pixel;

      screenInfo -> formats[screenInfo -> numPixmapFormats].scanlinePad =
                                nxagentPixmapFormats[i].scanline_pad;

      #ifdef TEST
      fprintf(stderr, "nxagentSetPixmapFormats: WARNING! Forcing format at index [%d] as depth [%d] "
                  "bits per pixel [%d] scanline pad [%d].\n", screenInfo -> numPixmapFormats,
                      screenInfo -> formats[screenInfo -> numPixmapFormats].depth,
                          screenInfo -> formats[screenInfo -> numPixmapFormats].bitsPerPixel,
                              screenInfo -> formats[screenInfo -> numPixmapFormats].scanlinePad);
      #endif
    }

    screenInfo -> numPixmapFormats++;
  }


  #ifdef TEST
  fprintf(stderr, "nxagentSetPixmapFormats: Set number of pixmap formats to [%d].\n",
              screenInfo -> numPixmapFormats);
  #endif
}

void nxagentCloseDisplay()
{
  if (!nxagentDoFullGeneration || !nxagentDisplay) return;

  /*
    If nxagentDoFullGeneration all x resources will be destroyed upon closing
    the display connection.  There is no need to generate extra protocol.
    */

  xfree(nxagentDefaultColormaps);
  XFree(nxagentVisuals);
  XFree(nxagentDepths);
  XFree(nxagentPixmapFormats);
#ifdef NXAGENT_FONTCACHE
  nxagentFreeFontCache();
#endif

/*
#ifdef NXAGENT_FONTMATCH
  nxagentFreeFontMatchStuff();
#endif
*/
  XCloseDisplay(nxagentDisplay);
}


Bool nxagentXPipeOK(int port)
{
  struct stat pipeStat;
  char szName[80];
  sprintf(szName, "/tmp/.X11-unix/X%d", port);
  if  (stat(szName, &pipeStat) == 0)
  {
    if (remove(szName) == 0)
    {
      sprintf(szName, "/tmp/.X%d-lock", port);
      if  (stat(szName, &pipeStat) == 0)
      {
        return (remove(szName) == 0);
      }
      return True;
    }
    return False;
  }
  sprintf(szName, "/tmp/.X%d-lock", port);
  if  (stat(szName, &pipeStat) == 0)
  {
     return (remove(szName) == 0);
  }
  return True;
}

Bool getNXIcon(Display *display, Pixmap *nxIcon, Pixmap *nxMask)
{
  char *env_path = getenv("PATH");
  int lenght_env_path = 0;
  char icon_filename [256];
  char default_path [256];
  char *icon_path = malloc( strlen(env_path) + sizeof(icon_filename) );
  FILE *icon_fp;
  int status;
  Bool existXpmIcon = False;

  Pixmap IconPixmap;
  Pixmap IconShape;

  if (env_path == NULL)
    lenght_env_path = 0;
  else
    lenght_env_path = strlen(env_path) + 1;
  strncpy(icon_filename, "", 255);
  strncpy(default_path, "", 255);

  strcat(icon_filename, NXAGENT_ICON_NAME);
  strcat(default_path,"/usr/NX/share/");
  strcat(default_path,icon_filename);

  if ((icon_fp = fopen(default_path, "r")) == NULL)
  {
    char *s;
    char *temp_path = malloc(lenght_env_path + strlen(icon_filename) );
    char *temp_path1 = malloc(lenght_env_path + strlen(icon_filename) );

    strncpy(temp_path, env_path, strlen(env_path));
    strncpy(temp_path1, "", lenght_env_path + strlen(icon_filename) );

    while ( strlen(temp_path) > 0)
    {
       s = strpbrk (temp_path, ":");
       if (s == NULL) break;

       strncpy ( temp_path1, temp_path , strlen(temp_path) - strlen(s) );
       strncat ( temp_path1, "/", 1);
       strncat ( temp_path1, icon_filename, strlen(icon_filename));
       if ((icon_fp = fopen(temp_path1, "r")) != NULL)
       {
          fclose (icon_fp);
          existXpmIcon = True;
          strcpy(icon_path,temp_path1);
          break;
       }
       strncpy(temp_path1, "", lenght_env_path + strlen(icon_filename) );
       strncpy(temp_path1, s + 1, strlen(s)-1);
       strncpy(temp_path, "", lenght_env_path + strlen(icon_filename) );
       strcpy(temp_path, temp_path1 );
       strncpy(temp_path1, "", lenght_env_path + strlen(icon_filename) );
     }
     free(temp_path);
     free(temp_path1);
  }
  else
  {
     fclose (icon_fp);
     existXpmIcon = True;
     strcpy(icon_path, default_path);
  }

  if (existXpmIcon)
  {
     status = XpmReadFileToPixmap(display,
                                 DefaultRootWindow(display),
                               icon_path,
                               &IconPixmap,
                               &IconShape,
                               NULL);
     if (status != XpmSuccess) {
        fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
        /* exit(1); */
        existXpmIcon = False;
     }
  }

  if (!existXpmIcon)
  {
     IconPixmap = XCreatePixmapFromBitmapData(display,
                                        DefaultRootWindow(display),
                                        (char *) nxagentDefaultIconBits,
                                        nxagentDefaultIconWidth,
                                        nxagentDefaultIconHeight,
                                        nxagent_red,
                                        nxagent_white,
                                        DefaultDepth(display, DefaultScreen(display)));
     IconShape = 0;
  }

  free(icon_path);
  *nxIcon = IconPixmap;
  *nxMask = IconShape;
  return existXpmIcon;
}

#ifdef NXAGENT_RECONNECT

void nxagentBackupDisplayInfo(void)
{
#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_DEBUG)
  fprintf(stderr, "nxagentBackupDisplayInfo\n");
#endif

  nxagentPixmapFormatsRecBackup = nxagentPixmapFormats;
  nxagentNumPixmapFormatsRecBackup = nxagentNumPixmapFormats;
  nxagentDepthsRecBackup = nxagentDepths; 
  nxagentNumDepthsRecBackup = nxagentNumDepths; 
  nxagentNumDefaultColormapsRecBackup = nxagentNumDefaultColormaps;
  nxagentVisualsRecBackup = nxagentVisuals;
  nxagentNumVisualsRecBackup = nxagentNumVisuals;
  DisplayWidthRecBackup = DisplayWidth(nxagentDisplay, DefaultScreen(nxagentDisplay));
  DisplayHeightRecBackup = DisplayHeight(nxagentDisplay, DefaultScreen(nxagentDisplay));
}

void nxagentCleanBackupDisplayInfo(void)
{
#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_DISPLAY_DEBUG)
  fprintf(stderr, "nxagentCleanBackupDisplayInfo\n");
#endif

  xfree(nxagentPixmapFormatsRecBackup);
  nxagentNumPixmapFormatsRecBackup = 0;

  xfree(nxagentDepthsRecBackup);
  nxagentNumDepthsRecBackup = 0;

  nxagentNumDefaultColormapsRecBackup = 0;

  xfree(nxagentVisualsRecBackup);
  nxagentNumVisualsRecBackup = 0;

  DisplayWidthRecBackup = 0;
  DisplayHeightRecBackup = 0;
}

void nxagentDisconnectDisplay(void)
{
  extern Display *nxagentDisplay;
  
#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_DISPLAY_DEBUG)
  fprintf(stderr, "nxagentDisconnectDisplay\n");
#endif

  switch (reconnectDisplayState)
  {
    case EVERYTHING_DONE:
    case GOT_PIXMAP_FORMAT_LIST:
    case GOT_DEPTH_LIST:
    case ALLOC_DEF_COLORMAP:
      xfree(nxagentDefaultColormaps);
    case GOT_VISUAL_INFO:
    case OPENED:
      XCloseDisplay(nxagentDisplay);
    case NOTHING:
      break;
    default:
      FatalError("nxagentDisconnectDisplay: Display is in unknown state. Can't continue.");
  }
  
  reconnectDisplayState = NOTHING;
}

static Bool checkForGeometryCompatibility(int flexibility)
{
  extern Display *nxagentDisplay;
  
  return ((DisplayWidth(nxagentDisplay, DefaultScreen(nxagentDisplay)) == DisplayWidthRecBackup) &&
          (DisplayHeight(nxagentDisplay, DefaultScreen(nxagentDisplay)) == DisplayHeightRecBackup));
}
          
static Bool checkForVisualsCompatibility(int flexibility)
{
  /* 
   * FIXME: This is not yet smart enough but
   * it does its job in testing reconnection.
   */

  int i; 
        
  if (nxagentNumVisuals != nxagentNumVisualsRecBackup)
    return False;

  for (i = 0; i < nxagentNumVisuals; i++)
  {
    if ((nxagentVisuals[i].depth != nxagentVisualsRecBackup[i].depth) ||
        (nxagentVisuals[i].class != nxagentVisualsRecBackup[i].class) ||
        (nxagentVisuals[i].red_mask != nxagentVisualsRecBackup[i].red_mask) ||
        (nxagentVisuals[i].green_mask != nxagentVisualsRecBackup[i].green_mask) ||
        (nxagentVisuals[i].blue_mask != nxagentVisualsRecBackup[i].blue_mask) ||
        (nxagentVisuals[i].colormap_size != nxagentVisualsRecBackup[i].colormap_size) ||
        (nxagentVisuals[i].bits_per_rgb != nxagentVisualsRecBackup[i].bits_per_rgb))
      return False;
  }

  return True;
}

static Bool checkForColormapCompatibility(int flexibility)
{
  return (nxagentNumDefaultColormaps == nxagentNumDefaultColormapsRecBackup);
}

static Bool checkForDepthCompatibility(int flexibility)
{
  int i;

  if (nxagentNumDepths != nxagentNumDepthsRecBackup)
    return False;

  for (i = 0; i < nxagentNumDepths; i++)
    if (nxagentDepths[i] != nxagentDepthsRecBackup[i])
      return False;

  return True;
}

static Bool checkForPixmapFormatCompatibility(int flexibility)
{
  int i;

  if (nxagentNumPixmapFormats != nxagentNumPixmapFormatsRecBackup)
    return False;

  for (i = 0; i < nxagentNumPixmapFormats; i++)
    if ( (nxagentPixmapFormats[i].depth != nxagentPixmapFormatsRecBackup[i].depth) ||
         (nxagentPixmapFormats[i].bits_per_pixel != nxagentPixmapFormatsRecBackup[i].bits_per_pixel) ||
         (nxagentPixmapFormats[i].scanline_pad != nxagentPixmapFormatsRecBackup[i].scanline_pad) )
      return False;
  
  return True;
} 

Bool nxagentReOpenDisplay(void* p0)
{
  XVisualInfo vi;
  long mask;
  int i, j;
  int flexibility = *(int*)p0;
  int packMethod, packQuality;
  extern int nxagentPackMethod;
  extern int nxagentPackQuality;
  extern int nxagentTightThreshold;
  extern long nxagentStopImgSz;
  extern long nxagentStopKarmaSz;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_DISPLAY_DEBUG)
  fprintf(stderr, "nxagentReOpenDisplay\n");
#endif
  
  if (reconnectDisplayState)
  {
    fprintf(stderr, "nxagentReOpenDisplay: "
                    "trying to reconnect a session uncleanly disconnected\n");
    return False;
  }

  XSetIOErrorHandler(nxagentIOErrorHandler);

  /* We change the state of these globals parameter to initial value. */
  packMethod = nxagentPackMethod;
  packQuality = nxagentPackQuality;
  nxagentPackMethod = -1;
  nxagentPackQuality = -1;
  nxagentTightThreshold = -1;
  nxagentStopImgSz = -1;
  nxagentStopKarmaSz = -1;

  /*
   * FIXME: Should read value of the new display here.
   */
 
  nxagentDisplay = XOpenDisplay(nxagentDisplayName);

  if (nxagentDisplay == NULL)
  {
    return FALSE;
  }
  /* Display state is now OPENED. */
  reconnectDisplayState = OPENED;

  if (!checkForGeometryCompatibility(flexibility))
    return False;

#ifdef NXAGENT_TIMESTAMP
  fprintf(stderr, "Display: display on real X opened, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
#endif

  nxagentUseNXTrans =
      nxagentPostProcessArgs(nxagentDisplayName, nxagentDisplay,
                                 DefaultScreenOfDisplay(nxagentDisplay));

  /* 
   * FIXME: We could free agent cache only when pack method is changed.
   * but we get some problems, perhaps because some methods are changed
   * in nxagentPutImage, it should work anyway !
   */

  NXFreeCache();

  if (nxagentSynchronize)
    XSynchronize(nxagentDisplay, True);

  mask = VisualScreenMask;
  vi.screen = DefaultScreen(nxagentDisplay);
  nxagentVisuals = XGetVisualInfo(nxagentDisplay, mask, &vi, &nxagentNumVisuals);

  /* Display state is now GOT_VISUAL_INFO. */
  reconnectDisplayState = GOT_VISUAL_INFO;

  if (!checkForVisualsCompatibility(flexibility))
    return False;
  
  if (nxagentUserDefaultClass || nxagentUserDefaultDepth)
  {
    nxagentDefaultVisualIndex = UNDEFINED;
    for (i = 0; i < nxagentNumVisuals; i++)
      if ((!nxagentUserDefaultClass ||
           nxagentVisuals[i].class == nxagentDefaultClass) &&
          (!nxagentUserDefaultDepth ||
           nxagentVisuals[i].depth == nxagentDefaultDepth))
      {
        nxagentDefaultVisualIndex = i;
        break;
      }
    if (nxagentDefaultVisualIndex == UNDEFINED)
      FatalError("Unable to find desired default visual.\n");
  }
  else
  {
    vi.visualid = XVisualIDFromVisual(DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)));
    nxagentDefaultVisualIndex = 0;
    for (i = 0; i < nxagentNumVisuals; i++)
      if (vi.visualid == nxagentVisuals[i].visualid)
        nxagentDefaultVisualIndex = i;
  }

  nxagentNumDefaultColormaps = nxagentNumVisuals;
  nxagentDefaultColormaps = (Colormap *)xalloc(nxagentNumDefaultColormaps * sizeof(Colormap));

  /* Display state is now ALLOC_DEF_COLORMAP. */
  reconnectDisplayState = ALLOC_DEF_COLORMAP;
  for (i = 0; i < nxagentNumDefaultColormaps; i++)
    nxagentDefaultColormaps[i] = XCreateColormap(nxagentDisplay,
                                               DefaultRootWindow(nxagentDisplay),
                                               nxagentVisuals[i].visual,
                                               AllocNone);
  if (!checkForColormapCompatibility(flexibility))
    return False;

  nxagentDepths = XListDepths(nxagentDisplay, DefaultScreen(nxagentDisplay),
                            &nxagentNumDepths);

  /* Display state is now GOT_DEPTH_LIST. */
  reconnectDisplayState = GOT_DEPTH_LIST;

  if (!checkForDepthCompatibility(flexibility))
    return False;
  
  nxagentPixmapFormats = XListPixmapFormats(nxagentDisplay,
                                          &nxagentNumPixmapFormats);

  /* Display state is now GOT_PIXMAP_FORMAT_LIST. */
  reconnectDisplayState = GOT_PIXMAP_FORMAT_LIST;

  if (!checkForPixmapFormatCompatibility(flexibility))
    return False;

  nxagentBlackPixel = BlackPixel(nxagentDisplay, DefaultScreen(nxagentDisplay));
  nxagentWhitePixel = WhitePixel(nxagentDisplay, DefaultScreen(nxagentDisplay));

  /*
   * Initialize the agent's event mask that will be requested
   * for the root or all the top level windows. If the nested
   * window is a child of an existing window we will need to
   * receive StructureNotify events. If we are going to manage
   * the changes in root window's visibility we'll also need
   * VisibilityChange events.
   */

  if (nxagentParentWindow != (Window) 0)
  {
    nxagentEventMask |= StructureNotifyMask;
  }
  else
  {
    #ifdef NXAGENT_VISIBILITY

    nxagentEventMask |= (VisibilityChangeMask | StructureNotifyMask);

    #endif
  }

  for (i = 0; i <= MAXDEPTH; i++)
    nxagentDefaultDrawables[i] = None;

  for (i = 0; i < nxagentNumPixmapFormats; i++)
  {
#ifdef NXAGENT_MVFB
    if (nxagentPixmapFormats[i].depth == 24)
    {
      if (nxagentPixmapFormats[i].bits_per_pixel == 24)
      {
        nxagentTrue24 = True;
      }
    }
#endif
    for (j = 0; j < nxagentNumDepths; j++)
      if (nxagentPixmapFormats[i].depth == 1 ||
          nxagentPixmapFormats[i].depth == nxagentDepths[j])
      {
        nxagentDefaultDrawables[nxagentPixmapFormats[i].depth] =
        XCreatePixmap(nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                      1, 1, nxagentPixmapFormats[i].depth);
#ifdef NXAGENT_RECONNECT_DISPLAY_DEBUG
        XSync(nxagentDisplay, False);
        fprintf(stderr, "nxagentReOpenDisplay: XCreate nxagentDefaultDrawables[%d] - ID %lx\n",
                        nxagentPixmapFormats[i].depth, 
                        nxagentDefaultDrawables[nxagentPixmapFormats[i].depth]);
#endif
      }
  }

  nxagentBitmapGC = XCreateGC(nxagentDisplay, nxagentDefaultDrawables[1], 0L, NULL);

  #ifdef TEST
  fprintf(stderr, "nxagentReOpenDisplay: Going to create agent's confine window.\n");
  #endif

  nxagentConfineWindow = XCreateWindow(nxagentDisplay,
                                     DefaultRootWindow(nxagentDisplay),
                                     0, 0, 1, 1, 0, 0,
                                     InputOnly,
                                     CopyFromParent,
                                     0L, NULL);

  #ifdef TEST
  fprintf(stderr, "nxagentReOpenDisplay: Created agent's confine window with id [%ld].\n",
              nxagentConfineWindow);
  #endif

  if (!(nxagentUserGeometry & XValue))
  {
    nxagentChangeOption(X, 0);
  }

  if (!(nxagentUserGeometry & YValue))
  {
    nxagentChangeOption(Y, 0);
  }

  if (nxagentParentWindow == 0)
  {
    if (!(nxagentUserGeometry & WidthValue))
    {
      nxagentChangeOption(Width, 3 * DisplayWidth(nxagentDisplay,
                                         DefaultScreen(nxagentDisplay)) / 4);
    }

    if (!(nxagentUserGeometry & HeightValue))
    {
      nxagentChangeOption(Height, 3 * DisplayHeight(nxagentDisplay,
                                          DefaultScreen(nxagentDisplay)) / 4);
    }
  }

  if (!nxagentUserBorderWidth)
  {
    nxagentChangeOption(BorderWidth, 1);
  }

#ifndef NXAGENT_LOGO
  nxagentIconPixmap =
    XCreateBitmapFromData(nxagentDisplay,
                          DefaultRootWindow(nxagentDisplay),
                          (char *) nxagentDefaultIconBits,
                          nxagentDefaultIconWidth,
                          nxagentDefaultIconHeight);
#else

  nxagent_depth = DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay));

  pV = nxagentVisuals[nxagentDefaultVisualIndex];

  r = pV.red_mask;
  g = pV.green_mask;
  b = pV.blue_mask;
  if(!pV.red_mask|| !pV.green_mask|| !pV.blue_mask)
  {
    nxagent_black = 0x000000;
    nxagent_red   = 0xff0000;
    nxagent_white = 0xffffff;
  }
  else
  {
    for(or=0,off=0x800000;(r&(off>>or)) == 0; or++);
    for(og=0,off=0x800000;(g&(off>>og)) == 0; og++);
    for(ob=0,off=0x800000;(b&(off>>ob)) == 0; ob++);
    nxagent_red   = nxLogoColor(0xff0000);
    nxagent_black = nxLogoColor(0x000000);
    /* nxagent_white = nxLogoColor(0xffffff); */
    nxagent_white = 0xffffff;
  }

#ifdef NXAGENT_LOGO_DEBUG
  fprintf(stderr, "mask r: %x g: %x b: %x\n", r, g, b);
  fprintf(stderr, "offset r: %d g: %d b: %d\n", or, og, ob);
#endif

  useXpmIcon = getNXIcon(nxagentDisplay, &nxagentIconPixmap, &nxagentIconShape);

#endif

#ifndef NXAGENT_NEVERSS
  nxagentScreenSaverPixmap =
    XCreatePixmapFromBitmapData(nxagentDisplay,
                                DefaultRootWindow(nxagentDisplay),
                                (char *)screensaver_bits,
                                screensaver_width,
                                screensaver_height,
                                nxagentWhitePixel,
                                nxagentBlackPixel,
                                DefaultDepth(nxagentDisplay,
                                DefaultScreen(nxagentDisplay)));
#endif
  /* Display state is now EVERYTHING_DONE. */
  reconnectDisplayState = EVERYTHING_DONE;

  return TRUE;
}

#endif /* NXAGENT_RECONNECT */

