/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: list.c,v 3.4 2003/04/07 05:06:46 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>

#include	"murasaki.h"

/*
 * list[0] -> something ... list[i] -> ptr , list[i+1] -> NULL
 */ 
int
add_to_list(char **list,char *ptr,int listmax)
{
	int i;

	/* skip to end */
	for(i = 0;i < listmax - 1 && list[i] != NULL;i++) {
		if (strcmp(list[i],ptr) == 0)
			return GOOD;	/* same one */
	}
	if (i == listmax - 1)
		return INVALID;
	list[i] = ptr;
	list[i+1] = NULL;

	return GOOD;
}

int
count_of_list(char **list)
{
	int i;

	for(i = 0;list[i] != NULL;i++)
		;		
	return i;
}

/*
 * This function does NOT focus on speed.
 * The order of modules is important.
 */
void
remove_from_list(char **list,int idx)
{
	int i;

	/* don't exchange to use module's option */
	for(i = 0;list[i] != NULL;i++) {
		if (i > idx) {
			list[i-1] = list[i];
		}
	}
	list[i-1] = NULL;
}

#ifdef	DEBUG
void
print_list(char **list)
{
	int i;

	for(i = 0;list[i] != NULL;i++)
		DPRINTF(LOG_LEVEL,"list[%d]=\"%s\"",i,list[i]);
}
#endif	/* DEBUG */
