
/*
 * MIXMOS - an oss mixer
 *
 * Copyright (C) 2003 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <linux/soundcard.h>

#define config_filename 	"mixmos"

#define P_READ			1
#define P_WRITE			2

#define null_char		'\0'
#define crlf_char		'\n'
#define space_char		' '
#define comma_char		','
#define under_char		'_'
#define slash 			"/"
#define space 			" "
#define crlf			"\n"
#define dot				"."

#define MAX_LINE_LEN	4096
#define MAX_VALUE_LEN	2048

#define MAX_PATH 		1024

gchar*		s_strcpy		(gchar *dest, const gchar *src, guint maxlength);
gchar*		s_strcat		(gchar *dest, const gchar *src, guint maxlength);


struct mixprefs
{
	gint		window_x;
	gint		window_y;
	gint		window_size_x;
	gint		window_size_y;
	gint		opt_window_x;
	gint		opt_window_y;
	gint		run_counter;
	gint		pane_size;
	gint		save_window_pos;
	gint		enable_pixmaps;
	gint		enable_tooltips;
	gint		enable_labels;
	gint		enable_preset_selector;
	gint		current_preset;
	gint		store_confirmation;
	gchar		preset_1_name[20];
	gchar		preset_2_name[20];
	gchar		preset_3_name[20];
	gchar		preset_4_name[20];
	gchar		labels_font[128];
	gchar		channels_names[SOUND_MIXER_NRDEVICES][16];
	gint		lock_state[4][SOUND_MIXER_NRDEVICES];
	gint		mute_state[4][SOUND_MIXER_NRDEVICES];
	gint		show_state[4][SOUND_MIXER_NRDEVICES];
	gint		a_rec[4];
	gint		a_vol_l[4][SOUND_MIXER_NRDEVICES];
	gint		a_vol_r[4][SOUND_MIXER_NRDEVICES];
};

extern 		struct mixprefs		config;

gchar*	s_getfilename_config	(void);
void	read_config				(void);
void	write_config			(void);


