
/*
 * MIXMOS - an oss mixer
 *
 * Copyright (C) 2003 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

struct struct_mixer
{
	int	present;
	int	channel;
	int	r_channel;
	int	volume_left;
	int	volume_right;
	int	stereo;
	int	mute;
	int	recordable;
	int	record_selected;
};

/* constants */

#define			MAX_VOLUME				100

/* default device */

#define			DEFAULT_MIXER_DEVICE	"/dev/mixer"

/* error codes */

#define			ERR_OPEN				1
#define			ERR_DEVMASK				2
#define			ERR_STEREODEVS			3
#define			ERR_RECSRC				4
#define			ERR_RECMASK				5
#define			ERR_SETVOLUME			6
#define			ERR_ISNOTMONO			7
#define			ERR_ISNOTSTEREO			8
#define			ERR_ISNOTRECORDABLE		9
#define			ERR_NOCHANNEL			10

/* functions */

int				mixer_open						(char *mixer_device);
int				mixer_close						(void);
char*			mixer_get_name					(void);
void			mixer_check_error				(int err_code);

int				mixer_get_channels				(void);
char*			mixer_get_channel_name			(int channel);
int				mixer_get_channel_stereo		(int channel);
int				mixer_get_channel_recordable	(int channel);
int				mixer_get_real_channel			(int channel);
int				mixer_state_read				(void);
void			mixer_state_print				(void);
                                            
int				mixer_set_volume_mono			(int channel, int volume);
int				mixer_set_volume_stereo			(int channel, int volume_left, int volume_right);
int				mixer_set_recordsrc				(int channel);
int				mixer_get_recordsrc				(int channel);

int				mixer_get_volume_l				(int channel);
int				mixer_get_volume_r				(int channel);

