#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <libmb/mb.h>

Display *dpy;
int      screen;
Window   win, win_root;

unsigned char* utf8_arabic="Hello from Arabic ( \357\273\262\357\272\221\357\272\256\357\273\213 ) and now from china : \344\275\240\345\245\275\344\270\255\345\233\275!";

int 
main(int argc, char **argv)
{
  int         i, y = 0;
  XEvent      ev;
  MBFont     *font;
  MBColor    *col;
  MBPixbuf   *pb;
  MBDrawable *drw;
  MBLayout   *layout;
  GC          gc;

  if ((dpy = XOpenDisplay(NULL)) == NULL)
    {
      fprintf(stderr, "%s: Unable to open display!\n", argv[0]);
      exit(1);
    }

  screen   = DefaultScreen(dpy);
  win_root = RootWindow(dpy, screen); 
    
  win = XCreateSimpleWindow(dpy, win_root, 0, 0, 800, 600, 0, None, None); 

  pb = mb_pixbuf_new(dpy, screen);

  gc = XCreateGC(dpy, win_root, 0, NULL);
  XSetForeground(dpy, gc, WhitePixel(dpy, screen));

  // font = mb_font_new (dpy, "Kid Kosmic"); 
 font = mb_font_new_from_string (dpy, "Sans 8 bold"); 

 printf("font size is %i\n", mb_font_get_point_size(font));

  col = mb_col_new_from_spec (pb, "white");

  mb_font_set_color(font, col);

  drw = mb_drawable_new(pb, 800, 600);

  XDrawLine(dpy, mb_drawable_pixmap(drw), gc, 100, 0, 100, 600); 

  for (i = 0; i < 12; i++)
    {
      mb_font_set_point_size (font, i+8);

      mb_col_set (col, "white");

      mb_font_render_simple (font, drw, 0, y, 100, utf8_arabic, 
			     MB_ENCODING_UTF8, 0 );

      mb_font_render_simple (font, drw, 0, y + mb_font_get_height (font), 
			     100, utf8_arabic, 
			     MB_ENCODING_UTF8, 
			     MB_FONT_RENDER_OPTS_CLIP_TRAIL);


      y += (2 * mb_font_get_height (font));
    }



  /*
  mb_font_render_simple (font, drw, 0, mb_font_get_height (font), 
			 80, "External Keyboard" , 
			 MB_ENCODING_UTF8, 
			 MB_FONT_RENDER_OPTS_CLIP_TRAIL);
  */

  /* layout test
  layout = mb_layout_new();

  mb_layout_set_font(layout, font);

  mb_layout_set_text(layout, "External Keyboard",
		     MB_ENCODING_UTF8);

  mb_layout_set_geometry(layout, 80, 600);
  
  mb_layout_render(layout, drw, 0, 0, 0);
  */

  XSetWindowBackgroundPixmap(dpy, win, mb_drawable_pixmap(drw));
  XClearWindow(dpy, win);
  
  XMapWindow(dpy, win);

  XFlush(dpy);

  for (;;) XNextEvent(dpy, &ev);

}
