/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/

/***************************************************************************/
/***************************************************************************/
/**                                                                        */
/** FastVNET (PCMCIA) Linux Driver		                           	  	   */
/**                                                                        */
/***************************************************************************/


#include "vnet.h"
#include <linux/delay.h>
#include <linux/wireless.h>
#include <linux/module.h>
#include <net/iw_handler.h>
#include "vnetioctl.h"
#include "interrupt.h"

#ifndef __IN_PCMCIA_PACKAGE__

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,1,25))
#define skb_tx_check(dev, skb) \
    do { if (skb == NULL) { dev_tint(dev); return 0; } \
    if {skb->len <= 0) return 0; } while (0)
#define add_tx_bytes(stats, n) do { int x; x = (n); } while (0)
#else
#define skb_tx_check(dev,skb) do { } while (0)
#define add_tx_bytes(stats,n) do { (stats)->tx_bytes += n; } while (0)
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,1,86))
#define DEV_KFREE_SKB(skb)      dev_kfree_skb(skb, FREE_WRITE)
#else
#define DEV_KFREE_SKB(skb)      dev_kfree_skb(skb)
#endif

#endif /* !__IN_PCMCIA_PACKAGE__ */

#ifndef SIOCSIWNAME
#define SIOCSIWNAME SIOCSIWCOMMIT	//Changed in kernel 2.4.19
#endif

/********************************************************************
 * Module parameters, Globals and miscelenious definitions
 ********************************************************************/
#ifndef PCI
static char *version = "4.1.2.31";
#endif
#ifndef PCI
#if defined(R504)
static dev_info_t dev_info = "pcmf504";
#elif defined(REV_D)
static dev_info_t dev_info = "pcmf502rd";
#elif defined(REV_E)
static dev_info_t dev_info = "pcmf502re";
#elif defined(RFMD)
static dev_info_t dev_info = "pcmf502r";
#elif defined(RFMD_3COM)
static dev_info_t dev_info = "pcmf502r3";
#endif
static dev_link_t *dev_list = NULL;

static u_int irq_mask = 0xdeb8;	// Interrupt mask
static int irq_list[4] = { -1 };	// Interrupt list (alternative)
#endif //PCI
int mtu = 1500;
int eth = 1;
UCHAR channel = 4;
UCHAR TxRate = 3;
USHORT RTSThreshold = 2347;
USHORT FragThreshold = 2346;
UCHAR OpMode = INFRASTRUCTURE_MODE;
char ESSID[MAX_SSID_LENGTH + 1] = "";
UCHAR WepKeyToUse = 0;
char WepKey1[(SHORT_WEP_KEY_SIZE * 2) + 1] = "0000000000\0";
char WepKey2[(SHORT_WEP_KEY_SIZE * 2) + 1] = "0000000000\0";
char WepKey3[(SHORT_WEP_KEY_SIZE * 2) + 1] = "0000000000\0";
char WepKey4[(SHORT_WEP_KEY_SIZE * 2) + 1] = "0000000000\0";
UCHAR WepMode = WEP_MODE_MANDATORY;
UCHAR EncryptionLevel = WEP_DISABLED;
UCHAR AuthenticationType = C80211_MGMT_AAN_OPENSYSTEM;
UCHAR PreambleType = LONG_PREAMBLE;
UCHAR PwrMgmtMode = 0;
UCHAR BeaconPeriod = 100;
UCHAR RadioOn = 1;
int pc_debug = 513;

MODULE_PARM (pc_debug, "i");
#ifndef PCI
MODULE_PARM (irq_mask, "i");
MODULE_PARM (irq_list, "1-4i");
#endif

MODULE_PARM (mtu, "i");
MODULE_PARM (eth, "i");
MODULE_PARM (channel, "i");
MODULE_PARM (TxRate, "i");
MODULE_PARM (RadioOn, "i");

MODULE_PARM (RTSThreshold, "i");
MODULE_PARM (FragThreshold, "i");

MODULE_PARM (OpMode, "i");
MODULE_PARM (ESSID, "c" __MODULE_STRING (MAX_SSID_LENGTH));
MODULE_PARM (WepKeyToUse, "i");
MODULE_PARM (WepKey1, "c" __MODULE_STRING (11));
MODULE_PARM (WepKey2, "c" __MODULE_STRING (11));
MODULE_PARM (WepKey3, "c" __MODULE_STRING (11));
MODULE_PARM (WepKey4, "c" __MODULE_STRING (11));

MODULE_PARM (WepMode, "i");
MODULE_PARM (EncryptionLevel, "i");
MODULE_PARM (AuthenticationType, "i");
MODULE_PARM (PreambleType, "i");
MODULE_PARM (PwrMgmtMode, "i");
MODULE_PARM (BeaconPeriod, "i");
MODULE_LICENSE ("GPL");

// Ethernet timeout is ((400*HZ)/1000), but we should use a higher
// value, because wireless transmissions are much slower

#define TX_TIMEOUT ((4000*HZ)/1000)

#define MAX_VNET_CARDS 	16

#ifndef PCI
#if (LINUX_VERSION_CODE >= 0x020213)
static struct net_device *vnet_index[MAX_VNET_CARDS];
#else
static struct device *vnet_index[MAX_VNET_CARDS];
#endif
#endif
//
// Local data for netdevice
//
struct net_local
{

#if (LINUX_VERSION_CODE >= 0x020213)
  struct net_device *dev;	// backtrack device
#else
  struct device *dev;		// backtrack device
#endif
#ifndef PCI
  dev_link_t *link;		// backtrack link
  dev_node_t node;
#endif
  spinlock_t slock;		// spinlock
  int interrupt;		// interrupt
  struct net_device_stats stats;	// device stats

#ifdef WIRELESS_EXT
#ifdef WIRELESS_SPY
  int spy_number;
  u_char spy_address[IW_MAX_SPY][VNet_LENGTH_OF_ADDRESS];
  struct iw_quality spy_stat[IW_MAX_SPY];
#endif
  struct iw_statistics wstats;
#endif
  VNet_ADAPTER Adapter;
};
//      Driver Info
/********************************************************************
 * Function Prototypes
 ********************************************************************/
#if (LINUX_VERSION_CODE >= 0x020213)
static int vnet_tx (struct sk_buff *skb, struct net_device *dev);
static int vnet_open (struct net_device *dev);
static int vnet_close (struct net_device *dev);
#else
static int vnet_tx (struct sk_buff *skb, struct device *dev);
static int vnet_open (struct device *dev);
static int vnet_close (struct device *dev);
#endif
static void vnet_interrupt (int irq, void *dev_id, struct pt_regs *regs);
#ifndef PCI
static int vnet_config (dev_link_t * link);
static void vnet_release (u_long arg);
static dev_link_t *vnet_attach (void);
static void vnet_detach (dev_link_t * link);
static int vnet_event (event_t event, int priority,
		       event_callback_args_t * args);
static void cs_error (client_handle_t handle, int func, int ret);
extern int init_module (void);
extern void cleanup_module (void);
#endif // PCI
#if (LINUX_VERSION_CODE >= 0x020213)
struct net_device_stats *vnet_get_stats (struct net_device *dev);
#else
struct net_device_stats *vnet_get_stats (struct device *dev);
#endif
#ifdef	WIRELESS_EXT
#if (LINUX_VERSION_CODE >= 0x020213)
static int vnet_ioctl (struct net_device *dev, struct ifreq *rq, int cmd);
struct iw_statistics *vnet_get_wireless_stats (struct net_device *dev);
#else
static int vnet_ioctl (struct device *dev, struct ifreq *rq, int cmd);
struct iw_statistics *vnet_get_wireless_stats (struct device *dev);
#endif
#endif

#ifndef PCI

/********************************************************************
 * PCMCIA CONFIG / RELEASE
 ********************************************************************/

#define CS_CHECK(fn, args...) while ((last_ret=CardServices(last_fn=(fn),args))!=0) goto cs_failed
#define CFG_CHECK(fn, args...) if (CardServices(fn, args) != 0) goto next_entry
static int
vnet_config (dev_link_t * link)
{
  client_handle_t handle = link->handle;
  tuple_t tuple;
  cisparse_t parse;
  struct net_device *dev = (struct net_device *) link->priv;
  struct net_local *local = (struct net_local *) dev->priv;
  int last_fn, last_ret;
  u_char buf[64];
  win_req_t req;
  memreq_t map;
  int i, rc;
  //int rc, i, cs_r;
  config_info_t config;
//      cistpl_cftable_entry_t dflt = { 0 };
  //PVNet_ADAPTER Adapter = (PVNet_ADAPTER)&local->Adapter;

  IF_LOUD (DbgPrint ("-> vnet_config(0x%p)\n", link);)
    // This reads the card's CONFIG tuple to find its configuration registers.
    tuple.DesiredTuple = CISTPL_CONFIG;
  tuple.Attributes = 0;
  tuple.TupleData = buf;
  tuple.TupleDataMax = sizeof (buf);
  tuple.TupleOffset = 0;
  CS_CHECK (GetFirstTuple, handle, &tuple);
  CS_CHECK (GetTupleData, handle, &tuple);
  CS_CHECK (ParseTuple, handle, &tuple, &parse);
  link->conf.ConfigBase = parse.config.base;
  link->conf.Present = parse.config.rmask[0];

  // Configure card

  link->state |= DEV_CONFIG;

  // 2-05-2001 Test : Added GetConfigurationInfo. Check if needed
  CS_CHECK (GetConfigurationInfo, handle, &config);
  link->conf.Vcc = config.Vcc;

  // In this loop, we scan the CIS for configuration table entries,
  // each of which describes a valid card configuration, including
  // voltage, IO window, memory window, and interrupt settings.
  // We make no assumptions about the card to be configured: we use
  // just the information available in the CIS.  In an ideal world,
  // this would work for any PCMCIA card, but it requires a complete
  // and accurate CIS.  In practice, a driver usually "knows" most of
  // these things without consulting the CIS, and most client drivers
  // will only use the CIS to fill in implementation-defined details.
  tuple.DesiredTuple = CISTPL_CFTABLE_ENTRY;
  CS_CHECK (GetFirstTuple, handle, &tuple);
  while (1)
    {
      cistpl_cftable_entry_t dflt = { 0 };
      cistpl_cftable_entry_t *cfg = &(parse.cftable_entry);
      CFG_CHECK (GetTupleData, handle, &tuple);
      CFG_CHECK (ParseTuple, handle, &tuple, &parse);

      if (cfg->index == 0)
	goto next_entry;
      link->conf.ConfigIndex = cfg->index;

      // Does this card need audio output?
      if (cfg->flags & CISTPL_CFTABLE_AUDIO)
	{
	  link->conf.Attributes |= CONF_ENABLE_SPKR;
	  link->conf.Status = CCSR_AUDIO_ENA;
	}

      // Use power settings for Vcc and Vpp if present
      // Note that the CIS values need to be rescaled
      if (cfg->vcc.present & (1 << CISTPL_POWER_VNOM))
	link->conf.Vcc = cfg->vcc.param[CISTPL_POWER_VNOM] / 10000;
      else if (dflt.vcc.present & (1 << CISTPL_POWER_VNOM))
	link->conf.Vcc = dflt.vcc.param[CISTPL_POWER_VNOM] / 10000;

      if (cfg->vpp1.present & (1 << CISTPL_POWER_VNOM))
	link->conf.Vpp1 = link->conf.Vpp2 =
	  cfg->vpp1.param[CISTPL_POWER_VNOM] / 10000;
      else if (dflt.vpp1.present & (1 << CISTPL_POWER_VNOM))
	link->conf.Vpp1 = link->conf.Vpp2 =
	  dflt.vpp1.param[CISTPL_POWER_VNOM] / 10000;

      // Do we need to allocate an interrupt?
      if (cfg->irq.IRQInfo1 || dflt.irq.IRQInfo1)
	link->conf.Attributes |= CONF_ENABLE_IRQ;

      // IO window settings
      link->io.NumPorts1 = link->io.NumPorts2 = 0;
      if ((cfg->io.nwin > 0) || (dflt.io.nwin > 0))
	{
	  cistpl_io_t *io = (cfg->io.nwin) ? &cfg->io : &dflt.io;
	  link->io.Attributes1 = IO_DATA_PATH_WIDTH_AUTO;
	  if (!(io->flags & CISTPL_IO_8BIT))
	    link->io.Attributes1 = IO_DATA_PATH_WIDTH_16;
	  if (!(io->flags & CISTPL_IO_16BIT))
	    link->io.Attributes1 = IO_DATA_PATH_WIDTH_8;
	  link->io.BasePort1 = io->win[0].base;
	  link->io.NumPorts1 = io->win[0].len;
	  if (io->nwin > 1)
	    {
	      link->io.Attributes2 = link->io.Attributes1;
	      link->io.BasePort2 = io->win[1].base;
	      link->io.NumPorts2 = io->win[1].len;
	    }
	}

      // This reserves IO space but doesn't actually enable it
      CFG_CHECK (RequestIO, link->handle, &link->io);
      // Now set up a common memory window, if needed.  There is room
      // in the dev_link_t structure for one memory window handle,
      // but if the base addresses need to be saved, or if multiple
      // windows are needed, the info should go in the private data
      // structure for this device.
      // Note that the memory window base is a physical address, and
      // needs to be mapped to virtual space with ioremap() before it
      // is used.
      if ((cfg->mem.nwin > 0) || (dflt.mem.nwin > 0))
	{
	  cistpl_mem_t *mem = (cfg->mem.nwin) ? &cfg->mem : &dflt.mem;
	  req.Attributes = WIN_DATA_WIDTH_16 | WIN_MEMORY_TYPE_CM;
	  req.Base = mem->win[0].host_addr;
	  req.Size = mem->win[0].len;
	  req.AccessSpeed = 0;
	  link->win = (window_handle_t) link->handle;
	  CFG_CHECK (RequestWindow, &link->win, &req);
	  map.Page = 0;
	  map.CardOffset = mem->win[0].card_addr;
	  CFG_CHECK (MapMemPage, link->win, &map);
	}
      break;

    next_entry:
      if (cfg->flags & CISTPL_CFTABLE_DEFAULT)
	dflt = *cfg;
      CS_CHECK (GetNextTuple, handle, &tuple);
    }

  // Allocate an interrupt line.  Note that this does not assign a
  // handler to the interrupt, unless the 'Handler' member of the
  // irq structure is initialized.
  if (link->conf.Attributes & CONF_ENABLE_IRQ)
    {
      link->irq.Attributes = IRQ_TYPE_EXCLUSIVE | IRQ_HANDLE_PRESENT;
      link->irq.IRQInfo1 = IRQ_INFO2_VALID | IRQ_LEVEL_ID;
      if (irq_list[0] == -1)
	link->irq.IRQInfo2 = irq_mask;
      else
	for (i = 0; i < 4; i++)
	  link->irq.IRQInfo2 |= 1 << irq_list[i];
      link->irq.Handler = vnet_interrupt;
      link->irq.Instance = dev;
      CS_CHECK (RequestIRQ, link->handle, &link->irq);
    }

  // This actually configures the PCMCIA socket -- setting up
  // the I/O windows and the interrupt mapping, and putting the
  // card and host interface into "Memory and IO" mode.

  CS_CHECK (RequestConfiguration, link->handle, &link->conf);

  // Feed the netdevice with this info
  dev->irq = link->irq.AssignedIRQ;
  dev->base_addr = link->io.BasePort1;
  netif_start_queue (dev);

  // Report what we've done

  IF_LOUD (DbgPrint
	   ("%s: index 0x%02x: Vcc %d.%d", dev_info, link->conf.ConfigIndex,
	    link->conf.Vcc / 10, link->conf.Vcc % 10);) if (link->conf.Vpp1)
    {
    IF_LOUD (DbgPrint
	       (", Vpp %d.%d", link->conf.Vpp1 / 10, link->conf.Vpp1 % 10);)}
  if (link->conf.Attributes & CONF_ENABLE_IRQ)
    {
    IF_LOUD (DbgPrint (", irq %d", link->irq.AssignedIRQ);)}
  if (link->io.NumPorts1)
    {
    IF_LOUD (DbgPrint
	       (", io 0x%04x-0x%04x", link->io.BasePort1,
		  link->io.BasePort1 + link->io.NumPorts1 - 1);)}
  if (link->io.NumPorts2)
    {
    IF_LOUD (DbgPrint
	       (" & 0x%04x-0x%04x", link->io.BasePort2,
		  link->io.BasePort2 + link->io.NumPorts2 - 1);)}
  if (link->win)
    {
    IF_LOUD (DbgPrint
	       (", mem 0x%06lx-0x%06lx", req.Base, req.Base + req.Size - 1);)}
  IF_LOUD (DbgPrint ("\n");) link->state &= ~DEV_CONFIG_PENDING;

  if (!eth)
    {
      for (i = 0; i < MAX_VNET_CARDS; ++i)
	if (!vnet_index[i])
	  {
	    sprintf (dev->name, "vnet%d", i);
	    vnet_index[i] = dev;
	    break;
	  }
    }

  // Register the netdevice
  rc = register_netdev (dev);
  if (rc)
    {
      IF_DEBUG_ERRORS (DbgPrint
		       ("%s: register_netdev() failed!\n",
			dev_info);) vnet_release ((u_long) link);
      return 0;
    }
  IF_LOUD (DbgPrint ("%s: Registered netdevice %s\n", dev_info, dev->name);)
    copy_dev_name (local->node, dev);
  local->Adapter.dev = dev;
  local->Adapter.IoBase = dev->base_addr;

  link->dev = &local->node;
  IF_VERY_LOUD (DbgPrint ("<- vnet_config()\n");) return 1;

cs_failed:
  cs_error (link->handle, last_fn, last_ret);
  vnet_release ((u_long) link);
  IF_VERY_LOUD (DbgPrint ("<- vnet_config()\n");) return 0;
}

static void
vnet_release (u_long arg)
{
  dev_link_t *link = (dev_link_t *) arg;
  struct net_device *dev = (struct net_device *) link->priv;
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;

  IF_VERY_LOUD (DbgPrint ("-> vnet_release(0x%p)\n", link);)
    // If the device is currently in use, we won't release
    // until it's actually closed.
    if (link->open)
    {
      IF_VERY_LOUD (DbgPrint
		    ("%s: vnet_release: release postponed, %s still locked\n",
		     dev_info, link->dev->dev_name);) link->state |=
	DEV_STALE_CONFIG;
      return;
    }

  del_timer (Adapter->MgmtTimer);
  kfree (Adapter->MgmtTimer);
  CardStop (Adapter);
  Adapter->IsUp = FALSE;
  if (link->win)
    CardServices (ReleaseWindow, link->win);
  CardServices (ReleaseConfiguration, link->handle);

  if (link->io.NumPorts1)
    CardServices (ReleaseIO, link->handle, &link->io);

  if (link->irq.AssignedIRQ)
    CardServices (ReleaseIRQ, link->handle, &link->irq);

  link->state &= ~DEV_CONFIG;

IF_VERY_LOUD (DbgPrint ("<- vnet_release()\n");)}

/********************************************************************
* PCMCIA ATTACH / DETACH
********************************************************************/
static dev_link_t *
vnet_attach (void)
{
  dev_link_t *link;
  struct net_device *dev;
  struct net_local *local;
  int rc;
  client_reg_t client_reg;

  IF_LOUD (DbgPrint ("-> vnet_attach()\n");)
    // Flush stale links
    for (link = dev_list; link; link = link->next)
    if (link->state & DEV_STALE_LINK)
      vnet_detach (link);

  // Initialize the dev_link_t structure
  link = kmalloc (sizeof (struct dev_link_t), GFP_KERNEL);
  memset (link, 0, sizeof (struct dev_link_t));
  link->release.function = &vnet_release;
  link->release.data = (u_long) link;
  link->conf.Vcc = 33;
  link->conf.IntType = INT_MEMORY_AND_IO;

  // Allocate space for netdevice (private data of link)
  dev = kmalloc (sizeof (struct net_device), GFP_KERNEL);
  memset (dev, 0, sizeof (struct net_device));
  link->priv = dev;
  // Allocate space for netdevice priv (private data of netdevice)
  local = kmalloc (sizeof (struct net_local), GFP_KERNEL);
  memset (local, 0, sizeof (struct net_local));
  dev->priv = local;

  // Initialize specific data
  local->link = link;
  local->dev = dev;
  spin_lock_init (&local->slock);

  /* Set the mgmt timer */
  local->Adapter.MgmtTimer = kmalloc (sizeof (struct timer_list), GFP_KERNEL);
  init_timer (local->Adapter.MgmtTimer);
  local->Adapter.MgmtTimer->function = MgmtTimer;
  local->Adapter.MgmtTimer->data = (unsigned long) dev;

  // Standard setup for generic data
  ether_setup (dev);
  // kernel callbacks
  dev->open = vnet_open;
  dev->stop = vnet_close;
  dev->hard_start_xmit = vnet_tx;
  dev->get_stats = vnet_get_stats;

#ifdef WIRELESS_EXT
  dev->do_ioctl = vnet_ioctl;
  dev->get_wireless_stats = vnet_get_wireless_stats;
#endif

  // Other netdevice data
  init_dev_name (dev, local->node);
  dev->mtu = mtu;

  netif_stop_queue (dev);
  // Register with CardServices
  link->next = dev_list;
  dev_list = link;
  client_reg.dev_info = &dev_info;
  client_reg.Attributes = INFO_IO_CLIENT;
  client_reg.EventMask = CS_EVENT_REGISTRATION_COMPLETE |
    CS_EVENT_CARD_INSERTION | CS_EVENT_CARD_REMOVAL |
    CS_EVENT_RESET_PHYSICAL | CS_EVENT_CARD_RESET |
    CS_EVENT_PM_SUSPEND | CS_EVENT_PM_RESUME;
  client_reg.event_handler = &vnet_event;
  client_reg.Version = 0x0210;
  client_reg.event_callback_args.client_data = link;

  rc = CardServices (RegisterClient, &link->handle, &client_reg);
  if (rc)
    {
      cs_error (link->handle, RegisterClient, rc);
      vnet_detach (link);
      return NULL;
    }

  IF_VERY_LOUD (DbgPrint ("<- vnet_attach()\n");) return link;
}

static void
vnet_detach (dev_link_t * link)
{
  dev_link_t **linkp;

  IF_VERY_LOUD (DbgPrint ("-> vnet_detach(0x%p)\n", link);)
    // Locate device structure
    for (linkp = &dev_list; *linkp; linkp = &(*linkp)->next)
    if (*linkp == link)
      break;
  if (!*linkp)
    {
      IF_DEBUG_ERRORS (DbgPrint
		       ("%s: Attempt to detach non-existing PCMCIA client!\n",
			dev_info);) return;
    }

  // If the device is currently configured and active, we won't
  // actually delete it yet. Instead, it is marked so that when the
  // release() function is called, that will trigger a proper
  // detach()
  del_timer (&link->release);
  if (link->state & DEV_CONFIG)
    {
      IF_LOUD (DbgPrint
	       ("%s: vnet_detach: detach postponed, %s still locked\n",
		dev_info, link->dev->dev_name);) vnet_release ((u_long) link);
      if (link->state & DEV_STALE_CONFIG)
	{
	  link->state |= DEV_STALE_LINK;
	  return;
	}
    }

  // Break the line with CardServices
  if (link->handle)
    CardServices (DeregisterClient, link->handle);

  // Unlink device structure, free pieces
  *linkp = link->next;
  if (link->priv)
    {
      struct net_device *dev = (struct net_device *) link->priv;
      if (link->dev)
	{
	  unregister_netdev (dev);
	IF_LOUD (DbgPrint ("%s: Netdevice unregistered\n", dev_info);)}
      if (dev->priv)
	kfree (dev->priv);
      kfree (link->priv);
    }
  kfree (link);

IF_VERY_LOUD (DbgPrint ("<- vnet_detach()\n");)}

/********************************************************************
 * PCMCIA EVENT HANDLER
********************************************************************/
static int
vnet_event (event_t event, int priority, event_callback_args_t * args)
{
  dev_link_t *link = (dev_link_t *) args->client_data;
  struct net_device *dev = (struct net_device *) link->priv;
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;

  IF_LOUD (DbgPrint ("-> vnet_event(%s, %d, 0x%p)\n",
		     ((event ==
		       CS_EVENT_REGISTRATION_COMPLETE) ?
		      "registration complete"
		      : ((event ==
			  CS_EVENT_CARD_INSERTION) ? "card insertion"
			 : ((event ==
			     CS_EVENT_CARD_REMOVAL) ? "card removal" : ((event
									 ==
									 CS_EVENT_RESET_PHYSICAL)
									?
									"physical physical"
									: ((event == CS_EVENT_CARD_RESET) ? "card reset" : ((event == CS_EVENT_PM_SUSPEND) ? "pm suspend" : ((event == CS_EVENT_PM_RESUME) ? "pm resume" : "unknown"))))))), priority, args);) switch (event)
    {
    case CS_EVENT_CARD_INSERTION:
      link->state |= DEV_PRESENT | DEV_CONFIG_PENDING;
      if (!vnet_config (link))
	dev->irq = 0;
      Adapter->IsUp = TRUE;
      InitAdapter (&local->Adapter);
      SetParameters (&local->Adapter);
      if (!InitAndStartCard (&local->Adapter))
	return -1;
      memcpy (dev->dev_addr, Adapter->CurrentAddress, 6);
      break;

    case CS_EVENT_CARD_REMOVAL:
      del_timer (Adapter->MgmtTimer);
      link->state &= ~DEV_PRESENT;
      Adapter->IsUp = FALSE;
      if (link->state & DEV_CONFIG)
	{
	  netif_stop_queue (dev);
	  netif_device_detach (dev);
	  mod_timer (&link->release, jiffies + HZ / 20);
	}
      break;

    case CS_EVENT_PM_SUSPEND:
      link->state |= DEV_SUSPEND;
    case CS_EVENT_RESET_PHYSICAL:
      Adapter->IsUp = FALSE;
      if (link->state & DEV_CONFIG)
	{
	  if (link->open)
	    {
	      netif_stop_queue (dev);
	      netif_device_detach (dev);
	    }
	  CardServices (ReleaseConfiguration, link->handle);
	}
      break;

    case CS_EVENT_PM_RESUME:
      link->state &= ~DEV_SUSPEND;
      // Fall through
    case CS_EVENT_CARD_RESET:
      if (link->state & DEV_CONFIG)
	{
	  CardServices (RequestConfiguration, link->handle, &link->conf);
	  if (link->open)
	    {
	      netif_device_attach (dev);
	      netif_start_queue (dev);
	    }
	}
      break;
    }

  IF_VERY_LOUD (DbgPrint ("<- vnet_event()\n");) return 0;
}

/********************************************************************
 * MODULE INSERTION / REMOVAL
********************************************************************/
extern int
init_module (void)
{
  servinfo_t serv;

  IF_VERY_LOUD (DbgPrint ("-> init_module()\n");) IF_LOUD (DbgPrint
							   ("%s: ATMEL 11Mbps Wireless PCMCIA LAN driver version %s\n",
							    dev_info,
							    version);)
    // Check CardServices release
    CardServices (GetCardServicesInfo, &serv);

  if (serv.Revision != CS_RELEASE_CODE)
    {
      printk ("%s: CardServices release does not match!\n", dev_info);
      return -1;
    }
  // Register PCMCIA driver
  register_pccard_driver (&dev_info, &vnet_attach, &vnet_detach);
  IF_VERY_LOUD (DbgPrint ("<- init_module()\n");) return 0;
}

extern void
cleanup_module (void)
{
  IF_VERY_LOUD (DbgPrint ("-> cleanup_module()\n");)
    // Unregister PCMCIA driver
    unregister_pccard_driver (&dev_info);

  // Remove leftover devices
  if (dev_list)
    {
    IF_VERY_LOUD (DbgPrint ("%s: Removing leftover devices!\n", dev_info);)}
  while (dev_list)
    {
      if (dev_list->state & DEV_CONFIG)
	vnet_release ((u_long) dev_list);
      vnet_detach (dev_list);
    }

IF_LOUD (DbgPrint ("%s: Driver unloaded\n", dev_info);)
    IF_VERY_LOUD (DbgPrint ("<- cleanup_module()\n");)}


// Show CardServices error message (syslog)
static void
cs_error (client_handle_t handle, int func, int ret)
{
  error_info_t err = { func, ret };
  CardServices (ReportError, handle, &err);
}
#endif //ifndef PCI
/********************************************************************
 * NET OPEN / CLOSE
********************************************************************/

#if (LINUX_VERSION_CODE > 0x020213)
static int
vnet_open (struct net_device *dev)
#else
static int
vnet_open (struct device *dev)
#endif
{
  struct net_local *local = (struct net_local *) dev->priv;
#ifndef PCI
  struct dev_link_t *link = local->link;
#endif

  IF_LOUD (DbgPrint ("-> vnet_open(%s)\n", dev->name);)
    netif_device_attach (dev);
  netif_start_queue (dev);
  local->interrupt = 0;
#ifndef PCI
  link->open++;
#endif

  MOD_INC_USE_COUNT;

  IF_VERY_LOUD (DbgPrint ("<- vnet_open(%s)\n", dev->name);) return 0;
}

#if (LINUX_VERSION_CODE > 0x020213)
static int
vnet_close (struct net_device *dev)
#else
static int
vnet_close (struct device *dev)
#endif
{
#ifndef PCI
  struct net_local *local = (struct net_local *) dev->priv;
  struct dev_link_t *link = local->link;


  // If the device isn't open, then nothing to do
  if (!link->open)
    {
      IF_VERY_LOUD (DbgPrint ("<> vnet_close(%s)\n", dev->name);) return 0;
    }

  IF_VERY_LOUD (DbgPrint ("-> vnet_close(%s)\n", dev->name);)
    // Close the device
    link->open--;
#endif
  MOD_DEC_USE_COUNT;
  // Check if card is still present
  if (netif_running (dev))
    {
      netif_stop_queue (dev);
      netif_device_detach (dev);
    }
#ifndef PCI
  else if (link->state & DEV_STALE_CONFIG)
    mod_timer (&link->release, jiffies + HZ / 20);
#endif
  IF_VERY_LOUD (DbgPrint ("<- vnet_close(%s)\n", dev->name);) return 0;
}

/********************************************************************
 * NET Statistics
 ********************************************************************/
#if (LINUX_VERSION_CODE > 0x020213)
struct net_device_stats *
vnet_get_stats (struct net_device *dev)
#else
struct net_device_stats *
vnet_get_stats (struct device *dev)
#endif
{
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;
  IF_VERY_LOUD (DbgPrint ("<> vnet_get_stats(%s)\n", dev->name);) local->
    stats.tx_packets = Adapter->Stats.TxDataPacketsOk;
  local->stats.rx_packets = Adapter->Stats.RxDataPacketsOk;
  local->stats.tx_errors = Adapter->Stats.TxDataPacketsError;
  local->stats.rx_errors = Adapter->Stats.RxDataPacketsError;
  return (&((struct net_local *) dev->priv)->stats);
}

/*******************************************************************
Management Timer
*******************************************************************/

VOID
MgmtTimer (u_long a)
{
#if (LINUX_VERSION_CODE > 0x020213)
  struct net_device *dev = (struct net_device *) a;
#else
  struct device *dev = (struct device *) a;
#endif
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;

  if (!Adapter->IsUp
#ifndef PCI
      || !(local->link->state & DEV_PRESENT)
#endif
    )
    {
      IF_LOUD (DbgPrint ("** MgmtTimer reject ***\n");) return;
    }

  MgmtTimeOutCallBack (Adapter);
}

/********************************************************************
 * NET TX / RX
 ********************************************************************/

#if (LINUX_VERSION_CODE > 0x020213)
int
vnet_tx (struct sk_buff *skb, struct net_device *dev)
#else
int
vnet_tx (struct sk_buff *skb, struct device *dev)
#endif
{
  struct net_local *local = (struct net_local *) dev->priv;
  ULONG TotalBytes = 0;
  USHORT StartOfTxBuffer = 0;
  unsigned long flags;
  //ULONG Status;
  int len;
  UCHAR *p;
  PVNet_ADAPTER Adapter = &local->Adapter;
  IF_VERY_LOUD (DbgPrint ("-> vnet_tx(%s)\n", dev->name);) if (Adapter->
							       StationState !=
							       STATION_STATE_READY
#ifndef PCI
							       || !(local->
								    link->
								    state &
								    DEV_PRESENT)
#endif
    )
    return 0;

#if (KERNEL_VERSION_CODE < KERNEL_VERSION(2,3,42))
  if (netif_queue_stopped (dev))
    {
#ifndef PCI
      IF_VERY_LOUD (DbgPrint
		    ("%s: vnet_tx(%s) called while busy!\n", dev_info,
		     dev->name);)
#endif
	if ((jiffies - dev->trans_start) < TX_TIMEOUT)
	return 1;
      if (!netif_running (dev))
	{
#ifndef PCI
	  IF_LOUD (DbgPrint
		   ("%s: %s Tx on stopped device!\n", dev_info, dev->name);)
#endif
	    return 1;
	}
    }
#endif
  skb_tx_check (dev, skb);
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,1,79))
  skb->arp = 1;
#endif
  // Disable interrupts
  spin_lock_irqsave (&local->slock, flags);
  // Prepare packet
  p = skb->data;
  len = (ETH_ZLEN < skb->len) ? skb->len : ETH_ZLEN;
  TotalBytes = len;

  if (TxResourcesAvailable (Adapter, TotalBytes + 18, &StartOfTxBuffer) ==
      FALSE)
    {
      Adapter->Stats.RxLost++;
      netif_stop_queue (dev);
      spin_unlock_irqrestore (&local->slock, flags);
      return 1;
    }
  TxEthernetPacket (Adapter, skb->data, len, &TotalBytes, StartOfTxBuffer,
		    TRUE);
  TxUpdateDescriptor (Adapter, TotalBytes, StartOfTxBuffer, TRUE);

  // Send packet
  // Remember time transmission and count tx bytes
  dev->trans_start = jiffies;
  add_tx_bytes (&local->stats, len);

  // Re-enable interrupts
  spin_unlock_irqrestore (&local->slock, flags);
  DEV_KFREE_SKB (skb);

  IF_VERY_LOUD (DbgPrint ("<- vnet_tx()\n");) return 0;
}

/********************************************************************
 * INTERRUPT HANDLER
 */
static void
vnet_interrupt (int irq, void *dev_id, struct pt_regs *regs)
{
  //UCHAR                         InterruptStatus;        
  //INTERRUPT_TYPE                InterruptType;                  
#ifdef PCI
#if (LINUX_VERSION_CODE > 0x020213)
  struct net_device *dev = ((struct pci_dev *) dev_id)->driver_data;
#else
  struct device *dev = (struct device *) dev_id;
#endif
#else
  struct net_device *dev = (struct net_device *) dev_id;
#endif
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;

  //int cnt;

  IF_VERY_LOUD (DbgPrint ("-> vnet_interrupt(%d)\n", irq);) if (!Adapter->IsUp
#ifndef PCI
								|| !(local->
								     link->
								     state &
								     DEV_PRESENT)
#endif
    )
    return;
  // Check device
  if (!dev)
    {
#ifndef PCI
      IF_LOUD (DbgPrint ("%s: IRQ %d for unknown device!\n", dev_info, irq);)
#endif
	return;
    }

  DisableInterrupts (Adapter);
  if (test_and_set_bit (0, (void *) &local->interrupt))
    {
#ifdef PCI
      IF_LOUD (DbgPrint
	       ("Warning: IRQ %d Reentering interrupt handler!\n", irq);)
#else
      IF_LOUD (DbgPrint
	       ("%s: Warning: IRQ %d Reentering interrupt handler!\n",
		dev_info, irq);)
#endif
    }
  ProcessInterrupt (Adapter);
  local->interrupt = 0;
  // Turn back interrupts on (unlock)
  EnableInterrupts (Adapter);
IF_VERY_LOUD (DbgPrint ("<- vnet_interrupt()\n");)}


VOID
UpdateSupportAppInfo (PVNet_ADAPTER Adapter, PDEVICE_CONFIGURATION pDevConfig)
{
  int i;
  //DEVICE_CONFIGURATION DevConfig;

  pDevConfig->StationState = Adapter->StationState;
  pDevConfig->OperatingMode = Adapter->OperatingMode;
  pDevConfig->Channel = (Adapter->Channel & 0x7f);


  VNetMoveMemory (pDevConfig->SSID, Adapter->DesiredSSID, Adapter->SSID_Size);
  pDevConfig->SSIDlength = Adapter->SSID_Size;

  VNetMoveMemory (pDevConfig->BSSID, Adapter->CurrentBSSID, 6);
  pDevConfig->InternationalRoaming = Adapter->IntRoamingEnabled;
  if (pDevConfig->InternationalRoaming)
    {
      for (i = 0; i < 14; i++)
	{

	  pDevConfig->ChannelVector[i] = Adapter->ChannelVector[i];

	}
    }

  pDevConfig->MgmtErrorCode = Adapter->MgmtErrorCode;
  pDevConfig->RegDomain = Adapter->RegDomain;
  pDevConfig->PreambleType = Adapter->PreambleType;
  pDevConfig->PowerMgmtMode = Adapter->PowerMgmtMode;
  pDevConfig->RadioIsOn = Adapter->RadioIsOn;

  pDevConfig->TxRate = Adapter->DataFramesTxRate;
  pDevConfig->FragmentationThreshold = Adapter->FragmentationThreshold;
  pDevConfig->RtsCtsThreshold = Adapter->RtsThreshold;
	if(Adapter->RadioIsOn){
	  pDevConfig->Rssi = Adapter->Rssi;
	  pDevConfig->LinkQuality = 40 - Adapter->LinkQuality;
	}else{
	  pDevConfig->Rssi = 0;
	  pDevConfig->LinkQuality = 0;
	}
  if ((Adapter->StationState != 0x05) || (Adapter->OperatingMode == AD_HOC_MODE)){
	  pDevConfig->Rssi = 0;
	  pDevConfig->LinkQuality = 0;
  }
}

static int translate_scan_results(struct iwreq *wrq, PVNet_ADAPTER Adapter)
{
	char *current_ev = wrq->u.data.pointer;
	char *end_buf = wrq->u.data.pointer + IW_SCAN_MAX_DATA;
	char *current_val;
	int i;

	for (i = 0; i < Adapter->BSSListEntries; i++) {
		BSS_INFO *bss;
		struct iw_event iwe;

		bss = &Adapter->BSSinfo[i];

		/* First entry *MUST* be the AP MAC address */
		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWAP;
		iwe.u.ap_addr.sa_family = ARPHRD_ETHER;
		memcpy(iwe.u.ap_addr.sa_data, bss->BSSID, ETH_ALEN);

		/* FIX:
		 * I do not know how this is possible, but iwe_stream_add_event
		 * seems to re-order memcpy execution so that len is set only
		 * after copying.. Pre-setting len here "fixes" this, but real
		 * problems should be solved (after which these iwe.len
		 * settings could be removed from this function). */
		iwe.len = IW_EV_ADDR_LEN;
		current_ev = iwe_stream_add_event(current_ev, end_buf, &iwe,
						  IW_EV_ADDR_LEN);

		/* Other entries will be displayed in the order we give them */

		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWESSID;
		iwe.u.data.length = le16_to_cpu(bss->SSIDsize);
		if (iwe.u.data.length > 32)
			iwe.u.data.length = 32;
		iwe.u.data.flags = 1;
		iwe.len = IW_EV_POINT_LEN + iwe.u.data.length;
		current_ev = iwe_stream_add_point(current_ev, end_buf, &iwe,
						  bss->SSID);		

		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWFREQ;
		iwe.u.freq.m = bss->Channel;
		iwe.u.freq.e = 0;
		iwe.len = IW_EV_FREQ_LEN;
		current_ev = iwe_stream_add_event(current_ev, end_buf, &iwe,
						  IW_EV_FREQ_LEN);

		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = SIOCGIWENCODE;
		if (bss->UsingWEP)
			iwe.u.data.flags = IW_ENCODE_ENABLED | IW_ENCODE_NOKEY;
		else
			iwe.u.data.flags = IW_ENCODE_DISABLED;
		iwe.u.data.length = 0;
		iwe.len = IW_EV_POINT_LEN + iwe.u.data.length;
		current_ev = iwe_stream_add_point(
			current_ev, end_buf, &iwe,
			bss->SSID /* memcpy 0 bytes */);

		memset(&iwe, 0, sizeof(iwe));
		iwe.cmd = IWEVQUAL;
		iwe.u.qual.level = bss->RSSI;
		iwe.len = IW_EV_QUAL_LEN;
		current_ev = iwe_stream_add_event(current_ev, end_buf, &iwe,
						  IW_EV_QUAL_LEN);
	}

	wrq->u.data.length = current_ev - wrq->u.data.pointer;

	return 0;
}

// IO CONTROLS
#ifdef WIRELESS_EXT
#define SuP 	1
#define WeP		2

#if (LINUX_VERSION_CODE > 0x020213)
static int
vnet_ioctl (struct net_device *dev, struct ifreq *rq, int cmd)
#else
static int
vnet_ioctl (struct device *dev, struct ifreq *rq, int cmd)
#endif
{
  struct net_local *local = (struct net_local *) dev->priv;
  struct iwreq *wrq = (struct iwreq *) rq;
  USHORT subcmd;
  PVNet_ADAPTER Adapter = &local->Adapter;
  ULONG GenericULong;
  //UCHAR                 ApInfoList[MAX_BSS_ENTRIES*sizeof(BSS_INFO)];
  int rc = 0, update = 0, WEP_OR_SUPPORT = 0, APindex, i;
  DEVICE_CONFIGURATION DevConfig;

  // check the user. if not superuser return no perm.
  if (!capable (CAP_NET_ADMIN))
    {
      return -EPERM;
    }


  DisableInterrupts (Adapter);
  UpdateSupportAppInfo (Adapter, &DevConfig);
  IF_LOUD (DbgPrint ("Calling ioctl\n");) switch (cmd)
    {
    case SIOCGIWNAME:
#if defined(R504)
      strcpy (wrq->u.name, "ATMEL 504");
#elif defined(PCI)
      strcpy (wrq->u.name, "ATMEL PCI");
#elif defined(REV_D)
      strcpy (wrq->u.name, "ATMEL REVD");
#elif defined(REV_E)
      strcpy (wrq->u.name, "ATMEL REVE");
#elif defined(RFMD) || defined(RFMD_3COM)
      strcpy (wrq->u.name, "ATMEL RFMD");
#endif
      break;
    case SIOCDEVPRIVATE:
      subcmd = wrq->u.data.flags;
      switch (subcmd)
	{
	case GET_SUPPORT_INFO:
	  wrq->u.data.length = sizeof (DEVICE_CONFIGURATION);
	  copy_to_user (wrq->u.data.pointer, &DevConfig, wrq->u.data.length);
	  break;
	case SET_SUPPORT_INFO:
	  copy_from_user (&DevConfig, wrq->u.data.pointer,
			  wrq->u.data.length);
	  ChangeConfiguration (Adapter, &DevConfig);
	  break;
	case GET_WEP_INFO:
	  wrq->u.data.length = sizeof (WEP_INFO);
	  copy_to_user (wrq->u.data.pointer, &Adapter->WepInfo,
			wrq->u.data.length);
	  break;
	case SET_WEP_INFO:
	  copy_from_user (&Adapter->WepInfo, wrq->u.data.pointer,
			  wrq->u.data.length);
	  ConfigureWEP (Adapter);
	  ResetAdapter (Adapter, TRUE);
	  break;
	case GET_VERSION_INFO:
	  Adapter->VersionInfo.DriverMajorVersion = FAST_VNET_MAJOR_VERSION;
	  Adapter->VersionInfo.DriverMinorVersion = FAST_VNET_MINOR_VERSION;
	  Adapter->VersionInfo.DriverSubVersion = FAST_VNET_SUB_VERSION;
	  Adapter->VersionInfo.DriverBuild = FAST_VNET_BUILD;
	  Adapter->VersionInfo.FwMajorVersion = Adapter->HostInfo.MajorVer;
	  Adapter->VersionInfo.FwMinorVersion = Adapter->HostInfo.MinorVer;
	  Adapter->VersionInfo.FwSubVersion = 0;
	  Adapter->VersionInfo.FwBuild = Adapter->HostInfo.BuildVer;
	  wrq->u.data.length = sizeof (VERSION_INFO);
	  copy_to_user (wrq->u.data.pointer, &Adapter->VersionInfo,
			wrq->u.data.length);
	  break;
	case RESET_CARD:
	  ResetAdapter (Adapter, TRUE);
	  break;
	case CLEAR_PACKETS:
	  VNetZeroMemory ((PUCHAR) & Adapter->Stats, sizeof (STATISTICS));
	  update = 0;
	  break;
	case GET_AP_INFO:
	  if (!Adapter->RadioIsOn){
    Adapter->BSSListEntries = 0;
    }
#ifdef INT_ROAM
    if((Adapter->IntRoamingEnabled) && (!(Adapter->MultiDomainMib.DomainInfoValid))){
    Adapter->BSSListEntries = 0;
    }
#endif
	  wrq->u.data.length = sizeof (BSS_INFO) * Adapter->BSSListEntries;
	  copy_to_user (wrq->u.data.pointer, &Adapter->BSSinfo,
			wrq->u.data.length);
	  break;
	case SITE_SURVEY:
    printk(KERN_ALERT "SITE SYRVEY\n");
	  if (Adapter->RadioIsOn)
	    {
#ifdef INT_ROAM
        if((Adapter->IntRoamingEnabled) && (!Adapter->MultiDomainMib.DomainInfoValid)){
            printk(KERN_ALERT "YOU SITE SYRVEY\n");
            Adapter->SiteSurveyState = SITE_SURVEY_COMPLETED;
			      EnableInterrupts (Adapter);
            return 0;

        }
#endif
	      if (Adapter->SiteSurveyState == SITE_SURVEY_IDLE || Adapter->SiteSurveyState == SITE_SURVEY_COMPLETED) {
            Adapter->SiteSurveyState = SITE_SURVEY_IN_PROGRESS;
            Scan (Adapter, FALSE);
        }
	      GenericULong = 0;
	      wrq->u.data.length = 0;
      }
	  break;
	case STOP_SITE_SURVEY:
    printk(KERN_ALERT "STOP SITE SYRVEY\n");
	  if (!Adapter->RadioIsOn){
			  EnableInterrupts (Adapter);
        return 0;
      }
	  if (Adapter->RadioIsOn)
	    {
	      if (Adapter->OperatingMode != AD_HOC_MODE)
		{
		  if (Adapter->IntRoamingEnabled)
		    {
		      for (i = 0; i < 14; i++)
			{
			  if (Adapter->ChannelVector[i] != 0)
			    break;
			}
		      if (i < 14)
			{
			  if (Adapter->MgmtErrorCode == 0xa0)
			    {
			      Adapter->StationState =
				STATION_STATE_MGMT_ERROR;
			      EnableInterrupts (Adapter);
			      return 0;
			    }
			  else if (Adapter->MgmtErrorCode == 0xa1)
			    {
			      Adapter->StationState =
				STATION_STATE_MGMT_ERROR;
			      EnableInterrupts (Adapter);
			      return 0;
			    }
			}
		      else
			{
			  Adapter->StationState = STATION_STATE_WAIT_ACTION;
			  Scan (Adapter, TRUE);
			}
		    }
		  else
		    {
		      if (Adapter->MgmtErrorCode == 0xa0)
			{
			  Adapter->StationState = STATION_STATE_MGMT_ERROR;
			  EnableInterrupts (Adapter);
			  return 0;
			}
		      else if (Adapter->MgmtErrorCode == 0xa1)
			{
			  Adapter->StationState = STATION_STATE_MGMT_ERROR;
			  EnableInterrupts (Adapter);
			  return 0;
			}
		    }
		}
	      else
		{
		  Adapter->StationState = STATION_STATE_READY;
		}
	    }
	  else
	    {
	      Adapter->SiteSurveyState = SITE_SURVEY_IDLE;
	      SelectBSS (Adapter, 0xff);	//ff indicates no AP selected
	    }
	  break;
	case SELECT_AP_BY_INDEX:
	  if (Adapter->RadioIsOn)
	    {
	      copy_from_user (&APindex, wrq->u.data.pointer,
			      wrq->u.data.length);
	      SelectBSS (Adapter, APindex - 1);
	      Adapter->SiteSurveyState = SITE_SURVEY_IDLE;
	    }
	  break;

	case SITE_SURVEY_STATE:
	  wrq->u.data.length = sizeof (UCHAR);
	  copy_to_user (wrq->u.data.pointer, &Adapter->SiteSurveyState,
			wrq->u.data.length);
	  break;

	case GET_STATISTICS:
	  wrq->u.data.length = sizeof (STATISTICS);
	  copy_to_user (wrq->u.data.pointer, &Adapter->Stats,
			wrq->u.data.length);
	  break;

	case GET_MAC_ADDRESS:
	  wrq->u.data.length = VNet_LENGTH_OF_ADDRESS;
	  copy_to_user (wrq->u.data.pointer, &Adapter->CurrentAddress,
			wrq->u.data.length);
	  update = 0;
	  break;
	}
      break;

    case SIOCSIWSCAN:
      if (Adapter->RadioIsOn)
	{
	  if (Adapter->SiteSurveyState == SITE_SURVEY_IDLE || Adapter->SiteSurveyState == SITE_SURVEY_COMPLETED) {
	    Adapter->SiteSurveyState = SITE_SURVEY_IN_PROGRESS;
	    Scan (Adapter, FALSE);
	  } else
	    rc = -EAGAIN;
	}
      else
	rc = -ENETDOWN;
      break;
	    
    case SIOCGIWSCAN:
      if (Adapter->SiteSurveyState == SITE_SURVEY_IN_PROGRESS)
	rc = -EAGAIN;
      else
	rc = translate_scan_results(wrq, Adapter);
      break;
	    
      // GETS
    case SIOCGIWESSID:		// Return Current ESSID to wireless tools
      if (Adapter->SSID_Size == 0)
	{
	  wrq->u.data.length = Adapter->SSID_Size;
	  copy_to_user (wrq->u.data.pointer, Adapter->DesiredSSID,
			wrq->u.data.length);
	}
      else
	{
	  wrq->u.data.length = Adapter->InitialSSIDsize;
	  copy_to_user (wrq->u.data.pointer, Adapter->InitialSSID,
			wrq->u.data.length);
	}
      wrq->u.data.flags = 1;

      break;

    case SIOCGIWMODE:
      switch (Adapter->OperatingMode)
	{
	case AD_HOC_MODE:
	  wrq->u.mode = IW_MODE_ADHOC;
	  break;
	case INFRASTRUCTURE_MODE:
	  wrq->u.mode = IW_MODE_INFRA;
	  break;
	  // For compatibility with wireless tools
	  // AdHoc in wt is 1 and for infrastructure return 0 (Auto in wt)
	}
      break;
    case SIOCGIWNWID:		//return -1. This is if ioctl failed and as a result
      EnableInterrupts (Adapter);
      return -1;		//wt(wireless tools) won't print a network ID
      break;
    case SIOCGIWNICKN:		//same as above, for the nickname
      EnableInterrupts (Adapter);
      return -1;
      break;
    case SIOCGIWFRAG:		//fragmentation threshold
      wrq->u.frag.value = Adapter->FragmentationThreshold;
      wrq->u.frag.fixed = 1;
      break;
    case SIOCGIWRTS:		//RTS threshold
      wrq->u.rts.value = Adapter->RtsThreshold;
      wrq->u.rts.fixed = 1;
      break;
    case SIOCGIWFREQ:		//Return m,e
      wrq->u.freq.m = Adapter->Channel;
      wrq->u.freq.e = 0;
      break;
    case SIOCGIWAP:		//Access Point Address
      VNetMoveMemory (wrq->u.ap_addr.sa_data, Adapter->CurrentBSSID, 6);
      wrq->u.ap_addr.sa_family = 1;
      break;
    case SIOCGIWPOWER:		//Power Management
      EnableInterrupts (Adapter);
      return -1;
      break;
    case SIOCGIWENCODE:
      if (Adapter->WepInfo.EncryptionLevel == 0)
	{
	  wrq->u.data.flags |= IW_ENCODE_DISABLED;
	  wrq->u.data.length = 0;
	}
      else
	{
	  wrq->u.data.flags &= ~IW_ENCODE_DISABLED;
	  wrq->u.data.flags |= (Adapter->WepInfo.WepKeyToUse + 1);

	  if (Adapter->WepInfo.WepMode == WEP_MODE_MANDATORY)
	    {
	      wrq->u.data.flags |= IW_ENCODE_RESTRICTED;
	    }

	  if (Adapter->WepInfo.AuthenticationType ==
	      C80211_MGMT_AAN_OPENSYSTEM)
	    wrq->u.data.flags |= IW_ENCODE_OPEN;
	  wrq->u.data.length =
	    (Adapter->WepInfo.EncryptionLevel == WEP_64BIT) ? 5 : 13;
	}

      copy_to_user (wrq->u.data.pointer,
		    ((PUCHAR) Adapter->WepInfo.WepKey1 +
		     ((Adapter->WepInfo.WepKeyToUse * 13))),
		    wrq->u.data.length);

/*                                copy_to_user(wrq->u.data.pointer, (PUCHAR)&Adapter->WepInfo.WepKey1 +
	                        ((Adapter->WepInfo.WepKeyToUse * 13)), wrq->u.data.length);
                                */
      break;
    case SIOCGIWRATE:		//Bitrate Used
      wrq->u.bitrate.fixed = 0;
      switch (Adapter->DataFramesTxRate)
	{
	case 0:
	  wrq->u.bitrate.value = 1000000;
	  break;
	case 1:
	  wrq->u.bitrate.value = 2000000;
	  break;
	case 2:
	  wrq->u.bitrate.value = 5500000;
	  break;
	case 3:
	  wrq->u.bitrate.value = 11000000;
	  break;
	default:
	  wrq->u.bitrate.value = 2000000000;
	  break;
	}
      break;
    case SIOCGIWSENS:		//AP Density. Currently not supported
      EnableInterrupts (Adapter);
      return -1;
      break;
      // Sets
    case SIOCSIWESSID:		//ESSID change
      memcpy (DevConfig.SSID, wrq->u.data.pointer, wrq->u.data.length - 1);
      DevConfig.SSIDlength = wrq->u.data.length - 1;
      ChangeConfiguration (Adapter, &DevConfig);
      break;
    case SIOCSIWFREQ:
      if (wrq->u.freq.m < 1 || wrq->u.freq.m > 14)
	{
	  EnableInterrupts (Adapter);
	  return -EINVAL;
	}
      DevConfig.Channel = wrq->u.freq.m;
      ChangeConfiguration (Adapter, &DevConfig);
      break;

    case SIOCSIWRATE:		//Bitrate Used
      if (wrq->u.bitrate.fixed == 0)
	{
	  DevConfig.TxRate = 4;
	  ChangeConfiguration (Adapter, &DevConfig);
	  EnableInterrupts (Adapter);
	  return 0;
	}
      if ((wrq->u.bitrate.value / 1000000) > 2)
	{
	  if ((wrq->u.bitrate.value / 1000000) > 6)
	    DevConfig.TxRate = 3;
	  else
	    DevConfig.TxRate = 2;
	}
      else
	DevConfig.TxRate = (wrq->u.bitrate.value / 1000000) - 1;
      ChangeConfiguration (Adapter, &DevConfig);
      break;
    case SIOCSIWENCODE:
      if (wrq->u.data.flags & IW_ENCODE_DISABLED)
	{
	  Adapter->WepInfo.EncryptionLevel = 0;
	  EnableInterrupts (Adapter);
	  return 0;
	}
      if (wrq->u.data.flags & IW_ENCODE_ENABLED)
	{
	  Adapter->WepInfo.EncryptionLevel = 1;
	  EnableInterrupts (Adapter);
	  return 0;
	}

      if (wrq->u.data.flags & IW_ENCODE_OPEN)
	Adapter->WepInfo.AuthenticationType = C80211_MGMT_AAN_OPENSYSTEM;

      if (wrq->u.data.flags & IW_ENCODE_RESTRICTED)
	{
	  Adapter->WepInfo.WepMode = WEP_MODE_MANDATORY;
	}
      else
	{
	  Adapter->WepInfo.WepMode = WEP_MODE_OPTIONAL;
	}

      if ((wrq->u.data.length != 5) && (wrq->u.data.length != 13))
	{
	  EnableInterrupts (Adapter);
	  return -EINVAL;
	}
      if (wrq->u.data.length == 5)
	{
	  Adapter->WepInfo.EncryptionLevel = WEP_64BIT;
	}
      else
	{
	  Adapter->WepInfo.EncryptionLevel = WEP_128BIT;
	}
      IF_LOUD (printk
	       (KERN_DEBUG "Using %dbit key, position %d\n",
		(Adapter->WepInfo.EncryptionLevel == WEP_64BIT) ? 64 : 128,
		(wrq->u.data.flags & IW_ENCODE_INDEX) - 1);)
      if ((Adapter->WepInfo.EncryptionLevel == WEP_64BIT)
	  || (Adapter->WepInfo.EncryptionLevel == WEP_128BIT))
	{
	  if ((wrq->u.data.flags & IW_ENCODE_INDEX) == 0)
	    {
	      Adapter->WepInfo.WepKeyToUse = 0;
	    }
	  else
	    Adapter->WepInfo.WepKeyToUse =
	      (wrq->u.data.flags & IW_ENCODE_INDEX) - 1;

	}
      else
	Adapter->WepInfo.WepKeyToUse = 0;
      if (Adapter->WepInfo.WepKeyToUse > 3)
	{
	  EnableInterrupts (Adapter);
	  return -EINVAL;
	}
      copy_from_user (((PUCHAR) Adapter->WepInfo.WepKey1 +
		       ((13 * Adapter->WepInfo.WepKeyToUse))),
		      wrq->u.data.pointer, wrq->u.data.length);

      update = 1;
      WEP_OR_SUPPORT = WeP;
      break;
    case SIOCSIWRTS:
      DevConfig.RtsCtsThreshold = wrq->u.rts.value;
      update = 1;
      WEP_OR_SUPPORT = SuP;
      break;
    case SIOCSIWFRAG:
      DevConfig.FragmentationThreshold = wrq->u.frag.value;
      update = 1;
      WEP_OR_SUPPORT = SuP;
      break;
    case SIOCSIWMODE:
      switch (wrq->u.mode)
	{
	case IW_MODE_ADHOC:
	  DevConfig.OperatingMode = 0;
	  break;
	case IW_MODE_INFRA:
	  DevConfig.OperatingMode = 1;
	  break;
	default:
	  return -EINVAL;
	}
      ChangeConfiguration (Adapter, &DevConfig);

      break;
    case SIOCGIWRANGE:
      EnableInterrupts (Adapter);
      return -1;
      break;
    case SIOCGIWPRIV:
      if (wrq->u.data.pointer)
	{
	  struct iw_priv_args priv[] = {	/* cmd, set_args, get_args, name */
	    {SIOCIWPRIVSPREAM, IW_PRIV_TYPE_INT | IW_PRIV_SIZE_FIXED | 1, 0,
	     "set_preamble"},
	    {SIOCIWPRIVGPREAM, 0, IW_PRIV_TYPE_CHAR | 6, "get_preamble"},
	  };
	  wrq->u.data.length = sizeof (priv) / sizeof (priv[0]);
	  if (copy_to_user (wrq->u.data.pointer, priv, sizeof (priv)))
	    {
	      EnableInterrupts (Adapter);
	      return -EFAULT;
	    }
	}
      break;
    case SIOCIWPRIVSPREAM:
      DevConfig.PreambleType = *((int *) wrq->u.name) & 1;
      ChangeConfiguration (Adapter, &DevConfig);
      break;
    case SIOCIWPRIVGPREAM:
      if (wrq->u.data.pointer)
	{
	  wrq->u.data.flags = 1;
	  if (DevConfig.PreambleType)
	    {
	      wrq->u.data.length = 6;
	      if (copy_to_user (wrq->u.data.pointer, "short", 6))
		{
		  EnableInterrupts (Adapter);
		  return -EFAULT;
		}
	    }
	  else
	    {
	      wrq->u.data.length = 5;
	      if (copy_to_user (wrq->u.data.pointer, "long", 5))
		{
		  EnableInterrupts (Adapter);
		  return -EFAULT;
		}
	    }
	}
      break;
    default:
      rc = -EOPNOTSUPP;
      break;
    }
  // After Getting Request Check if Updates are Needed and if so
  // Run Configure_WEP(1) or ChangeConfiguration(2)
  if (update == 1)
    {
      switch (WEP_OR_SUPPORT)
	{
	case WeP:
	  ConfigureWEP (Adapter);
	  ResetAdapter (Adapter, TRUE);
	  break;
	case SuP:
	  ChangeConfiguration (Adapter, &DevConfig);
	  //Reset ?
	  break;
	default:
	  //Case of error
	  EnableInterrupts (Adapter);
	  return -1;
	  break;
	}
      update = 0;
    }
  EnableInterrupts (Adapter);
  return rc;
}

// Iwconfig statistics...
#if (LINUX_VERSION_CODE >= 0x020213)
struct iw_statistics *
vnet_get_wireless_stats (struct net_device *dev)
#else
struct iw_statistics *
vnet_get_wireless_stats (struct device *dev)
#endif
{
  struct net_local *local = (struct net_local *) dev->priv;
  PVNet_ADAPTER Adapter = &local->Adapter;
  local->wstats.status = 0;
  IF_VERY_LOUD (DbgPrint ("-> vnet_get_wireless_stats(%s)\n", dev->name);)
    if (Adapter->OperatingMode == INFRASTRUCTURE_MODE)
    {
      local->wstats.qual.qual = 40 - Adapter->LinkQuality;
      local->wstats.qual.level = Adapter->Rssi;
      local->wstats.qual.noise = 0;	//max(min( , 0x8a), 0x2f) - 0x95;
      local->wstats.qual.updated = 7;
    }
  else
    {
      // Quality levels cannot be determined in ad-hoc mode,
      // because we can 'hear' more that one remote station.
      local->wstats.qual.qual = 0;
      local->wstats.qual.level = 0;
      local->wstats.qual.noise = 0;
      local->wstats.qual.updated = 0;
    }
  // Packets discarded in the wireless adapter due to wireless specific problems
  local->wstats.discard.nwid = 0;
  local->wstats.discard.code = 0;
  local->wstats.discard.misc = 0;
  IF_VERY_LOUD (DbgPrint ("<- vnet_get_wireless_stats()\n");) return (&local->
								      wstats);
}
#endif



// Kernel Specific Functions

VOID
SetMgmtTimer (PVNet_ADAPTER Adapter)
{
#if (LINUX_VERSION_CODE < VERSION(2,3,0))
  if (Adapter->MgmtTimer->prev == (struct timer_list *) NULL)
    {
      /* set timer to expire in WATCHDOG_JIFFIES */
      Adapter->MgmtTimer->expires = jiffies + MGMT_JIFFIES;
      add_timer (Adapter->MgmtTimer);
    }
#else
  if (Adapter->MgmtTimer->list.prev == (struct list_head *) NULL)
    {
      /* set timer to expire in WATCHDOG_JIFFIES */
      Adapter->MgmtTimer->expires = jiffies + MGMT_JIFFIES;
      add_timer (Adapter->MgmtTimer);
    }
#endif
}

VOID
VnetSleep (ULONG stime)
{
  mdelay (stime / 1000);
}

VOID
VNet_netif_wake_queue (PVNet_ADAPTER Adapter)
{
  netif_wake_queue (Adapter->dev);
}

VOID
RxIndicatePacket (PVNet_ADAPTER Adapter, PUCHAR pRxBuf, ULONG PacketLength,
		  ULONG IndicateLen)
{
#if (LINUX_VERSION_CODE > 0x020213)
  struct net_device *dev = (struct net_device *) Adapter->dev;
#else
  struct device *dev = (struct device *) Adapter->dev;
#endif
  struct sk_buff *skb;

  skb = dev_alloc_skb (PacketLength + 2);
  if (!skb)
    {
      Adapter->Stats.RxLost++;
      return;
    }
  skb_reserve (skb, 2);
  VNetMoveMemory (skb_put (skb, PacketLength), pRxBuf, PacketLength);
  Adapter->dev->last_rx = jiffies;
  skb->dev = dev;
  skb->protocol = eth_type_trans (skb, dev);
  skb->ip_summed = CHECKSUM_NONE;
  netif_rx (skb);
  return;
}

#if defined(REV_D)
#include "fwr_d.h"
#elif defined(REV_E)
#include "fwr_e.h"
#elif defined(R504)
#include "fwr504.h"
#elif defined(PCI)
#include "fwr506.h"
#elif defined(RFMD)
#include "fwr.h"
#elif defined(RFMD_3COM)
#include "fwr_3COM.h"
#endif //REV_D

BOOLEAN
GetFwFromFile (PVNet_ADAPTER Adapter)
{
  return FALSE;
}

BOOLEAN
GetDefaultFw (PVNet_ADAPTER Adapter)
{
  ULONG SoFw = sizeof (BasicFW);

  IF_LOUD (DbgPrint ("--=+>GetFwFile BasicFW : %d, \n", SoFw);) Adapter->
    MappedFirmwareBuffer = (PUCHAR) kmalloc (SoFw, GFP_KERNEL);
  IF_LOUD (DbgPrint
	   ("Fw Mapped in : 0x%08X\n",
	    Adapter->MappedFirmwareBuffer);) VNetZeroMemory (Adapter->
							     MappedFirmwareBuffer,
							     SoFw);
  VNetMoveMemory (Adapter->MappedFirmwareBuffer, BasicFW, SoFw);
  Adapter->FirmwareFileLength = SoFw;
  IF_LOUD (DbgPrint ("<=- Out of GetFwFile\n");) return TRUE;
}

#ifdef PCI
#if (LINUX_VERSION_CODE > 0x020213)
int
vnet_pci_probe (struct pci_dev *dev, const struct pci_device_id *id)
{
  long ioaddr0 = 0, ioaddr1;
  //unsigned short i, tmp;
  int res, ret;
  struct net_local *local;
  //unsigned short basemem = 0;

  local = kmalloc (sizeof (struct net_local), GFP_KERNEL);
  if (!local)
    return -ENOMEM;
  memset (local, 0, sizeof (struct net_local));

  res = pci_enable_device (dev);

  if (res < 0)
    {
      DbgPrint (" Failed to enable device %d\n", res);
      return res;
    }
//      ioaddr0 = pci_resource_start(dev, 0);
  ioaddr1 = pci_resource_start (dev, 1);
  if (!ioaddr1 || (!(pci_resource_flags (dev, 1) & IORESOURCE_IO)))
    return -ENODEV;

  if (request_region (ioaddr1, VNET_IO_LENGTH, "pcifvnet") == NULL)
    return -EBUSY;

  ret = request_irq (dev->irq, vnet_interrupt, SA_SHIRQ, dev->name, dev);
  if (ret != 0)
    return ret;

  DbgPrint (__FILE__ " Io0 %08x, Io1 %04x, Irq %d\n", ioaddr0, ioaddr1,
	    dev->irq);

  local->Adapter.pci = dev;
  local->Adapter.IoBase = ioaddr1;
  local->Adapter.dev = init_etherdev (NULL, 0);
  if (local->Adapter.dev == NULL)
    return -1;
  local->Adapter.pci = dev;

  IF_LOUD (DbgPrint (__FILE__ " Net Device : 0x%08x\n ", local->Adapter.dev);)
    local->Adapter.IsUp = TRUE;
  spin_lock_init (&local->slock);
  InitAdapter (&local->Adapter);

  local->Adapter.pci->driver_data = local->Adapter.dev;
  local->Adapter.dev->open = vnet_open;
  local->Adapter.dev->stop = vnet_close;
  local->Adapter.dev->hard_start_xmit = vnet_tx;
  local->Adapter.dev->priv = local;
  local->Adapter.dev->addr_len = 6;
  local->Adapter.dev->mtu = mtu;
  local->Adapter.dev->irq = dev->irq;
  local->Adapter.dev->base_addr = ioaddr1;
  memset (local->Adapter.dev->dev_addr, 0xff, 6);
  IF_LOUD (DbgPrint ("To Set Parameters -->\n");) SetParameters (&local->
								 Adapter);
  IF_LOUD (DbgPrint ("Init And Start Card\n");)
    if (!InitAndStartCard (&local->Adapter))
    return -1;

  memcpy (local->Adapter.dev->dev_addr, local->Adapter.CurrentAddress, 6);
  DbgPrint (" Mac : %02x:%02x:%02x:%02x:%02x:%02x\n",
	    local->Adapter.dev->dev_addr[0], local->Adapter.dev->dev_addr[1],
	    local->Adapter.dev->dev_addr[2], local->Adapter.dev->dev_addr[3],
	    local->Adapter.dev->dev_addr[4], local->Adapter.dev->dev_addr[5]);

  // Initialize specific data
  local->Adapter.MgmtTimer = kmalloc (sizeof (struct timer_list), GFP_KERNEL);
  init_timer (local->Adapter.MgmtTimer);
  local->Adapter.MgmtTimer->function = MgmtTimer;
  local->Adapter.MgmtTimer->data = (unsigned long) local->Adapter.dev;

  local->Adapter.dev->get_stats = vnet_get_stats;

#ifdef WIRELESS_EXT
  local->Adapter.dev->do_ioctl = vnet_ioctl;
  local->Adapter.dev->get_wireless_stats = vnet_get_wireless_stats;
#endif
  EnableInterrupts (&local->Adapter);
  printk ("ATMEL Wireless PCI card version %d.%d.%d.%d\n",
	  FAST_VNET_MAJOR_VERSION, FAST_VNET_MINOR_VERSION,
	  FAST_VNET_SUB_VERSION, FAST_VNET_BUILD);
  return 0;
}

void
vnet_pci_remove (struct pci_dev *dev)
{
  struct net_device *net = (struct net_device *) dev->driver_data;
  PVNet_ADAPTER Adapter =
    (PVNet_ADAPTER) (&((struct net_local *) net->priv)->Adapter);
  DbgPrint ("Device Disconnecting\n");
  DisableInterrupts (Adapter);
  del_timer (Adapter->MgmtTimer);
  netif_stop_queue (net);
  netif_device_detach (net);
  Adapter->IsUp = FALSE;
  free_irq (dev->irq, dev);
  unregister_netdev (net);
  net->priv = NULL;
  net->name[0] = '\0';
  kfree (net);

  release_region (Adapter->IoBase, VNET_IO_LENGTH);
}

struct pci_device_id vnet_pci_id_table[] = {
    { 0x1114, 0x0506, PCI_ANY_ID, PCI_ANY_ID},
    { 0,}
};

struct pci_driver vnet_pci_driver = {
name:"pcifvnet",
id_table:vnet_pci_id_table,
probe:&vnet_pci_probe,
remove:&vnet_pci_remove
};

int __init
vnet_init (void)
{
  DbgPrint (KERN_INFO "registering\n");
  return pci_module_init (&vnet_pci_driver);
}

void __exit
vnet_exit (void)
{
  pci_unregister_driver (&vnet_pci_driver);
}

MODULE_AUTHOR ("DriversGroup");

module_init (vnet_init);
module_exit (vnet_exit);

#endif
#endif

/********************************************************************
 *PCI KERNEL : v2.2 Patch
 ********************************************************************/
#ifdef PCI
#if LINUX_VERSION_CODE <= 0x020213

MODULE_AUTHOR ("DriversGroup");

/* Used to pass the full-duplex flag, etc. */
#define MAX_UNITS 8		/* More are supported, limit only on options */
static int options[MAX_UNITS] = { -1, -1, -1, -1, -1, -1, -1, -1 };
static int full_duplex[MAX_UNITS] = { -1, -1, -1, -1, -1, -1, -1, -1 };

enum pci_flags_bit
{
  PCI_USES_IO = 1, PCI_USES_MEM = 2, PCI_USES_MASTER = 4,
  PCI_ADDR0 = 0x10 << 0, PCI_ADDR1 = 0x10 << 1, PCI_ADDR2 =
    0x10 << 2, PCI_ADDR3 = 0x10 << 3,
};

struct pci_id_info
{
  const char *name;
  u16 vendor_id, device_id, device_id_mask, flags;
  int io_size;
  struct device *(*probe1) (int pci_bus, int pci_devfn, struct device * dev,
			    long ioaddr, int irq, int bug, int fnd_cnt);
};

static struct device *vnet_pci_probe1 (int pci_bus, int pci_devfn,
				       struct device *dev, long ioaddr,
				       int irq, int bug, int fnd_cnt);

static struct pci_id_info pci_tbl[] = { {"pcifvnet",
					 0x1114, 0x0506, 0xffff, PCI_USES_IO,
					 0x20, vnet_pci_probe1},
{0,},				/* 0 terminated list. */
};


/* A list of all installed pci devices, for removing the driver module. */
static struct device *vnet_pci_dev = NULL;


int
vnet_pci_probe (struct device *dev)
{
  int cards_found = 0;
  int pci_index = 0;
  unsigned char pci_bus, pci_device_fn;

  if (!pcibios_present ())
    return -ENODEV;

  for (; pci_index < 0xff; pci_index++)
    {
      u16 vendor, device, pci_command, new_command;
      int chip_idx, irq;
      long ioaddr;

      if (pcibios_find_class (PCI_CLASS_NETWORK_ETHERNET << 8, pci_index,
			      &pci_bus, &pci_device_fn) != PCIBIOS_SUCCESSFUL)
	break;
      pcibios_read_config_word (pci_bus, pci_device_fn,
				PCI_VENDOR_ID, &vendor);
      pcibios_read_config_word (pci_bus, pci_device_fn,
				PCI_DEVICE_ID, &device);

      if (!((vendor == pci_tbl[0].vendor_id) &&
	    ((device & pci_tbl[0].device_id_mask) == pci_tbl[0].device_id)))
	continue;
      {
	u32 pci_ioaddr;
	u32 pci_ioaddr2;
	u8 pci_irq_line;

	pcibios_read_config_byte (pci_bus, pci_device_fn, PCI_INTERRUPT_LINE,
				  &pci_irq_line);

	pcibios_read_config_dword (pci_bus, pci_device_fn, PCI_BASE_ADDRESS_1,
				   &pci_ioaddr);

	ioaddr = pci_ioaddr & ~3;

	irq = pci_irq_line;
      }

      if ((pci_tbl[0].flags & PCI_USES_IO) &&
	  check_region (ioaddr, pci_tbl[0].io_size))
	continue;

      pcibios_read_config_word (pci_bus, pci_device_fn, PCI_COMMAND,
				&pci_command);
      new_command = pci_command | (pci_tbl[0].flags & 7);
      if (pci_command != new_command)
	{
	  printk (KERN_INFO "  The PCI BIOS has not enabled the"
		  " device at %d/%d!  Updating PCI command %4.4x->%4.4x.\n",
		  pci_bus, pci_device_fn, pci_command, new_command);
	  pcibios_write_config_word (pci_bus, pci_device_fn, PCI_COMMAND,
				     new_command);
	}

      dev =
	pci_tbl[0].probe1 (pci_bus, pci_device_fn, dev, ioaddr, irq, 0,
			   cards_found);

      if (dev && (pci_tbl[0].flags & PCI_COMMAND_MASTER))
	{
	  u8 pci_latency;
	  pcibios_read_config_byte (pci_bus, pci_device_fn, PCI_LATENCY_TIMER,
				    &pci_latency);
	  if (pci_latency < 32)
	    {
	      pcibios_write_config_byte (pci_bus, pci_device_fn,
					 PCI_LATENCY_TIMER, 32);
	    }
	}
      dev = 0;
      cards_found++;
    }

  return cards_found ? 0 : -ENODEV;
}

static struct device *
vnet_pci_probe1 (int pci_bus, int pci_devfn,
		 struct device *dev, long ioaddr,
		 int irq, int bug, int found_cnt)
{
  struct net_local *local;
  int ret, res;
  int i, option = found_cnt < MAX_UNITS ? options[found_cnt] : 0;

  local = kmalloc (sizeof (struct net_local), GFP_KERNEL);
  if (local == NULL)
    return 0;
  memset (local, 0, sizeof (struct net_local));
  dev = init_etherdev (dev, 0);

  dev->irq = irq;
  dev->base_addr = ioaddr;
  dev->priv = local;
  vnet_pci_dev = dev;
  local->dev = dev;
  local->pci_bus = pci_bus;
  local->pci_devfn = pci_devfn;

  request_region (ioaddr, pci_tbl[0].io_size, "pcifvnet");
  ret = request_irq (irq, vnet_interrupt, SA_SHIRQ, "pcifvnet", local->dev);

  if (ret != 0)
    return 0;

  DbgPrint (__FILE__ " " __FUNCTION__ " Io1 %04x, Irq %d\n", ioaddr,
	    dev->irq);

  local->Adapter.IoBase = ioaddr;
  local->Adapter.dev = dev;
  IF_LOUD (DbgPrint
	   (__FILE__ " " __FUNCTION__ "Net Device : 0x%08x\n ",
	    local->Adapter.dev);) local->Adapter.IsUp = TRUE;
  spin_lock_init (&local->slock);
  InitAdapter (&local->Adapter);

  local->Adapter.dev->open = vnet_open;
  local->Adapter.dev->stop = vnet_close;
  local->Adapter.dev->hard_start_xmit = vnet_tx;
  local->Adapter.dev->priv = local;
  local->Adapter.dev->addr_len = 6;
  local->Adapter.dev->mtu = mtu;
  local->Adapter.dev->irq = dev->irq;
  local->Adapter.dev->base_addr = ioaddr;
  memset (local->Adapter.dev->dev_addr, 0xff, 6);
  IF_LOUD (DbgPrint ("To Set Parameters -->\n");) SetParameters (&local->
								 Adapter);
  if (!InitAndStartCard (&local->Adapter))
    return 0;

  memcpy (local->Adapter.dev->dev_addr, local->Adapter.CurrentAddress, 6);

  register_netdev (local->Adapter.dev);

  DbgPrint (__FUNCTION__ " Mac : %02x:%02x:%02x:%02x:%02x:%02x\n",
	    local->Adapter.dev->dev_addr[0], local->Adapter.dev->dev_addr[1],
	    local->Adapter.dev->dev_addr[2], local->Adapter.dev->dev_addr[3],
	    local->Adapter.dev->dev_addr[4], local->Adapter.dev->dev_addr[5]);

  // Initialize specific data
  local->Adapter.MgmtTimer = kmalloc (sizeof (struct timer_list), GFP_KERNEL);
  init_timer (local->Adapter.MgmtTimer);
  local->Adapter.MgmtTimer->function = MgmtTimer;
  local->Adapter.MgmtTimer->data = (unsigned long) local->Adapter.dev;

  local->Adapter.dev->get_stats = vnet_get_stats;


#ifdef WIRELESS_EXT
  local->Adapter.dev->do_ioctl = vnet_ioctl;
  local->Adapter.dev->get_wireless_stats = vnet_get_wireless_stats;
#endif
  EnableInterrupts (&local->Adapter);
  printk ("ATMEL Wireless PCI card version %d.%d.%d.%d\n",
	  FAST_VNET_MAJOR_VERSION, FAST_VNET_MINOR_VERSION,
	  FAST_VNET_SUB_VERSION, FAST_VNET_BUILD);

  return dev;
}

int
init_module (void)
{
  return vnet_pci_probe (0);
}

void
cleanup_module (void)
{

  struct net_local *local = (struct net_local *) vnet_pci_dev->priv;

  PVNet_ADAPTER Adapter =
    (PVNet_ADAPTER) (&((struct net_local *) vnet_pci_dev->priv)->Adapter);

  DbgPrint ("Device Disconnecting\n");
  DisableInterrupts (Adapter);
  del_timer (Adapter->MgmtTimer);
  netif_stop_queue (vnet_pci_dev);
  netif_device_detach (vnet_pci_dev);
  Adapter->IsUp = FALSE;
  free_irq (vnet_pci_dev->irq, vnet_pci_dev);
  unregister_netdev (vnet_pci_dev);
  vnet_pci_dev->priv = NULL;
  vnet_pci_dev->name[0] = '\0';
  kfree (vnet_pci_dev);

  release_region (Adapter->IoBase, VNET_IO_LENGTH);
}

#endif
#endif
