/////////////////////////////////////////////////
//
//	Adress map of all DSC25 Registers
//
/////////////////////////////////////////////////

#ifndef __DSC25DEF_H__
#define __DSC25DEF_H__

// SDRAM BASE
#define SDRAM_BASE            (PA_DSC25_BASE + 0x00020000)
#define VIDMEM_OFFSET         SDRAM_BASE
#define VIDMEM_SIZE	      (0x00066000UL)

// DSPRAM
#define DSPRAM_BASE         	0x00040000  // DSPRAM base address

// memory mapped registers
#define TIMER0_REGISTER_BASE    DSC25IO(0x00030000)		// timer0
#define TIMER1_REGISTER_BASE	DSC25IO(0x00030080)		// timer1
#define TIMER2_REGISTER_BASE	DSC25IO(0x00030100)		// timer2
#define TIMER3_REGISTER_BASE	DSC25IO(0x00030180)		// timer3
#define SERIAL0_REGISTER_BASE	DSC25IO(0x00030200)		// serial0
#define SERIAL1_REGISTER_BASE	DSC25IO(0x00030280)		// serial1
#define UART0_REGISTER_BASE	DSC25IO(0x00030300)		// UART0
#define UART1_REGISTER_BASE	DSC25IO(0x00030380)		// UART0
#define WDT_REGISTER_BASE	DSC25IO(0x00030400)		// watch dog timer
#define USB_REGISTER_BASE	DSC25IO(0x00030480)		// USB
#define INTCTRL_REGISTER_BASE	DSC25IO(0x00030500)		// INTC
#define GIO_REGISTER_BASE	DSC25IO(0x00030580)		// GIO
#define DSPC_REGISTER_BASE	DSC25IO(0x00030600)		// DSP controller
#define OSD_REGISTER_BASE	DSC25IO(0x00030680)		// OSD
#define CCDC_REGISTER_BASE	DSC25IO(0x00030700)		// CCD controller
#define PREVIEW_REGISTER_BASE	DSC25IO(0x00030780)		// preview engine
#define VIDEOENC_REGISTER_BASE	DSC25IO(0x00030800)		// NTSC/PAL encoder
#define CLOCKC_REGISTER_BASE	DSC25IO(0x00030880)		// clock controller
#define BUSC_REGISTER_BASE	DSC25IO(0x00030900)		// bus controller
#define SDRAMC_REGISTER_BASE	DSC25IO(0x00030980)		// SDRAM controller
#define EXBC_REGISTER_BASE	DSC25IO(0x00030A00)		// external bus controller
#define SDMMC_REGISTER_BASE	DSC25IO(0x00030A80)		// SD/MMC bus controller
#define MS_REGISTER_BASE	DSC25IO(0x00030B00)		// memory stick bus controller

#define	TIMER0_MD		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x00) )
#define	TIMER0_CKSEL		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x02) )
#define	TIMER0_PRSCL		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x04) )
#define	TIMER0_VAL		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x06) )
#define	TIMER0_TRG		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x08) )
#define	TIMER0_CNT		(* (volatile unsigned short *)(TIMER0_REGISTER_BASE + 0x0A) )

#define	TIMER1_MD		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x00) )
#define	TIMER1_CKSEL		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x02) )
#define	TIMER1_PRSCL		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x04) )
#define	TIMER1_VAL		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x06) )
#define	TIMER1_TRG		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x08) )
#define	TIMER1_CNT		(* (volatile unsigned short *)(TIMER1_REGISTER_BASE + 0x0A) )

#define	TIMER2_MD		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x00) )
#define	TIMER2_CKSEL		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x02) )
#define	TIMER2_PRSCL		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x04) )
#define	TIMER2_VAL		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x06) )
#define	TIMER2_TRG		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x08) )
#define	TIMER2_CNT		(* (volatile unsigned short *)(TIMER2_REGISTER_BASE + 0x0A) )

#define	WDT_MD			(* (volatile unsigned short *)(WDT_REGISTER_BASE + 0x00) )
#define	WDT_RST			(* (volatile unsigned short *)(WDT_REGISTER_BASE + 0x02) )
#define	WDT_PRSCL		(* (volatile unsigned short *)(WDT_REGISTER_BASE + 0x04) )
#define	WDT_VAL			(* (volatile unsigned short *)(WDT_REGISTER_BASE + 0x06) )

#define	INTC_FIQ0R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x00) )
#define	INTC_FIQ1R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x02) )
#define	INTC_IRQ0R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x04) )
#define	INTC_IRQ1R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x06) )
#define	INTC_FIQENTRY0		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x08) )
#define	INTC_FIQENTRY1		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x0A) )
#define	INTC_IRQENTRY0		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x0C) )
#define	INTC_IRQENTRY1		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x0E) )
#define	INTC_FISEL0		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x20) )
#define	INTC_FISEL1		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x22) )
#define	INTC_EIRQ0R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x24) )
#define	INTC_EIRQ1R		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x26) )
#define	INTC_INTRAW		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x28) )
#define	INTC_EABASE0		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x30) )
#define	INTC_EABASE1		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x32) )
#define	INTC_INTPRI0		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x40) )
#define	INTC_INTPRI1		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x42) )
#define	INTC_INTPRI2		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x44) )
#define	INTC_INTPRI3		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x46) )
#define	INTC_INTPRI4		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x48) )
#define	INTC_INTPRI5		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x4A) )
#define	INTC_INTPRI6		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x4C) )
#define	INTC_INTPRI7		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x4E) )
#define	INTC_INTPRI8		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x50) )
#define	INTC_INTPRI9		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x52) )
#define	INTC_INTPRI10		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x54) )
#define	INTC_INTPRI11		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x56) )
#define	INTC_INTPRI12		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x58) )
#define	INTC_INTPRI13		(* (volatile unsigned short *)(INTCTRL_REGISTER_BASE + 0x5A) )

#define EXBC_CARD_TYPE_CFC          0
#define EXBC_CARD_TYPE_SSFDC	    1

#define EXBC_IRQ_BUSY		0x01
#define EXBC_IRQ_STSCHG 	0x02
#define EXBC_IRQ_ATTACH		0x04
#define EXBC_IRQ_DETACH		0x08

#define EXBC_ST_CFRDY		0x01
#define EXBC_ST_CFWAIT		0x02
#define EXBC_ST_EMWAIT		0x04
#define EXBC_ST_STSCHG		0x08
#define EXBC_ST_CD1		0x10
#define EXBC_ST_CD2		0x20
#define EXBC_ST_IOIS16		0x40

#define EXBC_CS0CTRL1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x00) )
#define EXBC_CS0CTRL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x02) )
#define EXBC_CS1CTRL1A		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x04) )
#define EXBC_CS1CTRL1B		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x06) )
#define EXBC_CS1CTRL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x08) )
#define EXBC_CS2CTRL1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x0A) )
#define EXBC_CS2CTRL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x0C) )
#define EXBC_CS3CTRL1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x0E) )
#define EXBC_CS3CTRL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x10) )
#define EXBC_CS4CTRL1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x12) )
#define EXBC_CS4CTRL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x14) )
#define EXBC_BUSCTRL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x16) )
#define EXBC_BUSRSL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x18) )
#define EXBC_CFCTRL1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x1A) )
#define EXBC_CFCRTL2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x1C) )
#define EXBC_SMCTRL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x1E) )
#define EXBC_BUSINTEN		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x20) )
#define EXBC_BUSINTST		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x22) )
#define EXBC_BUSST		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x24) )
#define EXBC_WAITMD		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x26) )
#define EXBC_ECC1CP		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x28) )
#define EXBC_ECC1LP		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x2A) )
#define EXBC_ECC2CP		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x2C) )
#define EXBC_ECC2LP		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x2E) )
#define EXBC_ECCCLR		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x30) )
#define EXBC_PAGESZ		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x32) )
#define EXBC_VIFCDSPDEST	(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x34) )
#define EXBC_PRIORCTL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x36) )
#define EXBC_SOURADD1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x38) )
#define EXBC_SOURADD2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x3A) )
#define EXBC_DESTADD1		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x3C) )
#define EXBC_DESTADD2		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x3E) )
#define EXBC_DMASIZE		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x40) )
#define EXBC_DMADEVSEL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x42) )
#define EXBC_DMACTL		(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x44) )
#define EXBC_VIFCDSPADD1	(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x46) )
#define EXBC_VIFCDSPADD2	(* (volatile unsigned short*) (EXBC_REGISTER_BASE + 0x48) )

#define SDRAM_SDBUF0		(* (volatile unsigned short*) (SDRAMC_REGISTER_BASE + 0x00) )
#define SDRAM_AD0		(* (volatile unsigned short*) (SDRAMC_REGISTER_BASE + 0x20) )
#define SDRAM_AD1		(* (volatile unsigned short*) (SDRAMC_REGISTER_BASE + 0x22) )
#define SDRAM_CTL		(* (volatile unsigned short*) (SDRAMC_REGISTER_BASE + 0x24) )

#define SERIAL0_TXDATA		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x00) )
#define SERIAL0_RXDATA		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x02) )
#define SERIAL0_TXEN		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x04) )
#define SERIAL0_CONTROL		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x06) )

#define SERIAL1_TXDATA		(* (volatile unsigned short*) (SERIAL1_REGISTER_BASE + 0x00) )
#define SERIAL1_RXDATA		(* (volatile unsigned short*) (SERIAL1_REGISTER_BASE + 0x02) )
#define SERIAL1_TXEN		(* (volatile unsigned short*) (SERIAL1_REGISTER_BASE + 0x04) )
#define SERIAL1_CONTROL		(* (volatile unsigned short*) (SERIAL1_REGISTER_BASE + 0x06) )

#define SERIAL_DMATRG0		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x08) )
#define SERIAL_DMAMODE0		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x0A) )
#define SERIAL_DMASTAD0		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x0C) )
#define SERIAL_DMASTAD1		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x0E) )
#define SERIAL_DMASTAT0		(* (volatile unsigned short*) (SERIAL0_REGISTER_BASE + 0x10) )

#define UART0_DTRR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x00) )
#define UART0_BRSR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x02) )
#define UART0_MSR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x04) )
#define UART0_RFCR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x06) )
#define UART0_TFCR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x08) )
#define UART0_LCR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x0A) )
#define UART0_SR		(* (volatile unsigned short*) (UART0_REGISTER_BASE + 0x0C) )

#define UART1_DTRR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x00) )
#define UART1_BRSR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x02) )
#define UART1_MSR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x04) )
#define UART1_RFCR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x06) )
#define UART1_TFCR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x08) )
#define UART1_LCR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x0A) )
#define UART1_SR		(* (volatile unsigned short*) (UART1_REGISTER_BASE + 0x0C) )


#define GIO_DIR0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x00 ) )
#define GIO_DIR1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x02 ) )
#define GIO_INV0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x04 ) )
#define GIO_INV1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x06 ) )
#define GIO_BITSET0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x08 ) )
#define GIO_BITSET1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x0A ) )
#define GIO_BITCLR0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x0C ) )
#define GIO_BITCLR1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x0E ) )
#define GIO_IRQPORT		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x10 ) )
#define GIO_FSEL0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x12 ) )
#define GIO_FSEL1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x14 ) )
#define GIO_BITRATE0		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x16 ) )
#define GIO_BITRATE1		(* (volatile unsigned short*) ( GIO_REGISTER_BASE + 0x18 ) )

#define VENC_VID01		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x00) )
#define VENC_VID02		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x02) )
#define VENC_DLCD_MODE0		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x04) )
#define VENC_DLCD_MODE1		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x06) )
#define VENC_DCLK_PAT0		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x08) )
#define VENC_DCLK_PAT1		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x0A) )
#define VENC_DCLK_PAT2		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x0C) )
#define VENC_DCLK_PAT3		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x0E) )
#define VENC_DCLK_START_H	(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x10) )
#define VENC_DCLK_VAL_H		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x12) )
#define VENC_DCLK_START_V	(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x14) )
#define VENC_DCLK_VALID_V	(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x16) )
#define VENC_PULSE_WH		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x18) )
#define VENC_H_INT		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x1A) )
#define VENC_H_START		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x1C) )
#define VENC_H_VALID		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x1E) )
#define VENC_V_INT		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x20) )
#define VENC_V_START		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x22) )
#define VENC_V_VALID		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x24) )
#define VENC_HSYNC_DELAY	(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x26) )
#define VENC_VSYNC_DELAY	(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x28) )
#define VENC_CULINE		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x2A) )
#define VENC_PWM_CTRL		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x2C) )
#define VENC_PWM_CTN		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x2E) )
#define VENC_RGB_LEVEL		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x30) )
#define VENC_ATTRIB_0		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x32) )
#define VENC_ATTRIB_1		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x34) )
#define VENC_ATTRIB_2		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x36) )
#define VENC_REC601		(* (volatile unsigned short*) (VIDEOENC_REGISTER_BASE + 0x38) )

#define CLOCKC_PLLARM		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x00) )
#define CLOCKC_PLLDSP		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x02) )
#define CLOCKC_PLLSDR		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x04) )
#define CLOCKC_CLKC		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x06) )
#define CLOCKC_DIV		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x08) )
#define CLOCKC_MMCLK		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x0A) )
#define CLOCKC_MSCLK		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x0C) )
#define CLOCKC_BYP		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x0E) )
#define CLOCKC_LPCTL1		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x10) )
#define CLOCKC_LPCTL2		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x12) )
#define CLOCKC_MOD1		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x14) )
#define CLOCKC_MOD2		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x16) )
#define CLOCKC_PLLSETA		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x18) )
#define CLOCKC_PLLSETB		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x1A) )
#define CLOCKC_PLLSETC		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x1C) )
#define CLOCKC_SDRDLY		(* (volatile unsigned short*) (CLOCKC_REGISTER_BASE + 0x1E) )

#if 0
#define BUSC_ECR		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x00) )
#define BUSC_EBYTER		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x02) )
#define BUSC_EBITR		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x04) )
#define BUSC_REVR		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x06) )
#else
#define BUSC_REVR		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x00) )
#define BUSC_RTRGSEL		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x02) )
#define BUSC_EMWAITEN		(* (volatile unsigned short*) (BUSC_REGISTER_BASE + 0x04) )
#endif

#define OSD_MODE		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x00) )
#define OSD_VIDEOWIN_MODE	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x02) )
#define OSD_OSDWIN0_MODE	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x04) )
#define OSD_OSDWIN1_MODE	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x06) )
#define OSD_RECT_CURS		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x08) )
#define OSD_BITMAP_CURS		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x0A) )
#define OSD_VIDEOWIN0_OFF	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x0C) )
#define OSD_VIDEOWIN1_OFF	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x0E) )
#define OSD_OSDWIN0_OFF		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x10) )
#define OSD_OSDWIN1_ATT_OFF	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x12) )
#define OSD_VIDEOWIN_ADH	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x14) )
#define OSD_VIDEOWIN0_ADL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x16) )
#define OSD_VIDEOWIN1_ADL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x18) )
#define OSD_OSDWIN_ADUP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x1A) )
#define OSD_OSDWIN0_ADL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x1C) )
#define OSD_OSDWIN1_ATT_ADL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x1E) )
#define OSD_BASEP_X		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x20) )
#define OSD_BASEP_Y		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x22) )
#define OSD_VIDEOWIN0_XP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x24) )
#define OSD_VIDEOWIN0_YP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x26) )
#define OSD_VIDEOWIN0_XL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x28) )
#define OSD_VIDEOWIN0_YL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x2A) )
#define OSD_VIDEOWIN1_XP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x2C) )
#define OSD_VIDEOWIN1_YP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x2E) )
#define OSD_VIDEOWIN1_XL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x30) )
#define OSD_VIDEOWIN1_YL	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x32) )
#define OSD_OSDWIN0_XP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x34) )
#define OSD_OSDWIN0_YP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x36) )
#define OSD_OSDWIN0_XL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x38) )
#define OSD_OSDWIN0_YL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x3A) )
#define OSD_OSDWIN1_XP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x3C) )
#define OSD_OSDWIN1_YP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x3E) )
#define OSD_OSDWIN1_XL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x40) )
#define OSD_OSDWIN1_YL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x42) )
#define OSD_CUR_XP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x44) )
#define OSD_CUR_YP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x46) )
#define OSD_CUR_XL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x48) )
#define OSD_CUR_YL		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x4A) )
#define OSD_BMPCUR_XP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x4C) )
#define OSD_BMPCUR_YP		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x4E) )
#define OSD_BITMAP01_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x50) )
#define OSD_BITMAP23_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x52) )
#define OSD_BITMAP45_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x54) )
#define OSD_BITMAP67_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x56) )
#define OSD_BITMAP89_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x58) )
#define OSD_BITMAPAB_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x5A) )
#define OSD_BITMAPCD_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x5C) )
#define OSD_BITMAPEF_0		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x5E) )
#define OSD_BITMAP01_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x60) )
#define OSD_BITMAP23_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x62) )
#define OSD_BITMAP45_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x64) )
#define OSD_BITMAP67_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x66) )
#define OSD_BITMAP89_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x68) )
#define OSD_BITMAPAB_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x6A) )
#define OSD_BITMAPCD_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x6C) )
#define OSD_BITMAPEF_1		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x6E) )
#define OSD_BITMAPCUR_DATA	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x74) )
#define OSD_CTRL_MISC		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x76) )
#define OSD_CLUTRAM_YCB		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x76) )
#define OSD_CLUTRAM_CR		(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x78) )
#define OSD_VIDEOWIN0_AD0PP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x7C) )
#define OSD_VIDEOWIN0_AD1PP	(* (volatile unsigned short*) (OSD_REGISTER_BASE + 0x7E) )


#define	PREV_PVEN		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x00 ) )
#define	PREV_PVSET1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x02 ) )
#define	PREV_RADDU		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x04 ) )
#define	PREV_RADDL		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x06 ) )
#define	PREV_WADDU		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x08 ) )
#define	PREV_WADDL		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x0A ) )
#define	PREV_HSRT		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x0C ) )
#define	PREV_HSIZE		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x0E ) )
#define	PREV_VSRT		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x10 ) )
#define	PREV_VSIZE		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x12 ) )
#define	PREV_PVSET2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x14 ) )
#define	PREV_NFIL		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x16 ) )
#define	PREV_DGAIN		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x18 ) )
#define	PREV_WBGAIN_0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x1A ) )
#define	PREV_WBGAIN_1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x1C ) )
#define	PREV_WBGAIN_2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x1E ) )
#define	PREV_WBGAIN_3		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x20 ) )
#define	PREV_WBGAIN_4		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x22 ) )
#define	PREV_WBGAIN_5		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x24 ) )
#define	PREV_WBBP_01		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x26 ) )
#define	PREV_WBBP_12		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x28 ) )
#define	PREV_WBOFST_0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x2A ) )
#define	PREV_WBOFST_1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x2C ) )
#define	PREV_WBOFST_2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x2E ) )
#define	PREV_WBOFST_3		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x30 ) )
#define	PREV_WBOFST_4		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x32 ) )
#define	PREV_WBOFST_5		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x34 ) )
#define	PREV_WBOFST_6		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x36 ) )
#define	PREV_WBOFST_7		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x38 ) )
#define	PREV_SMTH		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x3A ) )
#define	PREV_H_RSZ		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x3C ) )
#define	PREV_V_RSZ		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x3E ) )
#define	PREV_BLOFST_0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x40 ) )
#define	PREV_BLOFST_1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x42 ) )
#define	PREV_MTXGAIN_0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x44 ) )
#define	PREV_MTXGAIN_1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x46 ) )
#define	PREV_MTXGAIN_2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x48 ) )
#define	PREV_MTXGAIN_3		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x4A ) )
#define	PREV_MTXGAIN_4		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x4C ) )
#define	PREV_MTXOFST_0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x4E ) )
#define	PREV_MTXOFST_1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x50 ) )
#define	PREV_MTXOFST_2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x52 ) )
#define	PREV_BYP_GAM		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x54 ) )
#define	PREV_CSC0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x56 ) )
#define	PREV_CSC1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x58 ) )
#define	PREV_CSC2		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x5A ) )
#define	PREV_CSC3		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x5C ) )
#define	PREV_CSC4		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x5E ) )
#define	PREV_Y_OFST		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x60 ) )
#define	PREV_C_OFST		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x62 ) )
#define	PREV_CNTBRT		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x64 ) )
#define	PREV_CSUP0		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x66 ) )
#define	PREV_CSUP1		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x68 ) )
#define	PREV_SETUP_Y		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x6A ) )
#define	PREV_SETUP_C		(* (volatile unsigned short *)(PREVIEW_REGISTER_BASE + 0x6C ) )

#define PVSET1_PVOS	0x0010	// Preview one shot
#define PVSET1_RSONLY	0x0008	// Re-size only : 0 -> raw CCD data - 1 -> YCbCr-4:2:2
#define PVSET1_INMODE	0x0004	// Input mode : 0 -> CCD controller - 1 -> SDRAM controller
#define PVSET1_BSTAL	0x0002	// burst aligned
#define PVSET1_WEN	0x0001	// Write enable

#define CCDC_SYNCEN	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x00 ) )
#define CCDC_MODESET	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x02 ) )
#define CCDC_HDW	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x04 ) )
#define CCDC_VDW	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x06 ) )
#define CCDC_PPLN	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x08 ) )
#define CCDC_LPFR	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x0A ) )
#define CCDC_SPH	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x0C ) )
#define CCDC_LPH	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x0E ) )
#define CCDC_SLV0	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x10 ) )
#define CCDC_SLV1	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x12 ) )
#define CCDC_LNV	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x14 ) )
#define CCDC_CULH	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x16 ) )
#define CCDC_CULV	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x18 ) )
#define CCDC_HSIZE	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x1A ) )
#define CCDC_CADU	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x1C ) )
#define CCDC_CADL	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x1E ) )
#define CCDC_CCLAMP	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x20 ) )
#define CCDC_CDCSUB	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x22 ) )
#define CCDC_CCOLP	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x24 ) )
#define CCDC_COFST0	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x26 ) )
#define CCDC_COFST1	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x28 ) )
#define CCDC_CMFIL	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x2A ) )
#define CCDC_CGAIN	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x2C ) )
#define CCDC_COFSTA	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x2E ) )
#define CCDC_VDINT1	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x30 ) )
#define CCDC_VDINT2	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x32 ) )
#define CCDC_SHUTCTL	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x34 ) )
#define CCDC_CGAMMA	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x36 ) )
#define CCDC_CGAMMAWD	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x38 ) )
#define CCDC_REC656IF	(* (volatile unsigned short *)(CCDC_REGISTER_BASE + 0x3A ) )

#define CCDMODE_INTERLACED	0x0080	// Field mode interlaced CCD

#define SDRAM_MODE	(* (volatile unsigned short *)(SDRAMC_REGISTER_BASE + 0x026 ) )
#define SDRAM_REFCTL	(* (volatile unsigned short *)(SDRAMC_REGISTER_BASE + 0x028 ) )

#define SDMODE_RDLCYCL2	0x8000	// tRDL 2 cycle
#define SDMODE_RDLCYCL1	0x0000	// tRDL 1 cycle
#define SDMODE_SDBW16	0x4000	// SDRAM bus width 16 bits
#define SDMODE_SDBW32	0x0000	// SDRAM bus width 32 bits
#define SDMODE_4BANK	0x1000	// Bank selection 4
#define SDMODE_2BANK	0x0000	// Bank selection 2
#define SDMODE_LATCYCL3	0x0C00	// Cas lantency 3 cycle
#define SDMODE_LATCYCL2	0x0800	// Cas lantency 2 cycle
#define SDMODE_LATCYCL1	0x0400	// Cas lantency 1 cycle
#define SDMODE_M8Kx512	0x0300	// Memory 8k x 512 word
#define SDMODE_M4Kx512	0x0200	// Memory 4k x 512 word
#define SDMODE_M4Kx256	0x0100	// Memory 4k x 256 word
#define SDMODE_M2Kx256	0x0000	// Memory 2k x 256 word
#define SDMODE_DQMC	0x0080	// DQM mode
#define SDMODE_AUTOPDN	0x0040	// Automatic power down mode
#define SDMODE_CTLPDN	0x0020	// SDRAM control Power down mode
#define SDMODE_CTLSELFC	0x0010	// SDRAM control Refresh mode and power down cleared
#define SDMODE_CTLSELF	0x0008	// SDRAM control Self refreshing mode
#define SDMODE_CTLREF	0x0004	// SDRAM control Auto refreshing is issued
#define SDMODE_CTLPREA	0x0002	// SDRAM control Precharge all banks
#define SDMODE_CTLMSR	0x0001	// SDRAM control Set the mode
#define SDMODE_CTLNOP	0x0000	// SDRAM control No operation

#define REFCTL_REFENA	0x0100	// Auto refresh enable bit
#define REFCTL_CYCLE	0x0040	// Value x8 sdram clock

#define HPIB_CTRL	(* (volatile unsigned short *)(DSPC_REGISTER_BASE + 0x00 ) )
#define HPIB_STAT	(* (volatile unsigned short *)(DSPC_REGISTER_BASE + 0x02 ) )

#define HPIBST_INTREQ	0x01	// Interrupt status from DSP to HOST

#define USB_RST		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x60 ) )
#define USB_RSM		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x62 ) )
#define USB_INTMSK	(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x64 ) )
#define USB_CFG		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x66 ) )
#define USB_ST		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x68 ) )
#define USB_INTST	(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x6A ) )
#define USB_FRM		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x6C ) )
#define USB_ALT		(* (volatile unsigned short *)(USB_REGISTER_BASE + 0x6E ) )

#define MMC_CTL		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x00))
#define MMC_CLK		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x02))
#define MMC_ST0		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x04))
#define MMC_ST1		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x06))
#define MMC_IE		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x08))
#define MMC_TOR		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x0A))
#define MMC_TOD		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x0C))
#define MMC_BLEN	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x0E))
#define MMC_NBLK	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x10))
#define MMC_NBLC	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x12))
#define MMC_DRR		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x14))
#define MMC_DXR		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x16))
#define MMC_CMD		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x18))
#define MMC_ARGL	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x1A))
#define MMC_ARGH	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x1C))
#define MMC_RSP0	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x1E))
#define MMC_RSP1	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x20))
#define MMC_RSP2	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x22))
#define MMC_RSP3	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x24))
#define MMC_RSP4	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x26))
#define MMC_RSP5	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x28))
#define MMC_RSP6	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x2A))
#define MMC_RSP7	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x2C))
#define MMC_DRSP	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x2E))
#define MMC_ETOK	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x30))
#define MMC_CIDX	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x32))
#define MMC_CKC		(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x34))
#define MMC_TORC	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x36))
#define MMC_TODC	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x38))
#define MMC_BLNC	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x3A))
#define MMC_DMATRG	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x3C))
#define MMC_DMAMODE	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x3E))
#define MMC_DMAAD0	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x40))
#define MMC_DMAAD1	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x42))
#define MMC_DMASTAT0 	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x44))
#define MMC_DMASTAT1 	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x46))
#define MMC_DMATOR	(*(volatile unsigned short*)(SDMMC_REGISTER_BASE + 0x48))

#define MS_CMD		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x00))
#define MS_MODE		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x02))
#define MS_STAT		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x04))
#define MS_CTL		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x08))
#define MS_IDAT		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x0C))
#define MS_ICTL		(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x10))
#define MS_PPDATA 	(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x14))
#define MS_DRR	 	(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x20))
#define MS_DXR	 	(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x24))
#define MS_FIFOCTL 	(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x28))
#define MS_FIFOCNT 	(*(volatile unsigned short*)(MS_REGISTER_BASE + 0x2C))

#define USBRSM_CLKOFF	0x02	// internal clock off control
#endif // __DSC25DEF_H__

