/*
 * linux/include/asm-arm/arch-omap/mux.h
 *
 * Table of the Omap register configurations for the FUNC_MUX and
 * PULL_DWN combinations.
 *
 * Copyright (C) 2003 Nokia Corporation
 *
 * Written by Tony Lindgren <tony.lindgren@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * $Id: mux-h
 * $Revision: 1.0
 * $Date: 2003/03/25
 *
 */

/*
 *
 */
#ifndef __ASM_ARCH_MUX_H
#define __ASM_ARCH_MUX_H

#define BITS000	0
#define BITS001	(1 << 0)
#define BITS010	(1 << 1)
#define BITS100	(1 << 2)
#define BITS011	(3 << 0)

#define	NO_PULL_DWN	0
#define	USE_PULL_DWN	1

typedef struct {
	char *name;
	u_int busy;
	u_int debug;
	char *mux_reg_name;
	u_int mux_reg;
	u_int mask_offset;
	u_int mask;
	char *pull_dwn_name;
	u_int pull_dwn_reg;
	u_int pull_dwn_val;
	u_int pull_dwn_bit;
} reg_cfg_set;

/*
 * Lookup table for FUNC_MUX and PULL_DWN register combinations for each
 * device. See also reg_cfg_table below for the register values.
 */
typedef enum {
	/* UART1 (BT_UART_GATING)*/
	uart1_tx = 0,
	uart1_rts,

	/* UART2 (COM_UART_GATING)*/
	uart2_tx,
	uart2_rx,
	uart2_cts,
	uart2_rts,

	/* UART3 (GIGA_UART_GATING) */
	uart3_tx,
	uart3_rx,
	uart3_cts,
	uart3_rts,
	uart3_clkreq,

	/* USB master generic */
	usb_vbus,
	gpio0,
	usb_puen,
	usb_clko,

	/* USB1 master */
	usb1_susp,
	usb1_seo,
	usb1_txen,
	usb1_txd,
	usb1_vp,
	usb1_vm,
	usb1_rcv,
	usb1_speed,

	/* USB2 master */
	usb2_susp,
	usb2_vp,
	usb2_txen,
	usb2_vm,
	usb2_rcv,
	usb2_seo,
	usb2_txd,

        /* GPIO generic */
        gpio1,
        gpio2,
        gpio3,
        gpio4,
        gpio6,
        gpio7,
        gpio11,
        gpio12,
        gpio13,
        gpio14,
        gpio15,

        /* MPUIO */
        w5_mpuio5

} reg_cfg_t;

extern int omap_cfg_reg(reg_cfg_t reg_cfg);

#endif
