#ifndef _ASM_ARCH_OMAP_HWTIMER_H
#define _ASM_ARCH_OMAP_HWTIMER_H

#ifndef __instrument
#define __instrument
#define __noinstrument __attribute__ ((no_instrument_function))
#endif

extern void __noinstrument start_mputimer(int n, unsigned int ptv,  unsigned long load_val);

typedef struct {
	u32 cntl;     // CNTL_TIMER, R/W
	u32 load_tim; // LOAD_TIM,   W
	u32 read_tim; // READ_TIM,   R
} mputimer_regs_t;


#define mputimer_base(n) \
    ((volatile mputimer_regs_t*)(OMAP1510_MPUTIMER_BASE + \
                                 (n)*OMAP1510_MPUTIMER_OFF))


static inline unsigned long timer32k_read(int reg) {
        unsigned long val;
        val = (inw(IO_ADDRESS((reg) + OMAP1510_32kHz_TIMER_BASE)));
        return val;
}
static inline void timer32k_write(int reg,int val) {
        outw( (val), (IO_ADDRESS( (reg) + OMAP1510_32kHz_TIMER_BASE)));
}


/*
 * How long is the timer interval? 100 HZ, right...
 * IRQ rate = (TVR + 1) / 32768 seconds 
 * TVR = 32768 * IRQ_RATE -1
 * IRQ_RATE =  1/100
 * TVR = 326
 */
#define TIMER32k_PERIOD 326 
//#define TIMER32k_PERIOD 0x7ff

static inline void start_timer32k(void) {
	timer32k_write(TIMER32k_CR,
		       TIMER32k_TSS | TIMER32k_TRB |
		       TIMER32k_INT | TIMER32k_ARL); // start
}



static inline unsigned long __noinstrument
read_mputimer(int n)
{
	volatile mputimer_regs_t* timer = mputimer_base(n);
	return timer->read_tim;
}

static inline void __noinstrument stop_mputimer(int n)
{
	volatile mputimer_regs_t* timer = mputimer_base(n);
	timer->cntl &= ~1UL;
}

static inline void __noinstrument start_mputimer1(unsigned long load_val)
{
	start_mputimer(0, 0, load_val);
}
static inline void __noinstrument start_mputimer2(unsigned long load_val)
{
	start_mputimer(1, 0, load_val);
}
static inline void __noinstrument start_mputimer3(unsigned long load_val)
{
	start_mputimer(2, 0, load_val);
}

static inline void __noinstrument start_mputimer1_scaled(unsigned int ptv, unsigned long load_val)
{
	start_mputimer(0, ptv, load_val);
}
static inline void __noinstrument start_mputimer2_scaled(unsigned int ptv, unsigned long load_val)
{
	start_mputimer(1, ptv, load_val);
}
static inline void __noinstrument start_mputimer3_scaled(unsigned int ptv, unsigned long load_val)
{
	start_mputimer(2, ptv, load_val);
}

static inline unsigned long __noinstrument read_mputimer1(void)
{
	return read_mputimer(0);
}
static inline unsigned long __noinstrument read_mputimer2(void)
{
	return read_mputimer(1);
}
static inline unsigned long __noinstrument read_mputimer3(void)
{
	return read_mputimer(2);
}

#endif
