#ifndef _OMAP_GPIO_H
#define _OMAP_GPIO_H

#define GPIO_DIR_IN  1
#define GPIO_DIR_OUT 0
#define GPIO_IRQTRIGGER_FALLING 1
#define GPIO_IRQTRIGGER_RISING  0

static inline void omap_gpio_dir(unsigned int gpio, int inout)
{
        if (gpio > 15)
                return;

        if (inout == GPIO_DIR_OUT)
                outw(inw(GPIO_DIR_CONTROL_REG) & ~(1UL<<gpio), GPIO_DIR_CONTROL_REG);
        else
                outw(inw(GPIO_DIR_CONTROL_REG) |  (1UL<<gpio), GPIO_DIR_CONTROL_REG);
}

static inline int omap_gpio_get(unsigned int gpio)
{
        if (gpio > 15)
                return -1;

        return !!(inw(GPIO_DATA_INPUT_REG) & (1UL<<gpio));
}

static inline void omap_gpio_set(unsigned int gpio)
{
        if (gpio > 15)
                return;

        outw(inw(GPIO_DATA_OUTPUT_REG) |  (1UL<<gpio), GPIO_DATA_OUTPUT_REG);
}

static inline void omap_gpio_clr(unsigned int gpio)
{
        if (gpio > 15)
                return;

        outw(inw(GPIO_DATA_OUTPUT_REG) & ~(1UL<<gpio), GPIO_DATA_OUTPUT_REG);
}


static inline void omap_mpuio_dir(unsigned int gpio, int inout)
{
        if (gpio > 15)
                return;

        if (inout == GPIO_DIR_OUT)
                outw(inw(ARMIO_IO_CNTL) & ~(1UL<<gpio), ARMIO_IO_CNTL);
        else
                outw(inw(ARMIO_IO_CNTL) |  (1UL<<gpio), ARMIO_IO_CNTL);
}

static inline int omap_mpuio_get(unsigned int gpio)
{
        if (gpio > 15)
                return -1;

        return !!(inw(ARMIO_INPUT_LATCH) & (1UL<<gpio));
}

static inline void omap_mpuio_set(unsigned int gpio)
{
        if (gpio > 15)
                return;

        outw(inw(ARMIO_OUTPUT_REG) |  (1UL<<gpio), ARMIO_OUTPUT_REG);
}

static inline void omap_mpuio_clr(unsigned int gpio)
{
        if (gpio > 15)
                return;

        outw(inw(ARMIO_OUTPUT_REG) & ~(1UL<<gpio), ARMIO_OUTPUT_REG);
}

static inline void omap_mpuio_irq(unsigned int gpio, int edge)
{
        if (gpio > 15)
                return;

        if (edge == GPIO_IRQTRIGGER_FALLING)
                outw(inw(ARMIO_GPIO_INT_EDGE_REG) & ~(1UL<<gpio), ARMIO_GPIO_INT_EDGE_REG);
        else
                outw(inw(ARMIO_GPIO_INT_EDGE_REG) |  (1UL<<gpio), ARMIO_GPIO_INT_EDGE_REG);
}

#endif
