/*
 *  linux/include/asm-arm/arch-dm310/time.h
 *
 *  Copyright (C) 2002 Matthias Welwarsky
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __ASM_ARCH_TIME_H
#define __ASM_ARCH_TIME_H

extern unsigned long dm310_gettimeoffset(void);
extern void dm310_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs);

static inline void
setup_timer(void)
{
        /* FIXME: timer init was copied from uClinux/DSC21
	 *        make sure it is correct
	 */

	/* disable */
	outw(0, DM310_TIMER0_MODE);
	outw(0, DM310_TIMER1_MODE);
	outw(0, DM310_TIMER2_MODE);
	outw(0, DM310_TIMER3_MODE);

	/*
	 * System clock formula:
	 *         freq = clock / (div * scale)
	 * Where:
	 *         clock = 27MHz
	 *         div   = 27,000
	 *         scale = 10
	 *
	 * Which gives us 100Hz, as desired.
	 */

	/* 27MHz clock (not ARM clock) */
	outw(1, DM310_TIMER0_SEL);
	
	/* prescale 10 */
	outw(9, DM310_TIMER0_SCAL);
	
	/* div 27000 */
	outw(26999, DM310_TIMER0_DIV);
	
	/* periodic */
	outw(2, DM310_TIMER0_MODE);

	gettimeoffset = dm310_gettimeoffset;
	
	timer_irq.handler = dm310_timer_interrupt;
	timer_irq.flags = SA_INTERRUPT;
	setup_arm_irq(IRQ_TIMER, &timer_irq);
}

#endif
