/*
 * setup-dm310.c
 *
 * BRIEF MODULE DESCRIPTION
 *   This has additional initialiation needed by the DSC21.
 *
 * Copyright (C) 2001 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *          stevej@ridgerun.com
 *
 * Modified:
 *	- adapted to cover the DM310
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <asm/system.h>
#include <asm/arch/hardware.h>
#include <asm/io.h>
#include <asm/arch/gio.h>
#include <asm/arch/msic.h>

static void dm310_external_bus_init(void)
{
	/* reset */
	outw(0, DM310_EXTBUS_BUSRST);
	outw(1, DM310_EXTBUS_BUSRST);

	/* 
	 * write wait cycle = 5 * 21ns
	 * read wait cycle = 4 * 21ns 
	 * flash wait cycle = 10 * 21ns 
	 * type = 0 (CFC)
	 * mode = 0 (memory mapped) 
	 */
	outw(0x54a0, DM310_EXTBUS_BUSMD);
	
	/* initialize MSIC core modules */
	msic_init();
	
	/* disable 'flash ready' interrupt */
	outw(0x0, DM310_EXTBUS_BUSINTEN);

	/* configure GIO14/GIO15 to map A20/A21 */
	reg_write(DM310_GIO_GIOCNF2, 0x3000, 0x7000);
	reg_write(DM310_GIO_GIOCNF3, 0x0003, 0x0007);
}

static void dm310_wdt_init(void)
{
	clf();
	outw(1, DM310_FIQ_STATUS);
	outw(1, DM310_FIQ_ENABLE);
	stf();
	outw(999, DM310_WDT_SCAL);
	outw(26, DM310_WDT_DIV);
	outw(1, DM310_WDT_MODE);
	outw(1, DM310_WDT_RST);
	printk("WDT enabled\n");
}

void dm310_setup(void)
{
	dm310_external_bus_init();
// 	dm310_wdt_init();
}
