/*
 *  linux/include/asm-arm/arch-integrator/hardware.h
 *
 *  This file contains the hardware definitions of the Integrator.
 *
 *  Copyright (C) 1999 ARM Limited.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_HARDWARE_H
#define __ASM_ARCH_HARDWARE_H

#include <asm/sizes.h>
#include <asm/arch/platform.h>

/* 
 * define a base address for all I/O memory
 * NOTE:
 * The ARM does not really know about I/O access, every register is memory mapped
 * However, we remap the region where all the registers are to somewhere up above
 * the kernel segment.
 *
 */

#ifndef __ASSEMBLY__
#define DM310_IO_VOFFS         (0xE0000000UL)
#define DM310_IO_PADDR         (0x00030000UL)
#define DM310_IO_VADDR         (DM310_IO_VOFFS + DM310_IO_PADDR)
#define DM310_IO_SIZE          (0x00003000UL)
#else
#define DM310_IO_VOFFS         (0xE0000000)
#define DM310_IO_PADDR         (0x00030000)
#define DM310_IO_VADDR         (DM310_IO_VOFFS + DM310_IO_PADDR)
#define DM310_IO_SIZE          (0x00003000)
#endif


#define DM310_ETH_PADDR        (0x02200000UL)
#define DM310_ETH_VADDR        (DM310_IO_VOFFS + DM310_ETH_PADDR)
#define DM310_ETH_SIZE         (0x00100000UL)

#define DM310_EXTBUS_PADDR     (0x04000000UL)
#define DM310_EXTBUS_VADDR     (DM310_IO_VOFFS + DM310_EXTBUS_PADDR)
#define DM310_EXTBUS_SIZE      (0x00002000UL)

/* highest possible physical IO address */
#define IO_SPACE_LIMIT         (0xFFFFFFFFUL)

#endif
