/*
 * S3C2410 Power Management Sub Routines
 *
 * Coyright  (c) 2003 Samsung Electronics <hitchcar@sec.samsung.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License.
 */
#include <linux/types.h>
#include <asm/arch/s3c2410.h>

#define OFFSET_EINTPEND		0xAC
void CPUSaveRegs(u32 *p)
{	
	/* Save I/O Port */
	u32 i = VA_IO_PORT_BASE;
	for (i; i<VA_IO_PORT_BASE+OFFSET_EINTPEND; i += 4){
		*p++=  *((u32 *)i);
	}
	
	/* Save Interrupt */	
	*p++ = rINTMOD;
	*p++ = rINTMSK;
	*p++ = rINTSUBMSK;

	/* Save LCD  	*/
	*p++ = rLPCSEL;
	*p++ = rLCDINTMSK;
	*p++ = rTPAL;
	*p++ = rDITHMODE;
	*p++ = rBLUELUT;
	*p++ = rGREENLUT;
	*p++ = rREDLUT;
	*p++ = rLCDSADDR3;
	*p++ = rLCDSADDR2;
	*p++ = rLCDSADDR1;
	*p++ = rLCDCON5;
	*p++ = rLCDCON4;
	*p++ = rLCDCON3;
	*p++ = rLCDCON2;
	*p++ = rLCDCON1;
	
	/* Save Uart */
	*p++ = rUBRDIV0;
	*p++ = rULCON0;
	*p++ = rUFCON0;
	*p++ = rUMCON0;
	*p++ = rUCON0;
}


void CPULoadRegs(u32 *p)
{
	/* Restore  I/O Port */
	u32 i = VA_IO_PORT_BASE;
	for (i; i < VA_IO_PORT_BASE+OFFSET_EINTPEND; i += 4){
		*((u32 *)i) = *p++;
	}
	       
	/* Restore  Interrupt */	
	rINTMOD    =  *p++; 
	rINTMSK    =  *p++; 
	rINTSUBMSK =  *p++;

	/* Restore  LCD 	*/
	rLPCSEL    =  *p++; 
	rLCDINTMSK =  *p++; 
	rTPAL      =  *p++; 
	rDITHMODE  =  *p++; 
	rBLUELUT   =  *p++; 
	rGREENLUT  =  *p++; 
	rREDLUT    =  *p++; 
	rLCDSADDR3 =  *p++; 
	rLCDSADDR2 =  *p++; 
	rLCDSADDR1 =  *p++; 
	rLCDCON5   =  *p++; 
	rLCDCON4   =  *p++; 
	rLCDCON3   =  *p++; 
	rLCDCON2   =  *p++; 
	rLCDCON1   =  *p++;

	/* Restore Restore */
	rUBRDIV0 = *p++;
	rULCON0  = *p++;
	rUFCON0  = *p++;
	rUMCON0  = *p++;
	rUCON0   = *p++;
}


/* Purpose : To save power to the highest degree */
void ConfigStopGPIO(void)
{
	// Check point
	// 1) NC pin: input pull-up on 
	// 2) If input is driver externally: input pull-up off
	// 3) If a connected component draws some current: output low.
	// 4) If a connected component draws no current: output high.

	//chip # = 5

	//CAUTION:Follow the configuration order for setting the ports. 
	// 1) setting value(GPnDAT) 
	// 2) setting control register  (GPnCON)
	// 3) configure pull-up resistor(GPnUP)  

	//32bit data bus configuration  
	//*** PORT A GROUP
	//Ports  : GPA22 GPA21  GPA20 GPA19 GPA18 GPA17 GPA16 GPA15 GPA14 GPA13 GPA12  
	//Signal : nFCE nRSTOUT nFRE  nFWE  ALE   CLE   nGCS5 nGCS4 nGCS3 nGCS2 nGCS1 
	//Binary : 1     1      1,    1     1     1     1,    1     1     1     1,
	//POFF   : 1     0      1,    1     0     0     1,    1     1     1     1,
	//-------------------------------------------------------------------------------------------
	//Ports  : GPA11  GPA10  GPA9   GPA8   GPA7   GPA6   GPA5   GPA4   GPA3   GPA2   GPA1   GPA0
	//Signal : ADDR26 ADDR25 ADDR24 ADDR23 ADDR22 ADDR21 ADDR20 ADDR19 ADDR18 ADDR17 ADDR16 ADDR0 
	//Binary : 1      1      1      1,     1      1      1      1,     1      1      1      1         
	//POFF   : 0      0      0      0,     0      0      0      0,     0      0      0      0
	rGPACON = 0x7fffff; 

	//**** PORT B GROUP
	//Ports  : GPB10   GPB9    GPB8    GPB7    GPB6    GPB5     GPB4    GPB3   GPB2   GPB1       GPB0
	//Signal : nXDREQ0 nXDACK0 nXDREQ1 nXDACK1 nSS_KBD nDIS_OFF L3CLOCK L3DATA L3MODE nIrDATXDEN Keyboard
	//Setting: INPUT   OUTPUT  INPUT   OUTPUT  INPUT   OUT      OUT     OUT    OUT    INPUT      INPUT 
	//Binary : 00,     01      00,     01      00,     01       01,     01     01,    00         00  
	//PU_OFF :  0       1       0,      1      1(ext)  1(*)     1,      1      1      1(ext)     1(ext)           
	//*:nDIS_OFF:4.7K external pull-down resistor                                 
	rGPBDAT=  0x0|(1<<9)|(1<<7)|(0<<5)|(1<<4)|(1<<3)|(1<<2);
	rGPBCON = 0x044550;  
	rGPBUP  = 0x2ff;   //0x2fd->2ff, 3uA is reduced. Why? 

	//*** PORT C GROUP
	//Ports  : GPC15 GPC14 GPC13 GPC12 GPC11 GPC10 GPC9 GPC8 GPC7  GPC6   GPC5   GPC4 GPC3 GPC2  GPC1 GPC0
	//Signal : VD7   VD6   VD5   VD4   VD3   VD2   VD1  VD0 LCDVF2 LCDVF1 LCDVF0 VM VFRAME VLINE VCLK LEND  
	//Setting: IN    IN    IN    IN    IN    IN    IN   IN   OUT   OUT    OUT    IN   IN   IN    IN   IN
	//Binary : 00    00,   00    00,   00    00,   00   00,  01    01,    01     00,  00   00,   00   00
	//PU_OFF :  0     0     0     0,    0     0     0    0,   1     1      1      0,   0    0     0    0
	rGPCDAT = 0x0;
	rGPCCON = 0x00005400;  //0x00000000;	
	rGPCUP  = 0x00e0;      //0x0000;     
	//LCDVFn is connected the analog circuit in LCD. So, this signal should be output L.

	//*** PORT D GROUP
	//Ports  : GPD15 GPD14 GPD13 GPD12 GPD11 GPD10 GPD9 GPD8 GPD7 GPD6 GPD5 GPD4 GPD3 GPD2 GPD1 GPD0
	//Signal : VD23  VD22  VD21  VD20  VD19  VD18  VD17 VD16 VD15 VD14 VD13 VD12 VD11 VD10 VD9  VD8
	//Setting: IN    IN    IN    IN    IN    IN    IN   IN   IN   IN   IN   IN   IN   IN   IN   IN
	//Binary : 00    00,   00    00,   00    00,   00   00,  00   00,  00   00,  00   00,  00   00
	//PU_OFF :  0     0     0     0,    0     0     0    0,   0    0    0    0,   0    0    0    0
	rGPDDAT=  0x0;
	rGPDCON = 0x0;	
	rGPDUP  = 0x0;    

	//*** PORT E GROUP
	//Ports  : GPE15  GPE14  GPE13   GPE12    GPE11    GPE10   GPE9    GPE8    GPE7    GPE6  GPE5  GPE4  
	//Signal : IICSDA IICSCL SPICLK0 SPIMOSI0 SPIMISO0 SDDATA3 SDDATA2 SDDATA1 SDDATA0 SDCMD SDCLK I2SSDO 
	//Setting: IN     IN     IN      IN       IN       IN      IN      IN      IN      IN    IN    OUT
	//Binary : 00     00,    00      00,      00       00,     00      00,     00      00,   00    01,     
	//PU_OFF :  1-ext  1-ext  0       0,       0        0       0       0,      0       0     0     1,
	//------------------------------------------------------------------------------------------------
	//Ports  : GPE3   GPE2  GPE1    GPE0    
	//Signal : I2SSDI CDCLK I2SSCLK I2SLRCK     
	//Setting: IN     OUT   OUT     OUT
	//Binary : 00     01,   01      01
	//PU_OFF :  1-ext  1     1       1
	rGPEDAT = 0x0|(1<<4)|(1<<2)|(1<<1)|(1<<0);
	rGPECON = 0x00000115;	
	rGPEUP  = 0xc01f;     

	//*** PORT F GROUP
	//Ports  : GPF7   GPF6   GPF5   GPF4   GPF3        GPF2  GPF1   GPF0
	//Signal : nLED_8 nLED_4 nLED_2 nLED_1 nIRQ_PCMCIA EINT2 KBDINT EINT0
	//Setting: Output Output Output Output IN          IN    IN     EINT0
	//Binary : 01     01,    01     01,    00          00,   00     10
	//PU_OFF :  1      1      1      1,     0-ext       1-ext 1-ext  1-ext
	rGPFDAT = 0x0  |(0xf<<4);
	rGPFCON = 0x5502;
	rGPFUP  = 0xf7;   

	//*** PORT G GROUP
	//Ports  : GPG15 GPG14 GPG13 GPG12 GPG11  GPG10    GPG9     GPG8     GPG7      GPG6    
	//Signal : nYPON YMON  nXPON XMON  EINT19 DMAMODE1 DMAMODE0 DMASTART KBDSPICLK KBDSPIMOSI
	//Setting: OUT   OUT   OUT   OUT   OUT    OUT      OUT      OUT      OUT       OUT
	//Binary : 01    01,   01    01,   01-dbg 01,      01       01,      01        01
	//PU_OFF :  1     1     1     1,    1-ext  1        1        1,       1         1
	//---------------------------------------------------------------------------------------
	//Ports  : GPG5       GPG4      GPG3   GPG2    GPG1    GPG0    
	//Signal : KBDSPIMISO LCD_PWREN EINT11 nSS_SPI IRQ_LAN IRQ_PCMCIA
	//Setting: IN         IN        EINT11 IN      IN      IN
	//Binary : 00         00,       10     00,     00      00
	//PU_OFF :  0-ext      0,        1-ext  0       0       0
	rGPGDAT = 0x0 |(1<<11)|(1<<15)|(1<<14)|(1<<13)|(1<<12)|(1<<9)|(1<<8)|(1<<7)|(1<<6) ;
	rGPGCON = 0x55455080;   //GPG11=OUT  //for debug
	rGPGUP  = 0xfbc8;    

	//*** PORT H GROUP
	//Ports  : GPH10   GPH9    GPH8 GPH7  GPH6  GPH5 GPH4 GPH3 GPH2 GPH1  GPH0 
	//Signal : CLKOUT1 CLKOUT0 UCLK nCTS1 nRTS1 RXD1 TXD1 RXD0 TXD0 nRTS0 nCTS0
	//Setting: IN      IN      IN   IN    IN    IN   OUT  RXD0 TXD0 OUT   IN
	//Binary : 00,     00      00,  00    00,   00   01,  10   10,  01    00
	//PU_OFF :  0       0       0,   1-ext 1-ext 1-ext 1, 1-ext 1    1     1-ext

#if 1
	rGPHDAT = 0x0|(1<<6)|(1<<1)|(1<<4);    
	rGPHCON = 0x0001a4; 		   //0x0011a4->0x0001a4 reduces 12uA why -> MAX3232C may sink 12uA.
#else
	//rGPHDAT = 0x0|(1<<6)|(1<<1)|(1<<4);  
	//rGPHCON = 0x0011a4; 
	rGPHDAT = 0x0|(0<<6)|(1<<1)|(1<<4);  //(1<<6)->(0<<6) reduces 12uA (MAX3232C may sink 12uA.)
	rGPHCON = 0x0011a4; 
#endif    
	rGPHUP  = 0x0ff;    // The pull up function is disabled GPH[10:0]

	//External interrupt will be falling edge triggered. 
	rEXTINT0 = 0x22222222;    // EINT[7:0]
	rEXTINT1 = 0x22222222;    // EINT[15:8]
	rEXTINT2 = 0x22222222;    // EINT[23:16]
}


void ConfigMiscReg(void)
{
	rRTCCON=0x0;   // R/W disable, 1/32768, Normal(merge), No reset
	rADCCON|=(1<<2);		// ADC StanbyMode

	rMISCCR|=(1<<12); //USB port0 = suspend
	rMISCCR|=(1<<13); //USB port1 = suspend

	rMISCCR|=(1<<2); //Previous state at STOP(?) mode (???)

	//D[31:0] pull-up off. The data bus will not be float by the external bus holder.
	//If the pull-up resitsers are turned on,
	//there will be the leakage current through the pull-up resister
	rMISCCR=rMISCCR|(3<<0); 
}


void CPULCDOff(void)
{
	rGPGDAT &= ~(1 << 4);
	rLCDCON1   = 0;
	rLCDCON2   = 0;
	rLCDCON3   = 0;
	rLCDCON4   = 0;
	rLCDCON5   = 0;	
	rLCDSADDR1 = 0;
	rLCDSADDR2 = 0;
	rLCDSADDR3 = 0;
	rLPCSEL    = 0;
	rTPAL      = 0;
}


void CPUClearCS8900(void)
{
	u16 temp;
	do 
	{
		temp = *((volatile u16 *)((VA_CS8900A_BASE+0x0300) + 8));
	} while (temp != 0);
}


void clear_interrupt(void)
{
	rEINTPND  = rEINTPND;
	rLCDSRCPND = rLCDSRCPND;
	rLCDINTPND = rLCDINTPND;
	rSUBSRCPND = rSUBSRCPND;
	rSRCPND    = rSRCPND;
	rINTPND    = rINTPND;
}

