/* ----------------------------------------------------------------- CS
 * ASCII to EBCDIC and vice-versa code conversion tables.
 * Tables included here are based on ASCII conforming to the ISO8859-1
 * Latin 1 character set and EBCDIC conforming to the IBM Code Page 37
 * Latin 1 character set (except for three pairs of characters in 037).
 * This header file is included by AECS.C and others.
 */
 
#ifndef AECS_HEADER
#define AECS_HEADER 1
 
/* ASCII ---> EBCDIC */
 
static unsigned char ebc8859[256] = {
	 0x00, 0x01, 0x02, 0x03,  0x37, 0x2D, 0x2E, 0x2F,   /* 00 */
         0x16, 0x05, 0x25, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F,
         0x10, 0x11, 0x12, 0x13,  0x3C, 0x3D, 0x32, 0x26,
         0x18, 0x19, 0x3F, 0x27,  0x1C, 0x1D, 0x1E, 0x1F,
         0x40, 0x5A, 0x7F, 0x7B,  0x5B, 0x6C, 0x50, 0x7D,   /* 20 */
         0x4D, 0x5D, 0x5C, 0x4E,  0x6B, 0x60, 0x4B, 0x61,
         0xF0, 0xF1, 0xF2, 0xF3,  0xF4, 0xF5, 0xF6, 0xF7,
         0xF8, 0xF9, 0x7A, 0x5E,  0x4C, 0x7E, 0x6E, 0x6F,
         0x7C, 0xC1, 0xC2, 0xC3,  0xC4, 0xC5, 0xC6, 0xC7,   /* 40 */
         0xC8, 0xC9, 0xD1, 0xD2,  0xD3, 0xD4, 0xD5, 0xD6,
         0xD7, 0xD8, 0xD9, 0xE2,  0xE3, 0xE4, 0xE5, 0xE6,
         0xE7, 0xE8, 0xE9, 0xAD,  0xE0, 0xBD, 0x5F, 0x6D,
         0x79, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,   /* 60 */
         0x88, 0x89, 0x91, 0x92,  0x93, 0x94, 0x95, 0x96,
         0x97, 0x98, 0x99, 0xA2,  0xA3, 0xA4, 0xA5, 0xA6,
         0xA7, 0xA8, 0xA9, 0xC0,  0x4F, 0xD0, 0xA1, 0x07,
         0x20, 0x21, 0x22, 0x23,  0x24, 0x15, 0x06, 0x17,   /* 80 */
         0x28, 0x29, 0x2A, 0x2B,  0x2C, 0x09, 0x0A, 0x1B,
         0x30, 0x31, 0x1A, 0x33,  0x34, 0x35, 0x36, 0x08,
         0x38, 0x39, 0x3A, 0x3B,  0x04, 0x14, 0x3E, 0xFF,
         0x41, 0xAA, 0x4A, 0xB1,  0x9F, 0xB2, 0x6A, 0xB5,   /* a0 */
         0xBB, 0xB4, 0x9A, 0x8A,  0xB0, 0xCA, 0xAF, 0xBC,
         0x90, 0x8F, 0xEA, 0xFA,  0xBE, 0xA0, 0xB6, 0xB3,
         0x9D, 0xDA, 0x9B, 0x8B,  0xB7, 0xB8, 0xB9, 0xAB,
         0x64, 0x65, 0x62, 0x66,  0x63, 0x67, 0x9E, 0x68,   /* c0 */
         0x74, 0x71, 0x72, 0x73,  0x78, 0x75, 0x76, 0x77,
         0xAC, 0x69, 0xED, 0xEE,  0xEB, 0xEF, 0xEC, 0xBF,
         0x80, 0xFD, 0xFE, 0xFB,  0xFC, 0xBA, 0xAE, 0x59,
         0x44, 0x45, 0x42, 0x46,  0x43, 0x47, 0x9C, 0x48,   /* e0 */
         0x54, 0x51, 0x52, 0x53,  0x58, 0x55, 0x56, 0x57,
         0x8C, 0x49, 0xCD, 0xCE,  0xCB, 0xCF, 0xCC, 0xE1,
         0x70, 0xDD, 0xDE, 0xDB,  0xDC, 0x8D, 0x8E, 0xDF};
 
/* EBCDIC ---> ASCII */
 
static unsigned char asc8859[256] = {
	 0x00, 0x01, 0x02, 0x03,  0x9C, 0x09, 0x86, 0x7F,   /* 00 */
         0x97, 0x8D, 0x8E, 0x0B,  0x0C, 0x0D, 0x0E, 0x0F,
         0x10, 0x11, 0x12, 0x13,  0x9D, 0x85, 0x08, 0x87,
         0x18, 0x19, 0x92, 0x8F,  0x1C, 0x1D, 0x1E, 0x1F,
         0x80, 0x81, 0x82, 0x83,  0x84, 0x0A, 0x17, 0x1B,   /* 20 */
         0x88, 0x89, 0x8A, 0x8B,  0x8C, 0x05, 0x06, 0x07,
         0x90, 0x91, 0x16, 0x93,  0x94, 0x95, 0x96, 0x04,
         0x98, 0x99, 0x9A, 0x9B,  0x14, 0x15, 0x9E, 0x1A,
         0x20, 0xA0, 0xE2, 0xE4,  0xE0, 0xE1, 0xE3, 0xE5,   /* 40 */
         0xE7, 0xF1, 0xA2, 0x2E,  0x3C, 0x28, 0x2B, 0x7C,
         0x26, 0xE9, 0xEA, 0xEB,  0xE8, 0xED, 0xEE, 0xEF,
         0xEC, 0xDF, 0x21, 0x24,  0x2A, 0x29, 0x3B, 0x5E,
         0x2D, 0x2F, 0xC2, 0xC4,  0xC0, 0xC1, 0xC3, 0xC5,   /* 60 */
         0xC7, 0xD1, 0xA6, 0x2C,  0x25, 0x5F, 0x3E, 0x3F,
         0xF8, 0xC9, 0xCA, 0xCB,  0xC8, 0xCD, 0xCE, 0xCF,
         0xCC, 0x60, 0x3A, 0x23,  0x40, 0x27, 0x3D, 0x22,
         0xD8, 0x61, 0x62, 0x63,  0x64, 0x65, 0x66, 0x67,   /* 80 */
         0x68, 0x69, 0xAB, 0xBB,  0xF0, 0xFD, 0xFE, 0xB1,
         0xB0, 0x6A, 0x6B, 0x6C,  0x6D, 0x6E, 0x6F, 0x70,
         0x71, 0x72, 0xAA, 0xBA,  0xE6, 0xB8, 0xC6, 0xA4,
         0xB5, 0x7E, 0x73, 0x74,  0x75, 0x76, 0x77, 0x78,   /* a0 */
         0x79, 0x7A, 0xA1, 0xBF,  0xD0, 0x5B, 0xDE, 0xAE,
         0xAC, 0xA3, 0xA5, 0xB7,  0xA9, 0xA7, 0xB6, 0xBC,
         0xBD, 0xBE, 0xDD, 0xA8,  0xAF, 0x5D, 0xB4, 0xD7,
         0x7B, 0x41, 0x42, 0x43,  0x44, 0x45, 0x46, 0x47,   /* c0 */
         0x48, 0x49, 0xAD, 0xF4,  0xF6, 0xF2, 0xF3, 0xF5,
         0x7D, 0x4A, 0x4B, 0x4C,  0x4D, 0x4E, 0x4F, 0x50,
         0x51, 0x52, 0xB9, 0xFB,  0xFC, 0xF9, 0xFA, 0xFF,
         0x5C, 0xF7, 0x53, 0x54,  0x55, 0x56, 0x57, 0x58,   /* e0 */
         0x59, 0x5A, 0xB2, 0xD4,  0xD6, 0xD2, 0xD3, 0xD5,
         0x30, 0x31, 0x32, 0x33,  0x34, 0x35, 0x36, 0x37,
         0x38, 0x39, 0xB3, 0xDB,  0xDC, 0xD9, 0xDA, 0x9F};
 
#define chratoem(c) ebc8859[(int)c] 
#define chretoam(c) asc8859[(int)c] 
 
#endif
