/*
 *  linux/arch/arm/mach-s3c2410/mm.c
 *
 *  Copyright (C) 2002 SAMSUNG ELECTRONICS 
 *                   SW.LEE (hitchcar@sec.samsung.com)
 *  in s3c2400 this file name is generic.c
 *  but s3c2410 calls this file mm.c 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/page.h>
 
#include <asm/mach/map.h>

 
static struct map_desc standard_io_desc[] __initdata = {
	/* virtual        physical          length  domain     r w c b */
	{ VA_MEM_CTR_BASE,PA_MEM_CTR_BASE   ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_USB_BASE    ,PA_USB_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_INT_BASE    ,PA_INT_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_DMA_BASE    ,PA_DMA_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_CKPO_BASE   ,PA_CKPO_BASE      ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_LCD_BASE    ,PA_LCD_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_NAND_BASE   ,PA_NAND_BASE      ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_UART_BASE   ,PA_UART_BASE      ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_TIMER_BASE  ,PA_TIMER_BASE     ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_UD_BASE     ,PA_UD_BASE        ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_WD_BASE     ,PA_WD_BASE        ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_IIC_BASE    ,PA_IIC_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_IIS_BASE    ,PA_IIS_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
	{ VA_IO_PORT_BASE,PA_IO_PORT_BASE   ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
 	{ VA_RTC_BASE    ,PA_RTC_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
 	{ VA_ADC_BASE    ,PA_ADC_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
 	{ VA_SPI_BASE    ,PA_SPI_BASE       ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
 	{ VA_SD_BASE     ,PA_SD_BASE        ,SZ_1M ,DOMAIN_IO, 0,1,0,0},
 	{ VA_CS8900A_BASE,PA_CS8900A_BASE  ,SZ_32M ,DOMAIN_IO, 0,1,0,0},
	LAST_DESC
};


extern void __init HWs3c2410_map_io(void)
{
  iotable_init(standard_io_desc);
}
