/* include/asm-sh/sq.h
 *
 * Definitions for SH4 Store Queue support.
 *
 * Copyright (c) 2001 M. R. Brown <mrbrown@0xd6.org>
 * Copyright (c) 2001 Paul Mundt  <lethal@chaoticdreams.org>
 *
 * Released under the terms of the GNU GPL v2.0.
 *
 */
#ifndef _ASM_SH_SQ_H
#define _ASM_SH_SQ_H

#include <linux/kernel.h>

/* 
 * Store queues range from e0000000-e3ffffffc, allowing approx. 64MB to be
 * mapped to any physical address space.  Since data is written (and aligned)
 * to 32-byte boundaries, we need to be sure that all allocations are aligned.
 */
#define SQ_SIZE			32
#define SQ_ALIGN_MASK		(~(SQ_SIZE - 1))
#define SQ_ALIGN(addr)		(((addr)+SQ_SIZE-1) & SQ_ALIGN_MASK)

#define SQ_ADDRBASE		0xe0000000
#define SQ_ADDRMAX		0xe4000000

/* Specify a area of the store queue that can be "allocated" (mapped). */
struct sq_area {
	void *addr;
	unsigned long size;
};

/* Init/cleanup routines (allocation/freeing of zone) */
int sq_init(void);
void sq_exit(void);

/* Map an address into an available store queue. */
void *sq_ioremap(unsigned long phys_addr, unsigned long size);

/* Unmap the specified store queue address. */
void sq_iounmap(void *addr);

/* Flush (prefetch) the store queue cache at the specified address. */
void sq_flush(void *addr);

/* Copy the buffer to the store queue cache (32 bytes at a time), and flush
   each line. */
void sq_write(void *addr, void *buffer, unsigned long size);

#endif /* _ASM_SH_SQ_H */

