/*
 * drivers/char/drm/pvr2_drv.c
 *
 * NEC PowerVR 2 DRM driver.
 *
 * Copyright (C) 2001 Paul Mundt <lethal@chaoticdreams.org>
 *
 * Released under the terms of the GNU GPL v2.0.
 *
 */
#include <linux/config.h>
#include "drmP.h"
#include "pvr2.h"

#define DRIVER_AUTHOR		"Paul Mundt"
#define DRIVER_NAME		"pvr2"
#define DRIVER_DESC		"NEC PowerVR2"
#define DRIVER_DATE		"20010914"

#define DRIVER_MAJOR		1
#define DRIVER_MINOR		0
#define DRIVER_PATCHLEVEL	0

#define DRIVER_IOCTLS

#include "drm_auth.h"
#include "drm_bufs.h"
#include "drm_context.h"
#include "drm_dma.h"
#include "drm_drawable.h"
#include "drm_drv.h"

#ifndef MODULE
static int __init pvr2_options(char *str)
{
	DRM(parse_options)(str);
	return 1;
}

__setup(DRIVER_NAME "=", pvr2_options);
#endif

#include "drm_fops.h"
#include "drm_init.h"
#include "drm_ioctl.h"
#include "drm_lists.h"
#include "drm_lock.h"
#include "drm_memory.h"
#include "drm_proc.h"
#include "drm_vm.h"
#include "drm_stub.h"

