/*
 * linux/include/asm-arm/arch-lh79520/serial.h
 *
 * Copyright (c) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __ASM_ARCH_SERIAL_H
#define __ASM_ARCH_SERIAL_H

/*
 * This assumes you have a 14.7456 MHz clock for your UART.
 */
#define BASE_BAUD	(14745600 / 16)

/*
 * Standard COM flags
 */
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST)

#define RS_TABLE_SIZE 2

#define STD_SERIAL_PORT_DEFNS		\
	/* MAGIC UART CLK   PORT       IRQ     FLAGS */			\
	{ 0, BASE_BAUD, UART0_BASE, IRQ_UART0, STD_COM_FLAGS },  /* ttyAM0 */ \
	{ 0, BASE_BAUD, UART1_BASE, IRQ_UART1, STD_COM_FLAGS },  /* ttyAM0 */ \
	{ 0, BASE_BAUD, UART2_BASE, IRQ_UART2, STD_COM_FLAGS },  /* ttyAM1 */ \

#define EXTRA_SERIAL_PORT_DEFNS

#endif
