/*
 *  linux/include/asm-arm/arch-lh79520/rcpc.h
 *
 *  Copyright (C) 2001 Sharp Microelectronics of the Americas, Inc.
 *		Camas, WA
 *  Portions Copyright (C) 2002 Lineo, Inc.
 *
 * DDD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

 
#ifndef RCPC_H
#define RCPC_H

/*
 * RCPC: Reset, Clock, and Power Controller Register Structure
 */ 
typedef __attribute((packed)) struct {
    u32	control;		/* control register */ 
    u32	id;			/* identification */ 
    u32	remap;			/* Remap Control */ 
    u32	softReset;		/* Soft Reset */ 
    u32	resetStatus;		/* Reset Status */ 
    u32	resetStatusclr;		/* Reset Status Clear */ 
    u32	HCLKPrescale;		/* HCLK Prescaler */ 
    u32	CpuClkPrescale;		/* ARM Core Clk Prescaler */ 
    u32	PCLKPrescale;		/* PCLK Prescaler */ 
    u32	periphClkCtrl;		/* Peripheral Clock Ctrl */ 
    u32	spareClkCtrl;		/* Spare Clock Ctrl */ 
    u32	AHBClkCtrl;		/* AHB Clock Ctrl */ 
    u32	periphClkSel;		/* Peripheral Clock Select*/
    u32	spareClkSel;		/* Spare Clock Select */
    u32	PWM0Prescale;		/* PWM 0 Prescaler*/
    u32	PWM1Prescale;		/* PWM 1 Prescaler*/
    u32	spare0Prescale;		/* Spare clock 0 Prescaler*/
    u32	spare1Prescale;		/* Spare clock 1 Prescaler*/
    u32	spare2Prescale;		/* Spare clock 2 Prescaler*/
    u32	spare3Prescale;		/* Spare clock 3 Prescaler*/
    u32	spare4Prescale;		/* Spare clock 4 Prescaler*/
    u32	spare5Prescale;		/* Spare clock 5 Prescaler*/
    u32	spare6Prescale;		/* Spare clock 6 Prescaler*/
    u32	spare7Prescale;		/* Spare clock 7 Prescaler*/
    u32	spare8Prescale;		/* Spare clock 8 Prescaler*/
    u32	spare9Prescale;		/* Spare clock 9 Prescaler*/
    u32	spare10Prescale;	/* Spare clck 10 Prescaler*/
    u32	spare11Prescale;	/* Spare clck 11 Prescaler*/
    u32	spare12Prescale;	/* Spare clck 12 Prescaler*/
    u32	spare13Prescale;	/* Spare clck 13 Prescaler*/
    u32	spare14Prescale;	/* Spare clck 14 Prescaler*/
    u32	spare15Prescale;	/* Spare clck 15 Prescaler*/
    u32	intConfig;		/* Ext. Interrupt Config */
    u32	intClear;		/* Ext. Interrupt Clear  */
    u32	coreClkConfig;		/* ARM Core Clock Config */
} rcpcRegs_t;


/*
 * RCPC Bit Fields
 */ 

/*
 * control Register Bit Fields
 */ 
#define RCPC_CTRL_EP			_BIT(0)	/* Enable PLL */ 
#define RCPC_CTRL_EX			_BIT(1)	/* Enable Internal XTAL */ 

#define RCPC_CTRL_PWRDWNSEL(n)		_SBF(2,(n)) /* Power Down Mode Sel*/ 
/* Mode Arguments to RCPC_CTRL_PWRDWNSEL(n) */ 
#define PWRDWNSEL_ACTIVE		0
#define PWRDWNSEL_STANDBY		1
#define PWRDWNSEL_SLEEP			2
#define PWRDWNSEL_STOP1			3
#define PWRDWNSEL_STOP2			4

#define RCPC_CTRL_OUTSEL(n)		_SBF(5,(n))
/* Arguments to RCPC_CTRL_OUTSEL(n) */ 
#define OUTSEL_CLK_INTOSC		0
#define OUTSEL_CLK_PLL			1
#define OUTSEL_FCLK_CPU			2
#define OUTSEL_HCLK			3

#define RCPC_CTRL_CLKSEL_PLL		_SBF(7,0)
#define RCPC_CTRL_CLKSEL_EXT		_SBF(7,1)

#define RCPC_CTRL_WRTLOCK_LOCKED	_SBF(9,0)
#define RCPC_CTRL_WRTLOCK_ENABLED	_SBF(9,1)

/**********************************************************************
 * identification - Identification Register Bit Fields
 *********************************************************************/ 
#define RCPC_ID_DEFAULT			(0x5200)

/**********************************************************************
 * remap - Remap Control Register Bit Fields
 *********************************************************************/ 
#define RCPC_REMAP_SMEM0		(0)
#define RCPC_REMAP_SDMEM0		(1)
#define RCPC_REMAP_IMEM0		(2)

/**********************************************************************
 * softreset - Soft Reset Register Bit Fields
 *********************************************************************/ 
#define RCPC_SOFTRESET_ALL		(0xDEAD)
#define RCPC_SOFTRESET_GBL		(0xDEAC)

/**********************************************************************
 * resetstatus, resetstatusclr - Reset Status Register Bit Fields
 *********************************************************************/ 
#define RCPC_RESET_STATUS_EXT		_BIT(0)
#define RCPC_RESET_STATUS_WDTO		_BIT(1)

/**********************************************************************
 * hclkPrescale - HCLK Prescaler Register Bit Fields
 * cpuclkPrescale - ARM Core Clock Prescaler Register Bit Fields
 * pclkPrescale - PCLK Prescaler Register Bit Fields
 * pwm0Prescale - PWM0 Prescaler Register Bit Fields
 * pwm1Prescale - PWM1 Prescaler Register Bit Fields
 * sparePrescale - Spare Prescaler Register Bit Fields
 * Note: not all constants are applicable to all registers.
 * 	See Reference.
 *********************************************************************/ 
#define RCPC_PRESCALER_DIV1		_SBF(0,0)
#define RCPC_PRESCALER_DIV2		_SBF(0,1)
#define RCPC_PRESCALER_DIV4		_SBF(0,2)
#define RCPC_PRESCALER_DIV6		_SBF(0,3)
#define RCPC_PRESCALER_DIV8		_SBF(0,4)
#define RCPC_PRESCALER_DIV16		_SBF(0,8)
#define RCPC_PRESCALER_DIV30		_SBF(0,15)
#define RCPC_PRESCALER_DIV32		_SBF(0,16)
#define RCPC_PRESCALER_DIV64		_SBF(0,32)
#define RCPC_PRESCALER_DIV128		_SBF(0,64)
#define RCPC_PRESCALER_DIV256		_SBF(0,128)
#define RCPC_PRESCALER_DIV65534		(0xFFFF)

/**********************************************************************
 * periphclkctrl - Peripheral Clock Control Register Bit Fields
 * spareclkctrl - Spare Clock Control Register Bit Fields
 * ahbclkctrl - AHB Clock Control Register Bit Fields
 * Writing a "0" to a bit in these registers enables the
 * 	corresponding clock
 *********************************************************************/ 
#define RCPC_CLKCTRL_U0_DISABLE		_BIT(0)
#define RCPC_CLKCTRL_U1_DISABLE		_BIT(1)
#define RCPC_CLKCTRL_U2_DISABLE		_BIT(2)
#define RCPC_CLKCTRL_CT0_DISABLE	_BIT(3)
#define RCPC_CLKCTRL_CT1_DISABLE	_BIT(4)
#define RCPC_CLKCTRL_CT2_DISABLE	_BIT(5)
#define RCPC_CLKCTRL_CT3_DISABLE	_BIT(6)
#define RCPC_CLKCTRL_PWM0_DISABLE	_BIT(7)
#define RCPC_CLKCTRL_PWM1_DISABLE	_BIT(8)
#define RCPC_CLKCTRL_RTC_DISABLE	_BIT(9)
#define RCPC_CLKCTRL_SPARE_DISABLE(f)	_BIT(f)

#define RCPC_SPARE_CLKCTRL_SSPCLK_DISABLE	_BIT(1)
#define RCPC_SPARE_CLKCTRL_LCDCLK_DISABLE	_BIT(0)

#define RCPC_CLKCTRL_DMAC_DISABLE	_BIT(0)
#define RCPC_CLKCTRL_HCLKSP0_DISABLE	_BIT(1)

/**********************************************************************
 * periphclksel - Peripheral Clock Select Register Bit Fields
 * Writing a "0" to U0-U2 in this register enables the
 * 	XTAL Oscillator as the clock source
 * Writing a "0" to CT0-CT3 in this register enables the
 * 	HCLK as the clock source
 *********************************************************************/ 
#define RCPC_PCLKSEL_U0_EXT		_BIT(0)	/* U0 Clock Source */ 
#define RCPC_PCLKSEL_U1_EXT		_BIT(1)	/* U1 Clock Source */ 
#define RCPC_PCLKSEL_U2_EXT		_BIT(2)	/* U2 Clock Source */ 
#define RCPC_PCLKSEL_CT0_EXT		_BIT(3)	/* CT0 Clock Source */ 
#define RCPC_PCLKSEL_CT1_EXT		_BIT(4)	/* CT1 Clock Source */ 
#define RCPC_PCLKSEL_CT2_EXT		_BIT(5)	/* CT2 Clock Source */ 
#define RCPC_PCLKSEL_CT3_EXT		_BIT(6)	/* CT3 Clock Source */ 
#define RCPC_PCLKSEL_RTC_32		0	/* RTC Clock Source 32KHz */ 
#define RCPC_PCLKSEL_RTC_EXT		_SBF(7,2) /* RTC Clock Source Ext */

/**********************************************************************
 * spareclksel - Peripheral Clock Select Register Bit Fields
 * Writing a "0" to a bit in this register enables the
 * 	HCLK as the clock source
 *********************************************************************/ 
#define RCPC_SCLKSEL_SP(n)		_SBF((n),1) /* SP2 - SP15 */ 
#define RCPC_SCLKSEL_SSPCLK		_BIT(1)     /* SSP Clock External */ 
#define RCPC_SCLKSEL_LCDCLK		_BIT(0)     /* LCD Clock External */ 

/**********************************************************************
 * intconfig - External Interrupt Configuration Register Bit Fields
 *********************************************************************/ 
#define RCPC_INTCONFIG(f,v)		_SBF((f),(v))
/* RCPC_INTCONFIG arguments for 'f' parameter */ 
#define RCPC_INT0			0
#define RCPC_INT1			2
#define RCPC_INT2			4
#define RCPC_INT3			6
#define RCPC_INT4			8
#define RCPC_INT5			10
#define RCPC_INT6			12
#define RCPC_INT7			14
/* RCPC_INTCONFIG arguments for 'v' parameter */ 
#define RCPC_INT_LLT			0	/* Low Level Trigger */ 
#define RCPC_INT_HLT			1	/* High Level Trigger */ 
#define RCPC_INT_FET			2	/* Falling Edge Trigger */ 
#define RCPC_INT_RET			3	/* Rising Edge Trigger */ 

/**********************************************************************
 * intclear - External Interrupt Clear Register Bit Fields
 *********************************************************************/ 
#define RCPC_INTCLEAR(n)		_BIT(n)	/* Clear Edge Interrupt 'n' */ 

/**********************************************************************
 * coreclkconfig - Core Clock Configuration Register Bit Fields
 *********************************************************************/ 
#define RCPC_CCC_STDASYNCH		0 /* Standard Mode, Asynch operation */
#define RCPC_CCC_FASTBUS		1 /* Fast Bus Extension Mode */
#define RCPC_CCC_STDSYNCH		2 /* Standard Mode, Synch operation */

#endif // RCPC_H
