/*
 *  linux/include/asm-arm/arch-lh79520/iocon.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *	COPYRIGHT (C) 2001 SHARP MICROELECTRONICS OF THE AMERICAS, INC.
 *		CAMAS, WA
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	Description:
 *      This file contains the structure definitions and manifest
 *      constants for ARM IP component:
 *      	I/O Configuration Block 
 *
 *	References:
 *		(1) Sharp LH79520 Universal Microcontroller User's Guide,
 *		Version 1.x, Sharp Microelectronics of the Americas, Inc.
 *		(2) ARM Isis Technical Reference Manual, System on Chip Group,
 *		ARM SC063-TRM-0001-B
 *
 *********************************************************************/

#ifndef LH79520_IOCON_H
#define LH79520_IOCON_H

#if 0
#ifndef _BIT
#define _BIT(n)	(1 << (n))
#endif

#ifndef _SBF
#define _SBF(f,v) ((v) << (f))
#endif
#endif // 0

/*
 * IO Configuration Block Structure
 */ 
typedef struct {
	volatile unsigned int	MemMux;
	volatile unsigned int	LCDMux;
	volatile unsigned int	MiscMux;
	volatile unsigned int	DMAMux;
	volatile unsigned int	UARTMux;
	volatile unsigned int	SSIMux;
	volatile unsigned int	Scratchreg;
} ioconRegs_t;

/*
 * Memory Multiplexing IOCON Register Bit Field constants
 */ 
#define MEMMUX_PIOE_NOMUX		_SBF(0,0)
#define MEMMUX_MIDQM32			_SBF(0,1)
#define MEMMUX_MIDQM30			_SBF(0,3)
#define MEMMUX_PIOE4			_SBF(2,0)
#define MEMMUX_MINWE			_SBF(2,1)
#define MEMMUX_PIOE5			_SBF(3,0)
#define MEMMUX_MISDNCS0			_SBF(3,1)
#define MEMMUX_PIOE6			_SBF(4,0)
#define MEMMUX_MISDNCS1			_SBF(4,1)
#define MEMMUX_PIOE7			_SBF(5,0)
#define MEMMUX_MICKE			_SBF(5,1)
#define MEMMUX_PIOF0			_SBF(6,0)
#define MEMMUX_MICLKIO			_SBF(6,1)
#define MEMMUX_PIO_X			_SBF(7,0)
#define MEMMUX_MIDATA_X			_SBF(7,1)
#define MEMMUX_PIOH2			_SBF(8,0)
#define MEMMUX_MICSN3			_SBF(8,1)
#define MEMMUX_PIOH3			_SBF(9,0)
#define MEMMUX_MICSN4			_SBF(9,1)
#define MEMMUX_PIOH4			_SBF(10,0)
#define MEMMUX_MICSN5			_SBF(10,1)
#define MEMMUX_PIOH5			_SBF(11,0)
#define MEMMUX_MICSN6			_SBF(11,1)
#define MEMMUX_PIOH6			_SBF(12,0)
#define MEMMUX_MIBLSN2			_SBF(12,1)
#define MEMMUX_PIOH7			_SBF(13,0)
#define MEMMUX_MIBLSN3			_SBF(13,1)

/*
 * LCD Multiplexing IOCON Register Bit Field constants
 */ 
#define LCDMUX_PIOB4			_SBF(0,0)
#define LCDMUX_CLD12			_SBF(0,1)
#define LCDMUX_CLREV			_SBF(0,2)
#define LCDMUX_PIOB5            _SBF(2,0)
#define LCDMUX_CLD13            _SBF(2,1)
#define LCDMUX_PIOB6            _SBF(3,0)
#define LCDMUX_CLD14            _SBF(3,1)
#define LCDMUX_PIOB7            _SBF(4,0)
#define LCDMUX_CLD15            _SBF(4,1)
#define LCDMUX_CLDSPLEN			_SBF(4,2)
#define LCDMUX_PIOC0			_SBF(6,0)
#define LCDMUX_CLDEN			_SBF(6,1)
#define LCDMUX_CLSPL            _SBF(6,2)
#define LCDMUX_PIOC1			_SBF(8,0)
#define LCDMUX_CLVDDEN			_SBF(8,1)
#define LCDMUX_CLS  			_SBF(8,2)
#define LCDMUX_PIOC2			_SBF(10,0)
#define LCDMUX_CLXCLK			_SBF(10,1)
#define LCDMUX_PIOC3			_SBF(11,0)
#define LCDMUX_CLCP				_SBF(11,1)
#define LCDMUX_PIOC4			_SBF(12,0)
#define LCDMUX_CLD16			_SBF(12,1)
#define LCDMUX_PIOC5			_SBF(13,0)
#define LCDMUX_CLLP				_SBF(13,1)
#define LCDMUX_CLP				_SBF(13,2)
#define LCDMUX_PIOC6			_SBF(15,0)
#define LCDMUX_CLD17			_SBF(15,1)
#define LCDMUX_PIOC7			_SBF(16,0)
#define LCDMUX_CLFP				_SBF(16,1)
#define LCDMUX_CLSPS			_SBF(16,2)
#define LCDMUX_PIOD0            _SBF(18,0)
#define LCDMUX_CLD2             _SBF(18,1)
#define LCDMUX_PIOD1            _SBF(19,0)
#define LCDMUX_CLD3             _SBF(19,1)
#define LCDMUX_PIOD2            _SBF(20,0)
#define LCDMUX_CLD4             _SBF(20,1)
#define LCDMUX_PIOD3            _SBF(21,0)
#define LCDMUX_CLD5             _SBF(21,1)
#define LCDMUX_PIOD4            _SBF(22,0)
#define LCDMUX_CLD6             _SBF(22,1)
#define LCDMUX_CPS              _SBF(22,2)
#define LCDMUX_PIOD5            _SBF(24,0)
#define LCDMUX_CLD7             _SBF(24,1)
#define LCDMUX_PIOD6            _SBF(25,0)
#define LCDMUX_CLD8             _SBF(25,1)
#define LCDMUX_PIOD7            _SBF(26,0)
#define LCDMUX_CLD9             _SBF(26,1)
#define LCDMUX_RCEII6           _SBF(27,0)
#define LCDMUX_CLD10            _SBF(27,1)
#define LCDMUX_RCEII7           _SBF(28,0)
#define LCDMUX_CLD11            _SBF(28,1)

/*
 * Miscellaneous Multiplexing IOCON Register Bit Field constants
 */ 
#define	MISCMUX_PWM1			_SBF(0,0)
#define	MISCMUX_DCDEOT1			_SBF(0,1)
#define	MISCMUX_PIOA5			_SBF(1,0)
#define	MISCMUX_RCCLKOUT		_SBF(1,1)
#define	MISCMUX_PIOA6			_SBF(2,0)
#define	MISCMUX_RCEII0			_SBF(2,1)
#define	MISCMUX_PIOA7			_SBF(3,0)
#define	MISCMUX_RCEII1			_SBF(3,1)
#define	MISCMUX_PIOB0			_SBF(4,0)
#define	MISCMUX_RCEII2			_SBF(4,1)
#define	MISCMUX_RCEII3			_SBF(5,0)
#define	MISCMUX_PWM0SYNC		_SBF(5,1)
#define	MISCMUX_RCEII4			_SBF(6,0)
#define	MISCMUX_PWM0			_SBF(6,1)
#define	MISCMUX_RCCTOUT			_SBF(7,0)
#define	MISCMUX_DCDACK1			_SBF(7,1)
#define	MISCMUX_DCDREQ1			_SBF(8,0)
#define	MISCMUX_RCEII5_x		_SBF(8,0)
#define	MISCMUX_NWAIT			_SBF(8,1)
#define	MISCMUX_PIOF1			_SBF(9,0)
#define	MISCMUX_RCCLKEN			_SBF(9,1)
#define	MISCMUX_RCCLKIN			_SBF(10,0)
#define	MISCMUX_RCUTCLK			_SBF(10,1)

/*
 * DMA Multiplexing IOCON Register Bit Field constants
 */ 
#define	DMAMUX_PIOB1			_SBF(0,0)
#define	DMAMUX_DCDEOT0			_SBF(0,1)
#define	DMAMUX_PIOB2			_SBF(1,0)
#define	DMAMUX_DCDACK0N			_SBF(1,1)
#define	DMAMUX_PIOB3			_SBF(2,0)
#define	DMAMUX_DCDREQ0			_SBF(2,1)

/*
 * UART Multiplexing IOCON Register Bit Field constants
 */ 
#define	UARTMUX_UT0IRRXA		_SBF(0,0)
#define	UARTMUX_UT0RXD			_SBF(0,1)
#define	UARTMUX_UT0IRTXA		_SBF(1,0)
#define	UARTMUX_UT0TXD			_SBF(1,1)
#define	UARTMUX_PIOA3			_SBF(2,0)
#define	UARTMUX_UT1RXD			_SBF(2,1)
#define	UARTMUX_PIOA4			_SBF(3,0)
#define	UARTMUX_UT1TXD			_SBF(3,1)

/*
 * SSI Multiplexing IOCON Register Bit Field constants
 */ 
#define	SSIMUX_SSPIN			_SBF(0,0)
#define	SSIMUX_UT2RXD			_SBF(0,1)
#define	SSIMUX_SSPOUT			_SBF(1,0)
#define	SSIMUX_UT2TXD			_SBF(1,1)
#define	SSIMUX_PIOA0			_SBF(2,0)
#define	SSIMUX_SSPENB			_SBF(2,1)
#define	SSIMUX_PIOA1			_SBF(3,0)
#define	SSIMUX_SSPCLK			_SBF(3,1)
#define	SSIMUX_PIOA2			_SBF(4,0)
#define	SSIMUX_SSPFRM			_SBF(4,1)

#endif /* LH79520_IOCON_H */ 

