/*
 *  linux/include/asm-arm/arch-lh79520/dma.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

#include <asm/hardware.h>
#include <asm/arch/cpld.h>

#define MAX_DMA_ADDRESS		0xfffc0000

#define MAX_DMA_CHANNELS	0
#define LH79520_DMA_CHANNELS	4

/*
 * All possible LH79520 devices a DMA channel can be attached to.
 */
/* FIXME */

typedef enum {
    DMA_SSP_Rx,
    DMA_SSP_Tx,
    DMA_Audio_Out,
    DMA_Audio_In
} dma_device_t;


typedef void (*dma_callback_t)( void *buf_id, int size );


/* LH79520 DMA API */
extern int lh79520_request_dma( dmach_t *channel, const char *device_id,
			       dma_device_t device );
extern int lh79520_dma_set_callback( dmach_t channel, dma_callback_t cb );
extern int lh79520_dma_set_spin( dmach_t channel, dma_addr_t addr, int size );
extern int lh79520_dma_queue_buffer( dmach_t channel, void *buf_id,
				    dma_addr_t data, int size );
extern int lh79520_dma_get_current( dmach_t channel, void **buf_id, dma_addr_t *addr );
extern int lh79520_dma_stop( dmach_t channel );
extern int lh79520_dma_resume( dmach_t channel );
extern int lh79520_dma_flush_all( dmach_t channel );
extern void lh79520_free_dma( dmach_t channel );
extern int lh79520_dma_sleep( dmach_t channel );
extern int lh79520_dma_wakeup( dmach_t channel );

#endif /* _ASM_ARCH_DMA_H */

