/*
 *  linux/arch/arm/mach-lh79520/mm.c
 *
 *  Copyright (C) 2001 Lineo, Inc.
 *  Copyright (C) 2003 Logic Product Development.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/init.h>

#include <asm/pgtable.h>
#include <asm/page.h>
#include <asm/io.h>

#include <asm/mach/map.h>

static struct map_desc lh79520_io_desc[] __initdata = {
	/* virt           phys              size                     r  w  c  b    */
	{ FLASH_BASE,    FLASH_START,     FLASH_SIZE,     DOMAIN_IO, 0, 1, 0, 0 },
#ifdef SMC91c111_BASE
	{ SMC91c111_BASE,SMC91c111_START, SMC91c111_SIZE, DOMAIN_IO, 0, 1, 0, 0 },
#endif
#ifdef LPD_CPLD_BASE
	{ LPD_CPLD_BASE, LPD_CPLD_START,  LPD_CPLD_SIZE,  DOMAIN_IO, 0, 1, 0, 0 },
#endif
	{ IDE_BASE,      IDE_START,       IDE_SIZE,       DOMAIN_IO, 0, 1, 0, 0 },
#ifdef IDE2_BASE
#error
	{ IDE2_BASE,     IDE2_START,      IDE2_SIZE,      DOMAIN_IO, 0, 1, 0, 0 },
#endif
	{ INT_SRAM_BASE, INT_SRAM_START,  INT_SRAM_SIZE,  DOMAIN_IO, 0, 1, 0, 0 },
	{ APB_BASE,      APB_START,       APB_SIZE,       DOMAIN_IO, 0, 1, 0, 0 },
	{ AHB_BASE,      AHB_START,       AHB_SIZE,       DOMAIN_IO, 0, 1, 0, 0 },
	{ VIC_BASE,      VIC_START,       VIC_SIZE,       DOMAIN_IO, 0, 1, 0, 0 },
	LAST_DESC
};

void __init lh79520_map_io(void)
{
	iotable_init(lh79520_io_desc);
}
