/*
 *  linux/arch/arm/mach-lh79520/generic.c
 *
 *  Common code for all LH79520 based machines.
 *
 *  Copyright (C) 2001 Lineo, Inc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/arch/rcpc.h>


/*
 * return the CPU clock frequency (FCLK) in Hz.
 */
unsigned int
cpufreq_get( int cpu)
{
	int	divider;
	rcpcRegs_t *RCPC = (rcpcRegs_t *)IO_ADDRESS(RCPC_PHYS);

	divider = RCPC->CpuClkPrescale * 2;
	if( divider == 0)
		divider = 1;
	return PLL_CLOCK / divider;;
}
EXPORT_SYMBOL(cpufreq_get);


/*
 * return the bus clock frequency (HCLK) in Hz.
 */
unsigned int
hclkfreq_get( void)
{
	int	divider;
	rcpcRegs_t *RCPC = (rcpcRegs_t *)IO_ADDRESS(RCPC_PHYS);

	divider = RCPC->HCLKPrescale * 2;	/* HCLK prescale value			*/

	if( divider == 0)					/* no prescalar == divide by 1	*/
		divider = 1;

	return PLL_CLOCK / divider;
}

/*
 * this just ensures a memory access from an un-cacheable
 * region that's different from where the CPLD is.
 * we do this because the 79520 SMC doens't guarantee
 * that consecutive accesses to the same CS region will
 * cause independent CS frames, but we need them.
 */
void
boink(void)
{
	rcpcRegs_t *RCPC = (rcpcRegs_t *)IO_ADDRESS(RCPC_PHYS);
	volatile int ii;
	ii = RCPC->CpuClkPrescale;
}
