#include <stdio.h>
#include "kabc/stdaddressbook.h"

using namespace KABC;

AddressBook *StdAddressBook::mSelf = 0;

Addressee::List StdAddressBook::findByEmail(const QString & email) {
  qDebug("Start: StdAddressBook::findByEmail");

  Addressee::List list = getAddresseesFromPlugin();
  Addressee::List result;
 
  for (uint i=0; i < list.count(); i++) {
    Addressee a = list[i];
    if (a.emails().grep(email, false).count() > 0) {
      result.append(a);
    } 
  }
  
  qDebug("End: StdAddressBook::findByEmail");
  return result;

}
Addressee::List StdAddressBook::findByUid(const QString & uid) {
  qDebug("Start: StdAddressBook::findByUid");

  Addressee::List list = getAddresseesFromPlugin();
  Addressee::List result;
 
  for (uint i=0; i < list.count(); i++) {
    Addressee a = list[i];
    if (a.uid() == uid ) {
      result.append(a);
    } 
  }
  
  qDebug("End: StdAddressBook::findByUID");
  return result;

}

AddressBook *StdAddressBook::self() {
  qDebug("Start: StdAddressBook::self");

  if (!mSelf) {
    mSelf = new StdAddressBook();
  }
  
  qDebug("End: StdAddressBook::self");
  return mSelf;

}
