/*  This file is part of the KDE project
    Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/


#include "run.h"
#include "view.h"

#include <khtml_part.h>

Run::Run( View *view, const KURL &url, const KParts::URLArgs &args )
    : KHTMLRun( static_cast<KHTMLPart *>(view->part()), 0,
		    url, args, true )
{
    m_view = view;
}

void Run::foundMimeType( const QString &mimeType )
{
    m_view->openURL( m_strURL, mimeType, urlArgs() );
}

void Run::handleError( KIO::Job *job)
{
    // Show an error page if possible.
    static_cast< KHTMLPart *>(m_view->part())->showError(job);
}
