/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <time.h>
#ifndef _WIN32_
#include <unistd.h>
#endif
#include <qdir.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <qstring.h>
#include <qregexp.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstringlist.h>
#include <stdlib.h>

#include <kglobal.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdebug.h>
#include <kemailsettings.h>
#include <kstaticdeleter.h>

#include "koprefs.h"
#include "mainwindow.h"

const char *germanwords[][2] = { 
#include "wordsgerman.h"
  "", ""
};

KOPrefs *KOPrefs::mInstance = 0;
static KStaticDeleter<KOPrefs> insd;

KOPrefs::KOPrefs() :
  KPimPrefs("korganizerrc")
{
  mCategoryColors.setAutoDelete(true);
  mLocaleDict = 0;
  fillMailDefaults();
  mDefaultCategoryColor           = QColor(175,210,255);//196,196,196);
  QColor defaultHolidayColor      = QColor(255,0,0);
  QColor defaultHighlightColor    = QColor(129,112,255);//64,64,255);
  QColor defaultAgendaBgColor     = QColor(239,241,169);//128,128,128);
  QColor defaultWorkingHoursColor = QColor(170,223,150);//160,160,160);
  QColor defaultTodoDueTodayColor = QColor(255,220,100);
  QColor defaultTodoOverdueColor  = QColor(255,153,125);

  mTimeBarFont = QFont("helvetica",10);//,QFont::Bold);
  mDefaultViewFont = QFont("helvetica",10);
  mDefaultMonthViewFont = QFont("helvetica",8);
  mMarcusBainsFont= QFont("helvetica",10);
  mDateNavigatorFont= QFont("helvetica",10, QFont::Bold);
  mEditBoxFont = QFont("helvetica",12);
  mJornalViewFont = QFont("helvetica",12);

  KPrefs::setCurrentGroup("General");
  addItemBool("Enable Group Scheduling",&mEnableGroupScheduling,false);

  addItemBool("ShowIconNewTodo",&mShowIconNewTodo,true);
  addItemBool("ShowIconNewEvent",&mShowIconNewEvent,true);
  addItemBool("ShowIconSearch",&mShowIconSearch,true);
  addItemBool("ShowIconList",&mShowIconList,true);
  addItemBool("ShowIconDay1",&mShowIconDay1,true);
  addItemBool("ShowIconDay5",&mShowIconDay5,true);
  addItemBool("ShowIconDay7",&mShowIconDay7,true);
  addItemBool("ShowIconMonth",&mShowIconMonth,true);
  addItemBool("ShowIconTodoview",&mShowIconTodoview,true);
  addItemBool("ShowIconBackFast",&mShowIconBackFast,true);
  addItemBool("ShowIconBack",&mShowIconBack,true);
  addItemBool("ShowIconToday",&mShowIconToday,true);
  addItemBool("ShowIconForward",&mShowIconForward,true);
  addItemBool("ShowIconForwardFast",&mShowIconForwardFast,true);
  addItemBool("ShowIconWhatsThis",&mShowIconWhatsThis,false);
  addItemBool("ShowIconNextDays",&mShowIconNextDays,true);
  addItemBool("ShowIconNext",&mShowIconNext,true);
  addItemBool("ShowIconJournal",&mShowIconJournal,true); 
  addItemBool("ShowIconStretch",&mShowIconStretch,true); 
  addItemBool("LanguageChanged",&mLanguageChanged,false); 

  addItemBool("AskForQuit",&mAskForQuit,false); 

#ifndef DESKTOP_VERSION
  addItemBool("ShowFullMenu",&mShowFullMenu,false); 
#else
  addItemBool("ShowFullMenu",&mShowFullMenu,true); 
#endif
  addItemBool("ToolBarHor",&mToolBarHor, true );
  addItemBool("ToolBarUp",&mToolBarUp, false );
  addItemBool("ToolBarMiniIcons",&mToolBarMiniIcons, false );
  addItemInt("Whats Next Days",&mWhatsNextDays,3);
  addItemInt("Whats Next Prios",&mWhatsNextPrios,1);

  addItemBool("ShowTodoInAgenda",&mShowTodoInAgenda,true);
  addItemBool("ShowCompletedTodo",&mShowCompletedTodo,true);
  addItemInt("AllDay Size",&mAllDaySize,28);
  QString defAlarm = KGlobal::iconLoader()->iconPath()+"koalarm.wav";
  addItemString("DefaultAlarmFile",&mDefaultAlarmFile,defAlarm );

  addItemStringList("LocationDefaults",&mLocationDefaults );
  addItemStringList("EventSummary User",&mEventSummaryUser);
  addItemStringList("TodoSummary User",&mTodoSummaryUser);

  addItemBool("Enable Group Scheduling",&mEnableGroupScheduling,false);
  addItemBool("Enable Project View",&mEnableProjectView,false);
  addItemBool("Auto Save",&mAutoSave,false);
  addItemInt("Auto Save Interval",&mAutoSaveInterval,3);
  addItemBool("Confirm Deletes",&mConfirm,true);
  addItemString("Archive File",&mArchiveFile);
  addItemString("Html Export File",&mHtmlExportFile,
      QDir::homeDirPath() + "/" + i18n("Default export file", "calendar.html"));
  addItemBool("Html With Save",&mHtmlWithSave,false);

  KPrefs::setCurrentGroup("Personal Settings");

  addItemInt("Mail Client",&mMailClient,MailClientKMail);
  addItemBool("Use Control Center Email",&mEmailControlCenter,false);
  addItemBool("Bcc",&mBcc,false);

  KPrefs::setCurrentGroup("Time & Date");

  // addItemString("Time Zone",&mTimeZone,"+0100");
  addItemString("TimeZoneName",&mTimeZoneId,i18n ("+01:00 Europe/Oslo(CET)") );
  // addItemInt("TimeZoneOffset",&mTimeZoneOffset,60);
  addItemBool("UseDaylightsaving",&mUseDaylightsaving,true);
  addItemInt("DaylightsavingStart",&mDaylightsavingStart,90);
  addItemInt("DaylightsavingEnd",&mDaylightsavingEnd,304);


  addItemInt("Default Start Time",&mStartTime,10);
  addItemInt("Default Duration",&mDefaultDuration,2);
  addItemInt("Default Alarm Time",&mAlarmTime,3);
  addItemInt("Daylight Savings",&mDaylightSavings,0);
  KPrefs::setCurrentGroup("AlarmSettings");
  addItemInt("AlarmPlayBeeps",&mAlarmPlayBeeps,20);
  addItemInt("AlarmSuspendTime",&mAlarmSuspendTime,7);
  addItemInt("AlarmSuspendCount",&mAlarmSuspendCount,5);
  addItemInt("AlarmBeepInterval",&mAlarmBeepInterval,3);


  KPrefs::setCurrentGroup("Calendar");

  addItemInt("Default Calendar Format",&mDefaultFormat,FormatICalendar);

  KPrefs::setCurrentGroup("Fonts");
  // qDebug(" KPrefs::setCurrentGroup(Fonts); ");
  addItemFont("TimeBar Font",&mTimeBarFont);
  addItemFont("MonthView Font",&mMonthViewFont);
  addItemFont("AgendaView Font",&mAgendaViewFont);
  addItemFont("MarcusBains Font",&mMarcusBainsFont);
  addItemFont("TimeLabels Font",&mTimeLabelsFont);
  addItemFont("TodoView Font",&mTodoViewFont);
  addItemFont("ListView Font",&mListViewFont);
  addItemFont("DateNavigator Font",&mDateNavigatorFont);
  addItemFont("EditBox Font",&mEditBoxFont);
  addItemFont("JournalView Font",&mJornalViewFont);
  addItemFont("WhatsNextView Font",&mWhatsNextFont);
  addItemFont("EventView Font",&mEventViewFont);

//   KPrefs::setCurrentGroup("SyncProfiles");
//   addItemString("LocalMachineName",&mLocalMachineName, "undefined");
//   addItemStringList("SyncProfileNames",&mSyncProfileNames);
//   addItemStringList("ExternSyncProfiles",&mExternSyncProfileNames);

  KPrefs::setCurrentGroup("RemoteSyncing");
//   addItemBool("UsePasswd",&mUsePassWd,false); 
//   addItemBool("WriteBackFile",&mWriteBackFile,true);
//   addItemBool("WriteBackExistingOnly",&mWriteBackExistingOnly,false);
//   addItemBool("AskForPreferences",&mAskForPreferences,true); 
//   addItemBool("ShowSyncSummary",&mShowSyncSummary,true); 
  addItemBool("ShowSyncEvents",&mShowSyncEvents,false); 
  addItemInt("LastSyncTime",&mLastSyncTime,0); 
  addItemInt("SyncAlgoPrefs",&mSyncAlgoPrefs,3); 
  addItemInt("RingSyncAlgoPrefs",&mRingSyncAlgoPrefs,3);

#ifdef _WIN32_
  QString hdp= locateLocal("data","korganizer")+"\\\\";
#else
  QString hdp= locateLocal("data","korganizer")+"/";
#endif
//   addItemString("RemoteIP",&mRemoteIP, "192.168.0.65");
//   addItemString("RemoteUser",&mRemoteUser, "zaurus");
//   addItemString("RemotePassWd",&mRemotePassWd, "");
//   addItemString("RemoteFile", &mRemoteFile, hdp+"mycalendar.ics");
//   addItemString("LocalTempFile",&mLocalTempFile, "/tmp/tempsyncfile.ics" );


  KPrefs::setCurrentGroup("LoadSaveFileNames");

  addItemString("LastImportFile", &mLastImportFile ,hdp +"import.ics" );
  addItemString("LastVcalFile", &mLastVcalFile ,hdp +"export.vcs" );
  addItemString("LastSaveFile", &mLastSaveFile ,hdp +"mybackup.ics" );
  addItemString("LastLoadFile", &mLastLoadFile ,hdp +"mybackup.ics" );
  addItemString("LastSyncedLocalFile", &mLastSyncedLocalFile ,hdp +"lastsync.ics" );
 

  KPrefs::setCurrentGroup("Locale");
  addItemInt("PreferredLanguage",&mPreferredLanguage,0);
  addItemInt("PreferredTime",&mPreferredTime,0);
  addItemInt("PreferredDate",&mPreferredDate,0);
  addItemBool("WeekStartsOnSunday",&mWeekStartsOnSunday,false); 
  addItemBool("QuickSavingWOUnicode",&mUseQuicksave,false); 
  addItemBool("ShortDateInViewer",&mShortDateInViewer,false); 
  addItemString("UserDateFormatLong", &mUserDateFormatLong, "%A %d %b %y");
  addItemString("UserDateFormatShort", &mUserDateFormatShort, "%aK %d.%m.%y");


  KPrefs::setCurrentGroup("Colors");
  addItemColor("Holiday Color",&mHolidayColor,defaultHolidayColor);
  addItemColor("Highlight Color",&mHighlightColor,defaultHighlightColor);
  addItemColor("Event Color",&mEventColor,mDefaultCategoryColor);
  addItemColor("Agenda Background Color",&mAgendaBgColor,defaultAgendaBgColor);
  addItemColor("WorkingHours Color",&mWorkingHoursColor,defaultWorkingHoursColor);
  addItemColor("Todo due today Color",&mTodoDueTodayColor,defaultTodoDueTodayColor);
  addItemColor("Todo overdue Color",&mTodoOverdueColor,defaultTodoOverdueColor);
  addItemColor("MonthViewEvenColor",&mMonthViewEvenColor,QColor( 160,160,255 ));
  addItemColor("MonthViewOddColor",&mMonthViewOddColor,QColor( 160,255,160 ));
  addItemColor("MonthViewHolidayColor",&mMonthViewHolidayColor,QColor( 255,160,160 ));
  addItemBool("MonthViewUsesDayColors",&mMonthViewUsesDayColors,true); 
  addItemBool("MonthViewSatSunTog",&mMonthViewSatSunTog,true);
  addItemBool("HightlightDateTimeEdit",&mHightlightDateTimeEdit,false); 
  addItemColor("AppColor1",&mAppColor1,QColor( 130,170,255 ));
  addItemColor("AppColor2",&mAppColor2,QColor(  174,216,255 ));
  addItemBool("UseAppColors",&mUseAppColors,false); 

  

  KPrefs::setCurrentGroup("Views");
  addItemInt("Hour Size",&mHourSize,8);
  addItemBool("Show Daily Recurrences",&mDailyRecur,true);
  addItemBool("Show Weekly Recurrences",&mWeeklyRecur,true);
  addItemBool("Show Month Daily Recurrences",&mMonthDailyRecur,true);
  addItemBool("Show Month Weekly Recurrences",&mMonthWeeklyRecur,true);
  addItemBool("ShowShortMonthName",&mMonthShowShort,false);
  addItemBool("ShowIconsInMonthCell",&mMonthShowIcons,true);
  addItemBool("Enable ToolTips",&mEnableToolTips,false);
  addItemBool("Enable MonthView ScrollBars",&mEnableMonthScroll,false);
  addItemBool("Marcus Bains shows seconds",&mMarcusBainsShowSeconds,false);
  addItemBool("Show Marcus Bains",&mMarcusBainsEnabled,true);
  addItemBool("EditOnDoubleClick",&mEditOnDoubleClick,true);
  addItemBool("ViewChangeHoldFullscreen",&mViewChangeHoldFullscreen,false);
  addItemBool("ViewChangeHoldNonFullscreen",&mViewChangeHoldNonFullscreen,false);
  addItemBool("CenterOnCurrentTime",&mCenterOnCurrentTime,false);
  addItemBool("SetTimeToDayStartAt",&mSetTimeToDayStartAt,true);
  addItemBool("HighlightCurrentDay",&mHighlightCurrentDay,true);
  addItemBool("WNViewShowsParents",&mWNViewShowsParents,true);
  addItemBool("WNViewShowLocation",&mWNViewShowLocation,false);
  addItemBool("UseHighlightLightColor",&mUseHighlightLightColor,false);
  addItemBool("ListViewMonthTimespan",&mListViewMonthTimespan,true);
  addItemBool("TodoViewUsesCatColors",&mTodoViewUsesCatColors,false);
  addItemBool("TodoViewShowsPercentage",&mTodoViewShowsPercentage,false);
  addItemBool("TodoViewUsesSmallFont",&mTodoViewUsesSmallFont,false);
  addItemBool("TodoViewUsesForegroundColor",&mTodoViewUsesForegroundColor,false);
  addItemBool("MonthViewUsesForegroundColor",&mMonthViewUsesForegroundColor,false);
#ifdef DESKTOP_VERSION
  addItemBool("UseInternalAlarmNotification",&mUseInternalAlarmNotification,true);
#else
  addItemBool("UseInternalAlarmNotification",&mUseInternalAlarmNotification,false);
#endif
  addItemInt("Day Begins",&mDayBegins,7);
  addItemInt("Working Hours Start",&mWorkingHoursStart,8);
  addItemInt("Working Hours End",&mWorkingHoursEnd,17);
  addItemBool("Exclude Holidays",&mExcludeHolidays,true);
  addItemBool("Exclude Saturdays",&mExcludeSaturdays,true);

  addItemBool("Month View Uses Category Color",&mMonthViewUsesCategoryColor,false);
  addItemBool("Full View Month",&mFullViewMonth,true);
  addItemBool("Full View Todo",&mFullViewTodo,true);
  addItemBool("Quick Todo",&mEnableQuickTodo,false);

  addItemInt("Next X Days",&mNextXDays,3);

  KPrefs::setCurrentGroup("Printer");

  KPrefs::setCurrentGroup("Layout");

  addItemBool("CompactDialogs",&mCompactDialogs,false);
  addItemBool("VerticalScreen",&mVerticalScreen,true);

  KPrefs::setCurrentGroup("KOrganizer Plugins");

  addItemStringList("SelectedPlugins",&mSelectedPlugins,"holidays");

  KPrefs::setCurrentGroup("Group Scheduling");

  addItemInt("IMIPScheduler",&mIMIPScheduler,IMIPKMail);
  addItemInt("IMIPSend",&mIMIPSend,IMIPdirectsend);
  addItemStringList("AdditionalMails",&mAdditionalMails,"");
  addItemInt("IMIP auto refresh",&mIMIPAutoRefresh,neverAuto);
  addItemInt("IMIP auto insert request",&mIMIPAutoInsertRequest,neverAuto);
  addItemInt("IMIP auto insert reply",&mIMIPAutoInsertReply,neverAuto);
  addItemInt("IMIP auto FreeBusy",&mIMIPAutoFreeBusy,neverAuto);
  addItemInt("IMIP auto save FreeBusy",&mIMIPAutoFreeBusyReply,neverAuto);

  KPrefs::setCurrentGroup( "Editors" );

  addItemStringList( "EventTemplates", &mEventTemplates );
  addItemStringList( "TodoTemplates", &mTodoTemplates );

  addItemInt("DestinationPolicy",&mDestination,standardDestination);



}


KOPrefs::~KOPrefs()
{
  if (mInstance == this)
      mInstance = insd.setObject(0); 
  setLocaleDict( 0 );
  if ( mLocaleDict )
      delete mLocaleDict;
  //qDebug("KOPrefs::~KOPrefs() ");
}


KOPrefs *KOPrefs::instance()
{
  if (!mInstance) {
      mInstance = insd.setObject(new KOPrefs());
      mInstance->readConfig();
  }

  return mInstance;
}

void KOPrefs::usrSetDefaults()
{
   
}

void KOPrefs::fillMailDefaults()
{
  if (mName.isEmpty()) mName = i18n("Anonymous");
  if (mEmail.isEmpty()) mEmail = i18n("nobody@nowhere");
}

void KOPrefs::setTimeZoneIdDefault()
{
  mTimeZoneId = i18n("+01:00 Europe/Oslo(CET)");
}

void KOPrefs::setCategoryDefaults()
{
  mCustomCategories.clear();
  mCustomCategories = getDefaultList();

  QStringList::Iterator it;
  for (it = mCustomCategories.begin();it != mCustomCategories.end();++it ) {
    setCategoryColor(*it,mDefaultCategoryColor);
  }
}

QStringList KOPrefs::getDefaultList()
{
    QStringList retval ;
    retval << i18n("Anniversary") << i18n("Appointment") << i18n("Birthday") << i18n("Business") << i18n("Business Travel") << i18n("Cinema")  << i18n("Customer")
           << i18n("Break")<< i18n("Breakfast")<< i18n("Competition")<< i18n("Dinner")
           << i18n("Education")<< i18n("Family")  << i18n("Favorites")  << i18n("Festival")<< i18n("Fishing")<< i18n("Flight") << i18n("Gifts")  
           << i18n("Holiday") << i18n("Holiday Cards")<< i18n("Hot Contacts") << i18n("Hiking") << i18n("Hunting") << i18n("Key Customer") << i18n("Kids") 
                    << i18n("Lunch")  << i18n("Meeting") << i18n("Miscellaneous") << i18n("Partner")<< i18n("Party") << i18n("Personal") << i18n("Personal Travel")
           << i18n("PHB") << i18n("Phone Calls") << i18n("Projects") << i18n("Recurring") << i18n("School") << i18n("Shopping")
           << i18n("Speach")  << i18n("Special Occasion") << i18n("Sports") << i18n("Talk") << i18n("Travel") << i18n("TV")<< i18n("University")
           << i18n("Vacation") << i18n("VIP") << i18n("SyncEvent")  ;
    retval.sort();
    return retval; 
}

void KOPrefs::usrReadConfig()
{
    mLocaleDict = 0;
    // pending LR fix translation
    // qDebug("KOPrefs::usrReadConfig() fix translation ");
    if ( mPreferredLanguage > 0 && mPreferredLanguage < 4 ) {
        if ( mPreferredLanguage == 1 ) {
            mLocaleDict = new QDict<QString>;
            int i = 0;
            QString fw ( germanwords[i] [0]);
            while ( !fw.isEmpty() ) {
                mLocaleDict->insert( fw, new QString (germanwords[i] [1] ));
                ++i;
                fw = germanwords[i] [0];
            }
        
            setLocaleDict( mLocaleDict );
        } else {
            QString fileName ;
            if ( mPreferredLanguage == 3 ) 
                fileName = MainWindow::resourcePath()+"usertranslation.txt"; 
            else if ( mPreferredLanguage == 2 ) 
                fileName = MainWindow::resourcePath()+"frenchtranslation.txt";
            QFile file( fileName );
            if (file.open( IO_ReadOnly ) ) {
                QTextStream ts( &file );
                ts.setEncoding( QTextStream::Latin1 );
                //ts.setCodec( QTextCodec::latin1 );
                QString  text = ts.read();
                file.close();  
                text.replace( QRegExp("\\\\n"), "\n" );
                QString line;
                QString we;
                QString wt;
                int br = 0;
                int nbr;
                nbr = text.find ( "},", br );
                line = text.mid( br, nbr - br );
                br = nbr+1;
                int se, ee, st, et;
                mLocaleDict = new QDict<QString>;
                QString end = "{ \"\",\"\" }";
                while ( (line != end) && (br > 1)  ) {
                    //qDebug("%d *%s* ", br, line.latin1());
                    se = line.find("\"")+1;
                    et = line.findRev("\"",-1);
                    ee = line.find("\",\"");
                    st = ee+3;
                    we = line.mid( se, ee-se );
                    wt = line.mid( st, et-st );
                    //qDebug("*%s* *%s* ", we.latin1(), wt.latin1());
                    mLocaleDict->insert( we, new QString (wt) );
                    nbr = text.find ( "}", br );
                    line = text.mid( br, nbr - br );
                    br = nbr+1;
                }
                //qDebug("end *%s* ", end.latin1());

                setLocaleDict( mLocaleDict );
            } else {
                qDebug("KO: Cannot find translation file %s",fileName.latin1() );
            }
    
        }
    }
    config()->setGroup("General");
    
    mCustomCategories = config()->readListEntry("Custom Categories");
    if ( KOPrefs::instance()->mLanguageChanged ) {
        mLocationDefaults.clear();
        mEventSummaryUser.clear();
        mTodoSummaryUser.clear();
    }
   if (mLocationDefaults.isEmpty()) {
       mLocationDefaults << i18n("Home") << i18n("Office") << i18n("Library") << i18n("School") << i18n("Doctor") << i18n("Beach") 
                         << i18n("University") << i18n("Restaurant")  << i18n("Bar") << i18n("Conference room") << i18n("Cinema")  << i18n("Lake") << i18n("Kindergarten")
                         << i18n("Germany") << i18n("Sweden") << i18n("Forest") << i18n("Desert") << i18n("Kitchen") ;
       // << i18n("") << i18n("") << i18n("") << i18n("") << i18n("") << i18n("") << i18n("") << i18n("")
       mLocationDefaults.sort();
    }
       
   if (mEventSummaryUser.isEmpty()) {
        mEventSummaryUser  = getDefaultList() ;
    }
   if (mTodoSummaryUser.isEmpty()) {
       mTodoSummaryUser  = getDefaultList() ;
   }
  
  if (mCustomCategories.isEmpty()) setCategoryDefaults();

  config()->setGroup("Personal Settings");
  mName = config()->readEntry("user_name","");
  mEmail = config()->readEntry("user_email","");
  fillMailDefaults();

  config()->setGroup("Category Colors");
  QStringList::Iterator it;
  for (it = mCustomCategories.begin();it != mCustomCategories.end();++it ) {
    setCategoryColor(*it,config()->readColorEntry(*it,&mDefaultCategoryColor));
   
  }
  
  if (mTimeZoneId.isEmpty()) {
    setTimeZoneIdDefault();
  }
  KPimPrefs::usrReadConfig();
}


void KOPrefs::usrWriteConfig()
{
  config()->setGroup("General");
  config()->writeEntry("Custom Categories",mCustomCategories); 
  
  config()->setGroup("Personal Settings");
  config()->writeEntry("user_name",mName);
  config()->writeEntry("user_email",mEmail);

  config()->setGroup("Category Colors");
  QDictIterator<QColor> it(mCategoryColors);
  while (it.current()) {
    config()->writeEntry(it.currentKey(),*(it.current()));
    ++it;
  }


  KPimPrefs::usrWriteConfig();
}

void KOPrefs::setCategoryColor(QString cat,const QColor & color)
{
  mCategoryColors.replace(cat,new QColor(color));
}

QColor *KOPrefs::categoryColor(QString cat)
{
  QColor *color = 0;

  if (!cat.isEmpty()) color = mCategoryColors[cat];

  if (color) return color;
  else return &mDefaultCategoryColor;
}

void KOPrefs::setFullName(const QString &name)
{
  mName = name;
}

void KOPrefs::setEmail(const QString &email)
{
    //qDebug(" KOPrefs::setEmai*********** %s",email.latin1() );
  mEmail = email;
}

QString KOPrefs::fullName()
{
  if (mEmailControlCenter) {
    KEMailSettings settings;
    return settings.getSetting(KEMailSettings::RealName);
  } else {
    return mName;
  }
}

QString KOPrefs::email()
{
  if (mEmailControlCenter) {
    KEMailSettings settings;
    return settings.getSetting(KEMailSettings::EmailAddress);
  } else {
    return mEmail;
  }
}
KConfig* KOPrefs::getConfig()
{
    return config();
}
