/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
 
// Class definition include
#include "OO_MetaDataWriter.h"
#include "OO_Common.h"
 
// Abiword includes
#include <ut_types.h>
#include <ut_string_class.h>
#include <pd_Document.h>
 
// External includes
#include <gsf/gsf-output-stdio.h>
#include <gsf/gsf-outfile.h>
 
 
 
 
/**
 * 
 */
bool OO_MetaDataWriter::writeMetaData(PD_Document* pDoc, GsfOutfile* oo) {
    
    GsfOutput* meta = gsf_outfile_new_child (oo, "meta.xml", FALSE);

    static const char * const preamble [] = {
        "<?xml version='1.0' encoding='UTF-8'?>\n",
        "<!DOCTYPE office:document-meta PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'>\n",
        "<office:document-meta xmlns:office='http://openoffice.org/2000/office' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:meta='http://openoffice.org/2000/meta' office:version='1.0'>\n",
        "<office:meta>\n",
        "<meta:generator>AbiWord</meta:generator>\n"
    };

    static const char * const postamble [] = {
        "</office:meta>\n",
        "</office:document-meta>\n"
    };

    oo_writeToStream(meta, preamble, NrElements(preamble));

    UT_UTF8String meta_val, val;

    if (pDoc->getMetaDataProp(PD_META_KEY_DATE, meta_val) && meta_val.size()) {
        val = UT_UTF8String_sprintf("<dc:date>%s</dc:date>\n", meta_val.utf8_str());
        oo_gsf_output_write(meta, val.size(), reinterpret_cast<const guint8*>(val.utf8_str()));
    }
    if (pDoc->getMetaDataProp(PD_META_KEY_LANGUAGE, meta_val) && meta_val.size()) {
        val = UT_UTF8String_sprintf("<dc:language>%s</dc:language>\n", meta_val.utf8_str());
        oo_gsf_output_write(meta, val.size(), reinterpret_cast<const guint8*>(val.utf8_str()));
    }

    oo_writeToStream(meta, postamble, NrElements(postamble));

    oo_gsf_output_close(meta);

    return true;
}
