/***************************************************************************
 *                       Control.h  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "Config.h"
#include "StreamHTML.h"
#include "StreamTXT.h"
#include "StreamPlucker.h"
#include "StreamPalmDoc.h"
#include "StreamPalmTXT.h"
#include "StreamPalmHTML.h"
#include "StreamPalmMP.h"
#include "Frame.h"
#include "IntDict.h"
#include "Unzip.h"
#include <qwidget.h>
#include <qevent.h> 
#include <qtimer.h>
#include <qapplication.h>
#include <qaction.h>
#include <qmainwindow.h>
#include <qprogressbar.h>
#include <qdialog.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#ifndef __FOR_QT__
#include <qpe/qcopenvelope_qws.h>
#endif

class Control;

struct pageAttrs {
    int    position;
    bool    newParagraph;
    int	    align;
    tagProps tag;
    int	    imageHeightProcessed;
    bool    newLine;
};


struct linksAttrs {
    QString fileName;
    pageAttrs attrs;
};

class Control: public QWidget
{
    Q_OBJECT
    signals:
        void toggleFullScreen();
	void fileOpenSignal();
	void settingsSignal();
	void bookmarkSignal();
    private slots:
	void timerStopped();
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
    public slots:
	void findWord();
	void goLinkBack();
    protected slots:
	virtual void mousePressEvent(QMouseEvent *);
    private:
	Stream *stream;
	Frame	*frame;
	IntDict *dict;
	QWidget *paintDevice;
	QMainWindow *parent;
	bool newParagraph;
	bool newLine;
	int thisLineAlign;
	pageAttrs thisPageAttrs;
	pageAttrs thisLineAttrs;
	pageAttrs pagesAttrsCache[100];
	int pagesCachePointer;
	int pagesCacheSize;
	int maxPagesCacheSize;
	int pageSize;
	int format;
	unsigned char oldDocFormat,oldPalmFormat;
	QString oldDictionary;

	pageAttrs linesAttrCache[300];
	int linesHeights[300];
	int linesPointer;

	linksAttrs linksCache[30];
	int linksCachePointer;
	int linksCacheSize;
	int maxLinksCacheSize;

	void findLastAttrs();
	void getLine();
	bool feedLine(bool);
	bool tagsOnly;

	tagProps *tag;
	void applyTag();
	bool tagApplied;
	QString link2filePath(QString);
	bool timerStatus;
	void startTimer(int);
	void delay();
	void setFileFormat(QString);
	void translate();
	QString wordToTranslate,wordSense,wordInfo;
	bool translating;
	void showTranslation();
	void stringToFrame(QString);
	QString word2search;
	int lastFoundPos;
	
    public:
	Control(QMainWindow *w=0, const char *name=0);
	~Control();
	void fileOpen(QString);
	void pickUpSettings();
	void setSettings();
	void resume();
    	void keyPressed(QKeyEvent *);
	bool readBook(QString);
	void readNextPage();
	bool prepareNextPage();
	void readPrevPage();
	void setThisPageAttrs();
	void getThisPageAttrs();
	void setLineAttrs();
	void getLineAttrs();
	void setPageCacheAttrs();
	bool getPageCacheAttrs();
	void setThisLineAttrs(int);
	void getThisLineAttrs(int);
	void actionForXY(int,int);
	void gotoPosition(int);
	void resize();
	void showIt();
	void toggleSuspend(bool);
	void toggleScrolling();
	int getBookPosition();
	bool scrolling;
	bool stopScrolling;
	QString getBookmarkName();
	int getPageNumber();
	void generateContents(QString filename);
	QAction *goBackAction;

	c_config config;
	QString fileName;
	int docPosition;
	bool docIsOpen;
};

