/* XMonobut - Modify mouse button behaviour with keyboard.


   Copyright 2002 Matthew Allum <mallum@handhelds.org>

   Thanks to Dave Capella and Patrick Hill for patches.

   Originally loosly based on ideas found in xrmouse

   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.


*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <X11/Xresource.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/XInput.h>

/* Matchbox lib */
#include <libmb/mb.h>

#include "xmonobut.xpm"

MBPixbuf      *Pixbuf    = NULL;
MBTrayApp     *app; 
MBPixbufImage *img_icon;
/* Defaults */

int keycode  = 0;
int keycode2 = 0;
int active_button_num = 1;
int last_button_num = 1;
int cursor_disabled = False;
Time lasttime = 0;
Time dbl_click_time = 200;
Cursor right_curs, middle_curs, orig_curs;
Bool ButtonGrabbed = False;

int get_keycode_from_str(char *keycode_str)
{
   int kc = 0;
   if(!strcmp(keycode_str,"calendar")) { kc = 130; }
   else if(!strcmp(keycode_str,"phone")) { kc = 131; }
   else if(!strcmp(keycode_str,"mail")) { kc = 132; }
   else if(!strcmp(keycode_str,"start")) { kc = 133; }
   else if(!strcmp(keycode_str,"record")) { kc = 128; }
   else { kc = atoi(keycode_str); }
   if(!kc) {
      fprintf(stderr,"invalid keycode\n");
      exit(1);
   }
   return kc;
}

void usage()
{
   printf("usage: xmonobut [options...] \n");
   printf("where options are;\n");
   printf("\t-d <display>\n");
   printf("\t-k <keycode> keycode to grab. Tap once for right mouse button\n");
   printf("\t             , quickly tap twice for middle button ( disabled\n");
   printf("\t             if middle button keycode selected ).\n");
   printf("\t-t <value>   Time in milliseconds to catch double clicks\n");
   printf("\t             Defauts to 200.\n");
   printf("\t-m <keycode> Keycode to grab for middle mouse button.\n");
   printf("\t-c           Do not change cursor.\n" );
   exit(0);
}


void
paint_callback ( MBTrayApp *app, Drawable drw )
{
  MBPixbufImage *img_bg;
  int x = 0, y = 0, ox = 0, oy = 0;

  img_bg = mb_tray_app_get_background (app, Pixbuf);

  ox = (mb_tray_app_width(app) - mb_pixbuf_img_get_width(img_icon))/2;
  oy = (mb_tray_app_height(app) - mb_pixbuf_img_get_height(img_icon))/2;


  mb_pixbuf_img_copy_composite (Pixbuf, img_bg, img_icon, 
				0, 0, 
				mb_pixbuf_img_get_width(img_icon), 
				mb_pixbuf_img_get_height(img_icon), 
				ox, oy
				);

  if (active_button_num == 2)
    {
      for (x=0; x<3; x++)
	for (y=0; y<3; y++)
	  mb_pixbuf_img_plot_pixel(Pixbuf, img_bg, x+ox+4, y+oy+1, 0, 0, 0); 
    }
  else if (active_button_num == 3)
    {
      for (x=0; x<3; x++)
	for (y=0; y<3; y++)
	  mb_pixbuf_img_plot_pixel(Pixbuf, img_bg, x+ox+7, y+oy+1, 0, 0, 0); 
    }

  mb_pixbuf_img_render_to_drawable (Pixbuf, img_bg, drw, 0, 0);

  mb_pixbuf_img_free( Pixbuf, img_bg );
}

void
resize_callback ( MBTrayApp *app, int w, int h )
{
  ;
}

void
xevent_callback (MBTrayApp *app, XEvent *ev)
{
  Display *dpy;
  Window root;
  unsigned char map[6];
  
  int buts, rst;

  dpy = mb_tray_app_xdisplay(app);  
  root = RootWindow(dpy, DefaultScreen(dpy));

  /*
  if (ButtonGrabbed)
    {
      ButtonGrabbed = False;
      XAllowEvents(dpy, SyncPointer, CurrentTime);
      XUngrabPointer(dpy, CurrentTime);
      return;
    }
  */

  switch (ev->type) 
    {
    case KeyPress:
      if (ev->xkey.keycode != keycode && !keycode2) break;
      if ( (active_button_num != 1)
    	   && (ev->xkey.time - lasttime > dbl_click_time) )
        active_button_num = 1;
      else if ( (ev->xkey.keycode == keycode2)
	   || (!keycode2 && lasttime
	       && (ev->xkey.time - lasttime < dbl_click_time) ))
	active_button_num = 2;
      else
	active_button_num = 3;
      XAutoRepeatOff(dpy);
      lasttime = ev->xkey.time;
      break;
      
    case KeyRelease:
//      if ( (ev->xkey.keycode == keycode)
//	   || ( keycode2 && ev->xkey.keycode == keycode2) )
//	{
//	  active_button_num = 1;
	  XAutoRepeatOn(dpy);
//	}
      break;
      
    case ButtonPress:
      /*
      ButtonGrabbed = True;
      XGrabPointer(dpy, mb_tray_app_xwin(app), True, ButtonPressMask,
		   GrabModeSync, GrabModeSync, root, None, CurrentTime);
      */
      if (++active_button_num > 3) active_button_num = 1;
      break;
      
    }
  
  if (active_button_num != last_button_num)
    {
      buts = XGetPointerMapping(dpy, map, 5);
      
      switch (active_button_num)
	{
	case 1:
	  map[0] = (unsigned char) 1;
	  map[1] = (unsigned char) 2;
	  map[2] = (unsigned char) 3;
	  if (!cursor_disabled)
	    XDefineCursor(dpy, root, orig_curs);
	  break;
	case 2:
	  map[0] = (unsigned char) 2;
	  map[1] = (unsigned char) 3;
	  map[2] = (unsigned char) 1;
	  if (!cursor_disabled)
	    XDefineCursor(dpy, root, middle_curs);
	  break;
	case 3:
	  map[0] = (unsigned char) 3;
	  map[1] = (unsigned char) 2;
	  map[2] = (unsigned char) 1;
	  if (!cursor_disabled)
	    XDefineCursor(dpy, root, right_curs);
	  break;
	}
      mb_tray_app_repaint(app);
      while((rst = XSetPointerMapping(dpy, map, buts)) == MappingBusy);
      last_button_num = active_button_num;
    }
}

int main(int argc, char **argv)
{
  Display *dpy;
  Window root;
  int i;
   
  Pixmap icon, mask;
  XpmAttributes xpm_attr;	
  
  app = mb_tray_app_new ( "Mouse Tool",
			  resize_callback,
			  paint_callback,
			  &argc,
			   &argv );  

  if (!app) exit(1);

  dpy = mb_tray_app_xdisplay(app);
   
  for (i=1; argv[i]; i++) {
    char *arg = argv[i];
    if (*arg=='-') {
      switch (arg[1]) {
      case 'k' :
	keycode = get_keycode_from_str(argv[i+1]);
	i++;
	break;
      case 'm' :
	keycode2 = get_keycode_from_str(argv[i+1]);
	i++;
	break;
      case 't' :
	dbl_click_time = atoi(argv[i+1]);
	i++;
	break;
      case 'c' :
	cursor_disabled = True;
	i++;
	break;
      default:
	usage();
	exit(0);
	break;
      }
    }
  }
  
/* see http://tronche.com/gui/x/xlib/appendix/b/ for more cursors */
  right_curs  = XCreateFontCursor(dpy, XC_rightbutton);
  middle_curs = XCreateFontCursor(dpy, XC_middlebutton);    /* :) */
  orig_curs   = XCreateFontCursor(dpy, XC_left_ptr);
  
  Pixbuf = mb_pixbuf_new(mb_tray_app_xdisplay(app), 
			 mb_tray_app_xscreen(app));
  

  root = RootWindow(dpy, DefaultScreen(dpy));
      
  xpm_attr.valuemask = 0;
  if (XpmCreatePixmapFromData( dpy, root, xmonobut_xpm,
			       &icon, &mask, &xpm_attr) != XpmSuccess )
    {
      fprintf(stderr, "failed to get icon image\n");
      exit(1);
    }

  img_icon = mb_pixbuf_img_new_from_drawable(Pixbuf, icon, mask, 0, 0,
					     xpm_attr.width, 
					     xpm_attr.height);
  if (!img_icon)
    {
      fprintf(stderr, "failed to get icon image\n");
      exit(1);
    }
   
  if (keycode)
    {
      XGrabKey(dpy, keycode, 0, root, True, GrabModeAsync, GrabModeAsync);
      if (keycode2)
	XGrabKey(dpy, keycode2, 0, root, True, GrabModeAsync, GrabModeAsync);
      XSelectInput(dpy, root, KeyPressMask | KeyReleaseMask );
    }
  
  mb_tray_app_set_xevent_callback (app, xevent_callback );

   /* XXX set up dnotify to reload entrys only on _addition_  */

   mb_tray_app_main (app);

   if (keycode) XUngrabKey(dpy, keycode, AnyModifier, root);
   if (keycode2) XUngrabKey(dpy, keycode2, AnyModifier, root);
      
   XCloseDisplay(dpy);

   return 0;
}

   
