#!/bin/sh -e
#This script makes a DVD image from a file recorded with xdtv
# $Id: xdtv_makedvd.sh,v 1.1 2004/09/08 21:03:43 alainjj Exp $
#script under GNU General Public License (see COPYING)

#needs mplayer,mjpegtools,dvdauthor
#and the font arial.ttf in ~/.spumux/ for the subtitles

if [ $# != 2 ]; then
  echo usage: $0 avi_infile iso_outfile
  exit 1
fi

#CONFIG##################
FIC=$1
ISO=$2
DVDASPECT=4:3  #dvdauth-0.6.0 only accepts 4:3 or 16:9
RESIZEMPLAYER="" #looks OK for my reader, (for records WITHOUT blackborders)
#RESIZEMPLAYER="-vf scale=720:576" #for the standard size, need mplayer-1.0
#RESIZEMPLAYER="-vf crop=384:216,scale=720:576"
   #recording in 4:3/384x288 and DVDASPECT=16:9
DIR=/tmp/dvd$$
MPLAYER=mplayer
ALANG=fr
SLANG=fr
VBITRATE=800
ABITRATE=64; MONO=on
###########################

SCRIPT=$0
mkdir -p $DIR
expr $FIC : '/.*' || FIC=`pwd`/$FIC
expr $ISO : '/.*' || ISO=`pwd`/$ISO
expr $SCRIPT : '/.*' || SCRIPT=`pwd`/$SCRIPT
SUB=$(dirname $FIC)/$(basename $FIC .avi).sub
cd $DIR
rm -f stream.yuv audiodump.wav
mkfifo stream.yuv audiodump.wav

MOPTS="-noautosub -noaspect -noframedrop -vo yuv4mpeg -ao pcm -waveheader"
MOPTS="$MOPTS $FIC $RESIZEMPLAYER"
[ "$MONO" = on ] && MOPTS="$MOPTS -channels 1"
#MOPTS="$MOPTS -frames 100" #useful to test...
$MPLAYER $MOPTS &
PID1=$!

MP2ASPECT=1
[ "$DVDASPECT" = 4:3 ] && MP2ASPECT=2
[ "$DVDASPECT" = 16:9 ] && MP2ASPECT=3
MP2OPTS="-v 0 -f 8 -b $VBITRATE -a $MP2ASPECT"
mpeg2enc -o video.mpg $MP2OPTS < stream.yuv &
PID2=$!

MP2ENCOPTS="-b $ABITRATE"
[ "$MONO" = on ] && MP2ENCOPTS="$MP2ENCOPTS -m"
mp2enc $MP2ENCOPTS -o audio.mpg < audiodump.wav &
PID3=$!

wait $PID1
wait $PID2
wait $PID3

mplex -f 8 -o dvd.mpg audio.mpg video.mpg
rm -f stream.yuv audiodump.wav audio.mpg video.mpg

DVDAUTHOPTS="--video $DVDASPECT -a $ALANG+16bps"
[ "$MONO" = on ] && DVDAUTHOPTS="${DVDAUTHOPTS}+1ch"

#creation of the subtitles:
if [ -s $SUB ] && [ $(wc -l < $SUB) -gt 2 ]; then
   cat > script <<EOF
      <subpictures>
          <stream>
              <textsub filename="$SUB" characterset="ISO8859-1" horizontal-alignment="center" font="arial.ttf"
             />
           </stream>
       </subpictures>
EOF
   mv dvd.mpg dvd_sanssub.mpg
   spumux script < dvd_sanssub.mpg > dvd.mpg
   DVDAUTHOPTS="$DVDAUTHOPTS -s $SLANG"
fi

#creation of dvd directory
dvddirdel -o DVD
dvdauthor $DVDAUTHOPTS -o DVD dvd.mpg
dvdauthor -T -o DVD

#saving the script, and the text subtitles in the iso image
mkdir -p DVD/ZZ; cp -f $SCRIPT DVD/ZZ
[ -f $SUB ] && cp -f $SUB DVD/ZZ

mkisofs -dvd-video -o $ISO DVD
rm -rf $DIR

echo "The image $ISO is done."
echo "to test: mplayer -v -dvd-device $ISO dvd://1"
echo "to record on a disk: cdrecord -v dev=0,0 $ISO"
