/*****************************************************************************
 * xfile.h: for file selector: management of X files
 *****************************************************************************
 * $Id: xfile.h,v 1.1 2004/08/07 23:00:10 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 * Copyright (C) by Nobuyuki Maruichi
 * From mwxcd 1.32
 *
 * Version1.0	for Sony-NEWS	(NEWS-OS Release3.3a:UNIX 4.3BSD/X11R3)
 *              Copyright1991	Arakawa Laboratry(Nobuyuki Maruichi)
 * Version1.1	for FM TOWNS II	(TOWNS Linux 0.973:Linux/X11R5)
 *				Copyright1993	Nobuyuki Maruichi
 *
 *				Date 1992/4/15 (Wed.)--1992/4/18(Sat.)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

#ifndef	XFILE_H
#define	XFILE_H

typedef struct _FileInfo {
	char *size_kb;
	char *attr;
	char *link;
	char *user;
	char *size;
	char *date;
	char *filename;
	struct stat stat_buf;
} FileInfo;

typedef struct _FileLink {
	FileInfo *pos;
	struct _FileLink *next;
} FileLink;


typedef struct _DirInfo {
	char *searchingPath;
	char **nameList;
	FileInfo **infoList;
	FileLink *linkedInfo;
	Widget dirWidget;
	Widget fileWidget;
	Widget listWidget;
} FileSelctorInfo;

void fileListSelect(Widget w, XtPointer client_data, XtPointer call_data);
void remakeFileSelector(FileSelctorInfo *infomation);
void remakeFilePickup(FileSelctorInfo *infomation);
int ismeta(const char *meta, const char *name);

int ascii_comp(const void *file1, const void *file2);
int suffix_comp(const void *file1, const void *file2);
int date_comp(const void *file1, const void *file2);
int size_comp(const void *file1, const void *file2);

#endif	/* XFILE_H */
