/*****************************************************************************
 *  http.c : http server/client communicating video between two xdtv programs
 *****************************************************************************
 * $Id: http.c,v 1.7 2004/02/14 23:11:45 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2004 Alainjj
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "config.h"
#include "divx.h"
#include "avilib.h"
#include "http.h"
#include "commands.h"
#include "channel.h"
#include "strtab.h"
#include "grab.h"
extern divx_t divx;
extern int debug;
void set_channel (struct CHANNEL *);
void set_norm (int);
void set_source (int);
extern struct GRABBER *grabbers[];
extern int grabber;

#define HEADERBYTES 2048

/**************** SERVER PART ********************/
static int socket_server = -1, sockets_clients[]={-1,-1,-1,-1,-2};
static unsigned char header[HEADERBYTES];

int http_init_server(avi_t *avi) {
  struct sockaddr_in addr;
  int on=1;
  socket_server=socket(AF_INET,SOCK_STREAM,0); 
  if(socket_server<0) {
    perror("socket");
    return -1;
  }
  setsockopt(socket_server, SOL_SOCKET, SO_REUSEADDR, &on,sizeof(on));
  addr.sin_family=AF_INET;
  addr.sin_port=htons(divx.http_port);
  addr.sin_addr.s_addr=htonl(INADDR_ANY);
  if(bind(socket_server,(struct sockaddr *) (&addr),sizeof(addr))<0) {
    perror("bind");
    return -1;
  }
  if(listen(socket_server,5)<0) {
    perror("listen");
    return -1;
  }
  AVI_get_header(avi,header);

  return 0;
}
  
static void removeclient(int i) {
  int s=sockets_clients[i];
  sockets_clients[i]=-1;
  close(s);
}

static int read_until_doubleret(int fd) {
  char buf[4]="\0\0\0\0";
  int i,r;
  if(debug) fprintf(stderr,"##doubleret=@@@");
  while(buf[0]!='\r'|| buf[1]!='\n'||buf[2]!='\r'||buf[3]!='\n') {
    for(i=0;i<3;i++) buf[i]=buf[i+1];
    r=read(fd,&buf[3],1);
    if(r<0) {perror("doubleret read"); return -1;}
    if(r==0) {fprintf(stderr,"connection lost\n"); return -1;}
    if(debug) putc(buf[3],stderr);
  }
  if(debug) fprintf(stderr,"@@@\n");
  return 0;
}

static void addclient(void) {
  int i,r,s;
  s=accept(socket_server,NULL,0);
  if(s<0) {perror("accept"); return;}
  for(i=0;sockets_clients[i]!=-2 &&sockets_clients[i]!=-1 ;i++);
  if(sockets_clients[i]==-2) {
    fprintf(stderr,"Too many clients\n");
    close(s);
    return;
  }
  if(read_until_doubleret(s)<0) {close(s);return;}
  r=write(s,"HTTP/1.0 200 OK\r\n\r\n",19);
  if(r<0) {perror("write"); close(s);return;}
  r=write(s,header,HEADERBYTES);
  if(r<0) {perror("write"); close(s);return;}
  if(debug) fprintf(stderr,"client %d correctly initialized\n",i);
  divx_restart();
  sockets_clients[i]=s;
}


void http_close_server(void) {
  int i,s;
  if(socket_server<0) return;
  for(i=0;sockets_clients[i]!=-2;i++)
    if(sockets_clients[i]!=-1) {
      sockets_clients[i]=-1;
      s=sockets_clients[i];
      close(s);
    }
  s=socket_server;
  close(s);
  socket_server=-1;
}

int http_send_data(void * data, int ldata) {
  int i;
  /** should be done in parallel !!!!!!! */
  for(i=0;sockets_clients[i]!=-2;i++)
    if(sockets_clients[i]!=-1) {
      int r=0,r2=1;
      while(r<ldata) {
	r2 = write(sockets_clients[i], data+r, ldata-r);
	if(r2<0) { perror("write"); removeclient(i); break;}
	r+=r2;
      }
    }
  return ldata;
}

void http_read_clients(void) {
  char buf[101];
  fd_set rfds;
  struct timeval tv;
  int i,r,maxfds=-1;
  tv.tv_sec = 0;
  tv.tv_usec = 0;
  FD_ZERO(&rfds);
  FD_SET(socket_server,&rfds);maxfds=socket_server;
  for(i=0;sockets_clients[i]!=-2;i++)
    if(sockets_clients[i]!=-1) {
      FD_SET(sockets_clients[i],&rfds);
      if(maxfds<sockets_clients[i]) maxfds=sockets_clients[i];
    }
  r=select(maxfds+1,&rfds, NULL, NULL, &tv);
  if(r<0) perror("select");
  if(FD_ISSET(socket_server,&rfds)) {
    if(debug) fprintf(stderr,"new client\n");
    addclient();
  }
  for(i=0;sockets_clients[i]!=-2;i++)
    if(sockets_clients[i]!=-1 && FD_ISSET(sockets_clients[i],&rfds)) {
      char *buf2;
      int k;
      r=read(sockets_clients[i],buf,100);
      if(r<0) {perror("read"); removeclient(i);}
      if(!divx.chg) continue;
      buf[r]='\0'; buf2=buf;
      if(debug) fprintf(stderr,"\nreceived %d bytes\n",r);
      while(buf2<buf+r) {
	if(debug) fprintf(stderr,"received=@@%s@@\n",buf2);
	if(strncmp(buf2,"freq ",5)==0) {
	  int f;
	  f=atoi(buf2+5);
	  grabbers[grabber]->grab_tune(f);
	  cur_freq=f;
	} else if(strncmp(buf2,"input ",6)==0) {
	  int i=str_to_int(buf2+6,grabbers[grabber]->inputs);
	  if(i==-1)
	    fprintf(stderr,"unknown input (%s)\n",buf2+6);
	  else 
	    set_source(i);
	} else if(strncmp(buf2,"norm ",5)==0) {
	  int n=str_to_int(buf2+5,grabbers[grabber]->norms);
	  if(n==-1)
	    fprintf(stderr,"unknown norm (%s)\n",buf2+5);
	  else {
	    set_norm(n);
	  }
	}
	buf2=buf2+strlen(buf2)+1;
      }
      for (k = 0; k < count; k++)
	if (channels[k]->freq==cur_freq && 
	    channels[k]->norm==cur_norm &&
	    channels[k]->source==cur_input) {
	  if(k != cur_sender) {
	    cur_sender=k;
	    set_channel(channels[k]);
	    if(debug)
	      fprintf(stderr,"matched channel=%s\n",channels[k]->name);
	  }
	  break;
	}
      if(k==count) {
	cur_sender=-1;
	fprintf(stderr, "http warning: change to unknown channel !\n");
      }
    }
}

/************** CLIENT PART ********************/
int http_open(char* url) {
  int i,port=80,l,i2,s,host;
  char *hostname,*file=""; 
  struct hostent *he;
  struct sockaddr_in addr;
  char buf[100];
  l=strlen(url);
  if(strncmp(url,"http://",7)!=0) return -1;
  hostname=url+7;
  i2=l;
  for(i=7;i<l;i++) 
    if(url[i]=='/') {
      file=&url[i+1];
      url[i]='\0'; 
      i2=i;
      break;
    }
  for(i=7;i<i2;i++) {
    if(url[i]==':') {
      url[i]='\0';
      port=atoi(&url[i]+1);
      break;
    }
  }
  if(debug)
    fprintf(stderr,"hostname=%s file=%s port=%d\n",hostname,file,port);
  he=gethostbyname(hostname);
  if(he==NULL) {herror("gethostbyname"); return -1;}
  memcpy(&host,he->h_addr,sizeof(host));
  addr.sin_family=AF_INET;
  addr.sin_port=htons(port);
  addr.sin_addr.s_addr=host;
  s=socket(AF_INET,SOCK_STREAM,0); 
  if(s<0) {perror("socket"); return -1;}
  if(connect(s,(struct sockaddr *)&addr,sizeof(addr))<0)
    {perror("connect");close(s);return -1;}
  sprintf(buf,"GET /%s HTTP/1.0\r\n\r\n",file);
  if(write(s,buf,strlen(buf))<0) {perror("write"); close(s); return -1;}
  if(read_until_doubleret(s)<0) {close(s); return -1;}
  return s;
}
