/*****************************************************************************
 * frequencies.c: frequencies TV table
 *****************************************************************************
 * $Id: frequencies.c,v 1.8 2004/12/07 20:55:04 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Keuleu
 * Thu 06 Nov 2003 10:50:41 AM EET - Lucian Langa <cooly@eweb.ro>
 *	Added SR1-SR8, SR11-SR18 channels for east-europe freq table
 * Wed 10 Dec 2003 04:00:49 PM EET - cooly
 *	Added secam-russia tab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/



#include <stdlib.h>
#include "strtab.h"
#include "channels.h"

struct STRTAB chan_names[] = {
  {0, "ntsc-us-bcast"},
  {1, "ntsc-us-cable"},
  {2, "ntsc-japan-bcast"},
  {3, "ntsc-japan-cable"},
  {4, "secam-france"},
  {5, "secam-russia"},
  {6, "pal-europe-west"},
  {7, "pal-europe-east"},
  {8, "pal-italy"},
  {9, "pal-newzealand"},
  {10, "pal-australia"},
  {11, "pal-ireland"},
  {12, "pal-argentina"},
  {13, "pal-china-bcast"},
  {14, "pal-southafrica"},
  {15, "pal-australia-optus"},
  {16, "ntsc-cable-hrc"},
  {-1, NULL}
};


/* ------------------------------------------------------------------------- */
/* moved here from channels.h                                                */

struct freqlist tvtuner[] = {
  {"NOTACHANNEL", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E2", {0, 0, 0, 0, 48250, 0, 48250, 48250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E3", {0, 0, 0, 0, 55250, 0, 55250, 55250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E4", {0, 0, 0, 0, 62250, 0, 62250, 62250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S01", {0, 0, 0, 0, 0, 0, 69250, 69250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S02", {0, 0, 0, 0, 0, 0, 76250, 76250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S03", {0, 0, 0, 0, 0, 0, 83250, 83250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R1", {0, 0, 0, 0, 0, 49750, 0, 49750, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R2", {0, 0, 0, 0, 0, 59250, 0, 59250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R3", {0, 0, 0, 0, 0, 77250, 0, 77250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R4", {0, 0, 0, 0, 0, 85250, 0, 84250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R5", {0, 0, 0, 0, 0, 93250, 0, 93250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE1", {0, 0, 0, 0, 105250, 0, 105250, 105250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE2", {0, 0, 0, 0, 112250, 0, 112250, 112250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE3", {0, 0, 0, 0, 119250, 0, 119250, 119250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE4", {0, 0, 0, 0, 126250, 0, 126250, 126250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE5", {0, 0, 0, 0, 133250, 0, 133250, 133250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE6", {0, 0, 0, 0, 140250, 0, 140250, 140250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE7", {0, 0, 0, 0, 147250, 0, 147250, 147250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE8", {0, 0, 0, 0, 154250, 0, 154250, 154250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE9", {0, 0, 0, 0, 161250, 0, 161250, 161250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE10", {0, 0, 0, 0, 168250, 0, 168250, 168250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E5", {0, 0, 0, 0, 175250, 0, 175250, 175250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E6", {0, 0, 0, 0, 182250, 0, 182250, 182250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E7", {0, 0, 0, 0, 189250, 0, 189250, 189250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E8", {0, 0, 0, 0, 196250, 0, 196250, 196250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E9", {0, 0, 0, 0, 203250, 0, 203250, 203250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E10", {0, 0, 0, 0, 210250, 0, 210250, 210250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E11", {0, 0, 0, 0, 217250, 0, 217250, 217250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E12", {0, 0, 0, 0, 224250, 0, 224250, 224250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R6", {0, 0, 0, 0, 0, 175250, 0, 175250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R7", {0, 0, 0, 0, 0, 183250, 0, 183250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R8", {0, 0, 0, 0, 0, 191250, 0, 191250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R9", {0, 0, 0, 0, 0, 199250, 0, 199250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R10", {0, 0, 0, 0, 0, 207250, 0, 207250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R11", {0, 0, 0, 0, 0, 215250, 0, 215250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"R12", {0, 0, 0, 0, 0, 223250, 0, 223250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE11", {0, 0, 0, 0, 231250, 0, 231250, 231250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE12", {0, 0, 0, 0, 238250, 0, 238250, 238250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE13", {0, 0, 0, 0, 245250, 0, 245250, 245250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE14", {0, 0, 0, 0, 252250, 0, 252250, 252250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE15", {0, 0, 0, 0, 259250, 0, 259250, 259250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE16", {0, 0, 0, 0, 266250, 0, 266250, 266250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE17", {0, 0, 0, 0, 273250, 0, 273250, 273250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE18", {0, 0, 0, 0, 280250, 0, 280250, 280250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE19", {0, 0, 0, 0, 287250, 0, 287250, 287250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SE20", {0, 0, 0, 0, 294250, 0, 294250, 294250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR1", {0, 0, 0, 0, 0, 111250, 0, 111250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR2", {0, 0, 0, 0, 0, 119250, 0, 119250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR3", {0, 0, 0, 0, 0, 127250, 0, 127250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR4", {0, 0, 0, 0, 0, 135250, 0, 135250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR5", {0, 0, 0, 0, 0, 143250, 0, 143250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR6", {0, 0, 0, 0, 0, 151250, 0, 151250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR7", {0, 0, 0, 0, 0, 159250, 0, 159250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR8", {0, 0, 0, 0, 0, 167250, 0, 167250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR11", {0, 0, 0, 0, 0, 231250, 0, 231250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR12", {0, 0, 0, 0, 0, 239250, 0, 239250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR13", {0, 0, 0, 0, 0, 247250, 0, 247250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR14", {0, 0, 0, 0, 0, 255250, 0, 255250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR15", {0, 0, 0, 0, 0, 263250, 0, 263250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR16", {0, 0, 0, 0, 0, 271250, 0, 271250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR17", {0, 0, 0, 0, 0, 279250, 0, 279250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"SR18", {0, 0, 0, 0, 0, 287259, 0, 287250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S19", {0, 0, 0, 0, 0, 295250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S20", {0, 0, 0, 0, 0, 303250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S21", {0, 0, 0, 0, 303250, 311250, 303250, 303250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S22", {0, 0, 0, 0, 311250, 319250, 311250, 311250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S23", {0, 0, 0, 0, 319250, 327250, 319250, 319250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S24", {0, 0, 0, 0, 327250, 335250, 327250, 327250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S25", {0, 0, 0, 0, 335250, 343250, 335250, 335250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S26", {0, 0, 0, 0, 343250, 351250, 343250, 343250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S27", {0, 0, 0, 0, 351250, 359250, 351250, 351250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S28", {0, 0, 0, 0, 359250, 367250, 359250, 359250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S29", {0, 0, 0, 0, 367250, 375250, 367250, 367250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S30", {0, 0, 0, 0, 375250, 383250, 375250, 375250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S31", {0, 0, 0, 0, 383250, 391250, 383250, 383250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S32", {0, 0, 0, 0, 391250, 399250, 391250, 391250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S33", {0, 0, 0, 0, 399250, 407250, 399250, 399250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S34", {0, 0, 0, 0, 407250, 415250, 407250, 407250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S35", {0, 0, 0, 0, 415250, 423250, 415250, 415250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S36", {0, 0, 0, 0, 423250, 431250, 423250, 423250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S37", {0, 0, 0, 0, 431250, 439250, 431250, 431250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S38", {0, 0, 0, 0, 439250, 447250, 439250, 439250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S39", {0, 0, 0, 0, 447250, 455250, 447250, 447250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S40", {0, 0, 0, 0, 455250, 463250, 455250, 455250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"S41", {0, 0, 0, 0, 463250, 0, 463250, 463250, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K01", {0, 0, 0, 0, 47750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K02", {0, 0, 0, 0, 55750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K03", {0, 0, 0, 0, 60500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K04", {0, 0, 0, 0, 63750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K05", {0, 0, 0, 0, 176000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K06", {0, 0, 0, 0, 184000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K07", {0, 0, 0, 0, 192000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K08", {0, 0, 0, 0, 200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K09", {0, 0, 0, 0, 208000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"K10", {0, 0, 0, 0, 216000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KB", {0, 0, 0, 0, 116750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KC", {0, 0, 0, 0, 128750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KD", {0, 0, 0, 0, 140750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KE", {0, 0, 0, 0, 159750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KF", {0, 0, 0, 0, 164750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KG", {0, 0, 0, 0, 176750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KH", {0, 0, 0, 0, 188750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KI", {0, 0, 0, 0, 200750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KJ", {0, 0, 0, 0, 212750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KK", {0, 0, 0, 0, 224750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KL", {0, 0, 0, 0, 236750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KM", {0, 0, 0, 0, 248750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KN", {0, 0, 0, 0, 260750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KO", {0, 0, 0, 0, 272750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KP", {0, 0, 0, 0, 284750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"KQ", {0, 0, 0, 0, 296750, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H01", {0, 0, 0, 0, 303250, 0, 0, 0, 217250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H02", {0, 0, 0, 0, 311250, 0, 0, 0, 224250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H03", {0, 0, 0, 0, 319250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H04", {0, 0, 0, 0, 327250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H05", {0, 0, 0, 0, 335250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H06", {0, 0, 0, 0, 343250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H07", {0, 0, 0, 0, 351250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H08", {0, 0, 0, 0, 359250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H09", {0, 0, 0, 0, 367250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H10", {0, 0, 0, 0, 375250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H11", {0, 0, 0, 0, 383250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H12", {0, 0, 0, 0, 391250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H13", {0, 0, 0, 0, 399250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H14", {0, 0, 0, 0, 407250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H15", {0, 0, 0, 0, 415250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H16", {0, 0, 0, 0, 423250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H17", {0, 0, 0, 0, 431250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H18", {0, 0, 0, 0, 439250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H19", {0, 0, 0, 0, 447250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"0", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46250, 0, 0, 0, 0, 0, 0}},
  {"1", {0, 73250, 91250, 0, 0, 0, 0, 0, 0, 45250, 57250, 0, 56250, 49750, 175250, 138250, 72000}},
  {"2", {55250, 55250, 97250, 0, 0, 0, 0, 0, 0, 55250, 64250, 0, 62250, 57750, 183250, 147250, 54000}},
  {"3", {61250, 61250, 103250, 0, 0, 0, 0, 0, 0, 62250, 86250, 0, 68250, 65750, 191250, 154250, 60000}},
  {"4", {67250, 67250, 171250, 0, 0, 0, 0, 0, 0, 175250, 95250, 0, 78250, 77250, 199250, 161250, 66000}},
  {"5", {77250, 77250, 177250, 0, 0, 0, 0, 0, 0, 182250, 102250, 0, 84250, 85250, 207250, 168250, 78000}},
  {"5A", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138250, 0, 0, 0, 0, 0, 0}},
  {"6", {83250, 83250, 183250, 0, 0, 0, 0, 0, 0, 189250, 175250, 0, 176250, 168250, 215250, 175250, 84000}},
  {"7", {175250, 175250, 189250, 0, 0, 0, 0, 0, 0, 196250, 182250, 0, 182250, 176250, 223250, 182250, 174000}},
  {"8", {181250, 181250, 193250, 0, 0, 0, 0, 0, 0, 203250, 189250, 0, 188250, 184250, 231250, 189250, 180000}},
  {"9", {187250, 187250, 199250, 0, 0, 0, 0, 0, 0, 210250, 196250, 0, 194250, 192250, 239250, 196250, 186000}},
  {"10", {193250, 193250, 205250, 0, 0, 0, 0, 0, 0, 217250, 209250, 0, 200250, 200250, 247250, 209250, 192000}},
  {"11", {199250, 199250, 211250, 0, 0, 0, 0, 0, 0, 224250, 216250, 0, 206250, 208250, 255250, 216250, 198000}},
  {"12", {205250, 205250, 217250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212250, 216250, 263250, 224250, 204000}},
  {"13", {211250, 211250, 471250, 109250, 0, 0, 0, 0, 0, 0, 0, 0, 122250, 471250, 271250, 231250, 210000}},
  {"14", {471250, 121250, 477250, 115250, 0, 0, 0, 0, 0, 0, 0, 0, 128250, 479250, 0, 238250, 120000}},
  {"15", {477250, 127250, 483250, 121250, 0, 0, 0, 0, 0, 0, 0, 0, 134250, 487250, 0, 245250, 126000}},
  {"16", {483250, 133250, 489250, 127250, 0, 0, 0, 0, 0, 0, 0, 0, 140250, 495250, 0, 252250, 132000}},
  {"17", {489250, 139250, 495250, 133250, 0, 0, 0, 0, 0, 0, 0, 0, 146250, 503250, 0, 259250, 138000}},
  {"18", {495250, 145250, 501250, 139250, 0, 0, 0, 0, 0, 0, 0, 0, 152250, 511250, 0, 266250, 144000}},
  {"19", {501250, 151250, 507250, 145250, 0, 0, 0, 0, 0, 0, 0, 0, 158250, 519250, 0, 273250, 150000}},
  {"20", {507250, 157250, 513250, 151250, 0, 0, 0, 0, 0, 0, 0, 0, 164250, 527250, 0, 280250, 156000}},
  {"21", {513250, 163250, 519250, 157250, 471250, 471250, 471250, 471250, 471250, 471250, 0, 471250, 170250, 535250, 471250, 287250, 162000}},
  {"22", {519250, 169250, 525250, 165250, 479250, 479250, 479250, 479250, 479250, 479250, 0, 479250, 218250, 543250, 479250, 294250, 168000}},
  {"23", {525250, 217250, 531250, 223250, 487250, 487250, 487250, 487250, 487250, 487250, 0, 487250, 224250, 551250, 487250, 303250, 216000}},
  {"24", {531250, 223250, 537250, 231250, 495250, 495250, 495250, 495250, 495250, 495250, 0, 495250, 230250, 559250, 495250, 310250, 222000}},
  {"25", {537250, 229250, 543250, 237250, 503250, 503250, 503250, 503250, 503250, 503250, 0, 503250, 236250, 607250, 503250, 317250, 228000}},
  {"26", {543250, 235250, 549250, 243250, 511250, 511250, 511250, 511250, 511250, 511250, 0, 511250, 242250, 615250, 511250, 324250, 234000}},
  {"27", {549250, 241250, 555250, 249250, 519250, 519250, 519250, 519250, 519250, 519250, 0, 519250, 248250, 623250, 519250, 338250, 240000}},
  {"28", {555250, 247250, 561250, 253250, 527250, 527250, 527250, 527250, 527250, 527250, 527250, 527250, 254250, 631250, 527250, 345250, 246000}},
  {"29", {561250, 253250, 567250, 259250, 535250, 535250, 535250, 535250, 535250, 535250, 534250, 535250, 260250, 639250, 535250, 352250, 252000}},
  {"30", {567250, 259250, 573250, 265250, 543250, 543250, 543250, 543250, 543250, 543250, 541250, 543250, 266250, 647250, 543250, 359250, 258000}},
  {"31", {573250, 265250, 579250, 271250, 551250, 551250, 551250, 551250, 551250, 551250, 548250, 551250, 272250, 655250, 551250, 366250, 264000}},
  {"32", {579250, 271250, 585250, 277250, 559250, 559250, 559250, 559250, 559250, 559250, 555250, 559250, 278250, 663250, 559250, 373250, 270000}},
  {"33", {585250, 277250, 591250, 283250, 567250, 567250, 567250, 567250, 567250, 567250, 562250, 567250, 284250, 671250, 567250, 380250, 276000}},
  {"34", {591250, 283250, 597250, 289250, 575250, 575250, 575250, 575250, 575250, 575250, 569250, 575250, 290250, 679250, 575250, 387250, 282000}},
  {"35", {597250, 289250, 603250, 295250, 583250, 583250, 583250, 583250, 583250, 583250, 576250, 583250, 296250, 687250, 583250, 394250, 288000}},
  {"36", {603250, 295250, 609250, 301250, 591250, 591250, 591250, 591250, 591250, 591250, 583250, 591250, 302250, 695250, 591250, 401250, 294000}},
  {"37", {609250, 301250, 615250, 307250, 599250, 599250, 599250, 599250, 599250, 599250, 590250, 599250, 308250, 703250, 599250, 408250, 300000}},
  {"38", {615250, 307250, 621250, 313250, 607250, 607250, 607250, 607250, 607250, 607250, 597250, 607250, 314250, 711250, 607250, 415250, 306000}},
  {"39", {621250, 313250, 627250, 319250, 615250, 615250, 615250, 615250, 615250, 615250, 604250, 615250, 320250, 719250, 615250, 422250, 312000}},
  {"40", {627250, 319250, 633250, 325250, 623250, 623250, 623250, 623250, 623250, 623250, 611250, 623250, 326250, 727250, 623250, 429250, 318000}},
  {"41", {633250, 325250, 639250, 331250, 631250, 631250, 631250, 631250, 631250, 631250, 618250, 631250, 332250, 735250, 631250, 436250, 324000}},
  {"42", {639250, 331250, 645250, 337250, 639250, 639250, 639250, 639250, 639250, 639250, 625250, 639250, 338250, 743250, 639250, 443250, 330000}},
  {"43", {645250, 337250, 651250, 343250, 647250, 647250, 647250, 647250, 647250, 647250, 632250, 647250, 344250, 751250, 647250, 450250, 336000}},
  {"44", {651250, 343250, 657250, 349250, 655250, 655250, 655250, 655250, 655250, 655250, 639250, 655250, 350250, 759250, 655250, 457250, 342000}},
  {"45", {657250, 349250, 663250, 355250, 663250, 663250, 663250, 663250, 663250, 663250, 646250, 663250, 356250, 767250, 663250, 464250, 348000}},
  {"46", {663250, 355250, 669250, 361250, 671250, 671250, 671250, 671250, 671250, 671250, 653250, 671250, 362250, 775250, 671250, 471250, 354000}},
  {"47", {669250, 361250, 675250, 367250, 679250, 679250, 679250, 679250, 679250, 679250, 660250, 679250, 368250, 783250, 679250, 478250, 360000}},
  {"48", {675250, 367250, 681250, 373250, 687250, 687250, 687250, 687250, 687250, 687250, 667250, 687250, 374250, 791250, 687250, 485250, 366000}},
  {"49", {681250, 373250, 687250, 379250, 695250, 695250, 695250, 695250, 695250, 695250, 674250, 695250, 380250, 799250, 695250, 0, 372000}},
  {"50", {687250, 379250, 693250, 385250, 703250, 703250, 703250, 703250, 703250, 703250, 681250, 703250, 386250, 807250, 703250, 0, 378000}},
  {"51", {693250, 385250, 699250, 391250, 711250, 711250, 711250, 711250, 711250, 711250, 688250, 711250, 392250, 815250, 711250, 0, 384000}},
  {"52", {699250, 391250, 705250, 397250, 719250, 719250, 719250, 719250, 719250, 719250, 695250, 719250, 398250, 823250, 719250, 0, 390000}},
  {"53", {705250, 397250, 711250, 403250, 727250, 727250, 727250, 727250, 727250, 727250, 702250, 727250, 404250, 831250, 727250, 0, 396000}},
  {"54", {711250, 403250, 717250, 409250, 735250, 735250, 735250, 735250, 735250, 735250, 709250, 735250, 410250, 839250, 735250, 0, 402000}},
  {"55", {717250, 409250, 723250, 415250, 743250, 743250, 743250, 743250, 743250, 743250, 716250, 743250, 416250, 847250, 743250, 0, 408000}},
  {"56", {723250, 415250, 729250, 421250, 751250, 751250, 751250, 751250, 751250, 751250, 723250, 751250, 422250, 855250, 751250, 0, 414000}},
  {"57", {729250, 421250, 735250, 427250, 759250, 759250, 759250, 759250, 759250, 759250, 730250, 759250, 428250, 863250, 759250, 0, 420000}},
  {"58", {735250, 427250, 741250, 433250, 767250, 767250, 767250, 767250, 767250, 767250, 737250, 767250, 434250, 871250, 767250, 0, 426000}},
  {"59", {741250, 433250, 747250, 439250, 775250, 775250, 775250, 775250, 775250, 775250, 744250, 775250, 440250, 879250, 775250, 0, 432000}},
  {"60", {747250, 439250, 753250, 445250, 783250, 783250, 783250, 783250, 783250, 783250, 751250, 783250, 446250, 887250, 783250, 0, 438000}},
  {"61", {753250, 445250, 759250, 451250, 791250, 791250, 791250, 791250, 791250, 791250, 758250, 791250, 452250, 895250, 791250, 0, 444000}},
  {"62", {759250, 451250, 765250, 457250, 799250, 799250, 799250, 799250, 799250, 799250, 765250, 799250, 458250, 903250, 799250, 0, 450000}},
  {"63", {765250, 457250, 0, 463250, 807250, 807250, 807250, 807250, 807250, 807250, 772250, 807250, 464250, 911250, 807250, 0, 456000}},
  {"64", {771250, 463250, 0, 0, 815250, 815250, 815250, 815250, 815250, 815250, 779250, 815250, 470250, 919250, 815250, 0, 462000}},
  {"65", {777250, 469250, 0, 0, 823250, 823250, 823250, 823250, 823250, 823250, 786250, 823250, 476250, 927250, 823250, 0, 468000}},
  {"66", {783250, 475250, 0, 0, 831250, 831250, 831250, 831250, 831250, 831250, 793250, 831250, 482250, 935250, 831250, 0, 474000}},
  {"67", {789250, 481250, 0, 0, 839250, 839250, 839250, 839250, 839250, 839250, 800250, 839250, 488250, 943250, 839250, 0, 480000}},
  {"68", {795250, 487250, 0, 0, 847250, 847250, 847250, 847250, 847250, 847250, 807250, 847250, 494250, 951250, 847250, 0, 486000}},
  {"69", {801250, 493250, 0, 0, 855250, 855250, 855250, 855250, 855250, 855250, 814250, 855250, 500250, 0, 855250, 0, 492000}},
  {"70", {807250, 499250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 506250, 0, 0, 0, 498000}},
  {"71", {813250, 505250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512250, 0, 0, 0, 504000}},
  {"72", {819250, 511250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 518250, 0, 0, 0, 510000}},
  {"73", {825250, 517250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524250, 0, 0, 0, 516000}},
  {"74", {831250, 523250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 530250, 0, 0, 0, 522000}},
  {"75", {837250, 529250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 536250, 0, 0, 0, 528000}},
  {"76", {843250, 535250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 542250, 0, 0, 0, 534000}},
  {"77", {849250, 541250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 548250, 0, 0, 0, 540000}},
  {"78", {855250, 547250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 554250, 0, 0, 0, 546000}},
  {"79", {861250, 553250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 560250, 0, 0, 0, 552000}},
  {"80", {867250, 559250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 566250, 0, 0, 0, 558000}},
  {"81", {873250, 565250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 572250, 0, 0, 0, 564000}},
  {"82", {879250, 571250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 578250, 0, 0, 0, 570000}},
  {"83", {885250, 577250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 584250, 0, 0, 0, 576000}},
  {"84", {0, 583250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 590250, 0, 0, 0, 582000}},
  {"85", {0, 589250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 596250, 0, 0, 0, 588000}},
  {"86", {0, 595250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 602250, 0, 0, 0, 594000}},
  {"87", {0, 601250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 608250, 0, 0, 0, 600000}},
  {"88", {0, 607250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 614250, 0, 0, 0, 606000}},
  {"89", {0, 613250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 620250, 0, 0, 0, 612000}},
  {"90", {0, 619250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 626250, 0, 0, 0, 618000}},
  {"91", {0, 625250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 632250, 0, 0, 0, 624000}},
  {"92", {0, 631250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 638250, 0, 0, 0, 630000}},
  {"93", {0, 637250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 644250, 0, 0, 0, 636000}},
  {"94", {0, 643250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 642000}},
  {"95", {0, 91250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 900000}},
  {"96", {0, 97250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 960000}},
  {"97", {0, 103250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102000}},
  {"98", {0, 109250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108000}},
  {"99", {0, 115250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114000}},
  {"100", {0, 649250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 648000}},
  {"101", {0, 655250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 654000}},
  {"102", {0, 661250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 660000}},
  {"103", {0, 667250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 666000}},
  {"104", {0, 673250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 672000}},
  {"105", {0, 679250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 678000}},
  {"106", {0, 685250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 684000}},
  {"107", {0, 691250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 690000}},
  {"108", {0, 697250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 696000}},
  {"109", {0, 703250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 702000}},
  {"110", {0, 709250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 708000}},
  {"111", {0, 715250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 714000}},
  {"112", {0, 721250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720000}},
  {"113", {0, 727250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 726000}},
  {"114", {0, 733250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 732000}},
  {"115", {0, 739250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 738000}},
  {"116", {0, 745250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 744000}},
  {"117", {0, 751250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 750000}},
  {"118", {0, 757250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 756000}},
  {"119", {0, 763250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 762000}},
  {"120", {0, 769250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 768000}},
  {"121", {0, 775250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 774000}},
  {"122", {0, 781250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 780000}},
  {"123", {0, 787250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 786000}},
  {"124", {0, 793250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 792000}},
  {"125", {0, 799250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 798000}},
  {"T7", {0, 8250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000}},
  {"T8", {0, 14250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13000}},
  {"T9", {0, 20250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19000}},
  {"T10", {0, 26250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25000}},
  {"T11", {0, 32250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31000}},
  {"T12", {0, 38250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37000}},
  {"T13", {0, 44250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43000}}, 
  {"T14", {0, 50250, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49000}}, 
  {"A0", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45750, 0, 112250, 0, 0, 0}},
  {"A1", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48000, 0, 112250, 0, 0, 0}},
  {"A2", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53750, 0, 120250, 0, 0, 0}},
  {"A3", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56000, 0, 128250, 0, 0, 0}},
  {"A4", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61750, 0, 136250, 0, 0, 0}},
  {"A5", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64000, 0, 144250, 0, 0, 0}},
  {"A6", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175250, 0, 152250, 0, 0, 0}},
  {"A7", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176000, 0, 160250, 0, 0, 0}},
  {"A8", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183250, 0, 0, 0, 0, 0}},
  {"A9", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184000, 0, 0, 0, 0, 0}},
  {"A10", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191250, 0, 0, 0, 0, 0}},
  {"A11", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192000, 0, 0, 0, 0, 0}},
  {"A12", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199250, 0, 0, 0, 0, 0}},
  {"A13", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200000, 0, 0, 0, 0, 0}},
  {"A14", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207250, 0, 0, 0, 0, 0}},
  {"A15", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208000, 0, 0, 0, 0, 0}},
  {"A16", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215250, 0, 0, 0, 0, 0}},
  {"A17", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216000, 0, 0, 0, 0, 0}},
  {"A18", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224000, 0, 0, 0, 0, 0}},
  {"A19", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232000, 0, 0, 0, 0, 0}},
  {"A20", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248000, 0, 0, 0, 0, 0}},
  {"A21", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256000, 0, 0, 0, 0, 0}},
  {"A22", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264000, 0, 0, 0, 0, 0}},
  {"A23", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 272000, 0, 0, 0, 0, 0}},
  {"A24", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 280000, 0, 0, 0, 0, 0}},
  {"A25", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 288000, 0, 0, 0, 0, 0}},
  {"A26", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 296000, 0, 0, 0, 0, 0}},
  {"A27", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304000, 0, 0, 0, 0, 0}},
  {"A28", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 312000, 0, 0, 0, 0, 0}},
  {"A29", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320000, 0, 0, 0, 0, 0}},
  {"A30", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 344000, 0, 0, 0, 0, 0}},
  {"A31", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 352000, 0, 0, 0, 0, 0}},
  {"A32", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 408000, 0, 0, 0, 0, 0}},
  {"A33", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 416000, 0, 0, 0, 0, 0}},
  {"A34", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 448000, 0, 0, 0, 0, 0}},
  {"A35", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 480000, 0, 0, 0, 0, 0}},
  {"A36", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 520000, 0, 0, 0, 0, 0}},
  {"B1", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224250, 0, 0, 0}},
  {"B2", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232250, 0, 0, 0}},
  {"B3", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240250, 0, 0, 0}},
  {"B4", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248250, 0, 0, 0}},
  {"B5", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256250, 0, 0, 0}},
  {"B6", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 264250, 0, 0, 0}},
  {"B7", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 272250, 0, 0, 0}},
  {"B8", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 280250, 0, 0, 0}},
  {"B9", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 288250, 0, 0, 0}},
  {"B10", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 296250, 0, 0, 0}},
  {"B11", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304250, 0, 0, 0}},
  {"B12", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 312250, 0, 0, 0}},
  {"B13", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320250, 0, 0, 0}},
  {"B14", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 328250, 0, 0, 0}},
  {"B15", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336250, 0, 0, 0}},
  {"B16", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 344250, 0, 0, 0}},
  {"B17", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 352250, 0, 0, 0}},
  {"B18", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 360250, 0, 0, 0}},
  {"B19", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 368250, 0, 0, 0}},
  {"B20", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 376250, 0, 0, 0}},
  {"B21", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 384250, 0, 0, 0}},
  {"B22", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 392250, 0, 0, 0}},
  {"B23", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 400250, 0, 0, 0}},
  {"B24", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 408250, 0, 0, 0}},
  {"B25", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 416250, 0, 0, 0}},
  {"B26", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 424250, 0, 0, 0}},
  {"B27", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 432250, 0, 0, 0}},
  {"B28", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 440250, 0, 0, 0}},
  {"B29", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 448250, 0, 0, 0}},
  {"B30", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 456250, 0, 0, 0}},
  {"B31", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 463250, 0, 0, 0}},
  {"C1", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 567250, 0, 0, 0}},
  {"C2", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 575250, 0, 0, 0}},
  {"C3", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 583250, 0, 0, 0}},
  {"C4", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 591250, 0, 0, 0}},
  {"C5", {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 599250, 0, 0, 0}},
  {"A", {0, 0, 0, 0, 0, 0, 0, 0, 53750, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"B", {0, 0, 0, 0, 0, 0, 0, 0, 62250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"C", {0, 0, 0, 0, 0, 0, 0, 0, 82250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"D", {0, 0, 0, 0, 0, 0, 0, 0, 175250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"E", {0, 0, 0, 0, 0, 0, 0, 0, 183750, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"F", {0, 0, 0, 0, 0, 0, 0, 0, 192250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"G", {0, 0, 0, 0, 0, 0, 0, 0, 201250, 0, 0, 0, 0, 0, 0, 0, 0}},
  {"H", {0, 0, 0, 0, 0, 0, 0, 0, 210250, 0, 0, 0, 0, 0, 0, 0, 0}}
};
