/*****************************************************************************
 * event.h: eventmap support
 *****************************************************************************
 * $Id: event.h,v 1.6 2004/09/08 21:03:48 alainjj Exp $
 *****************************************************************************
 *
 * (C) 2003 Lucian Langa eventmap support for xdtv
 * Lucian Langa <cooly@eweb.ro>
 * This software was based on xawtv. Those portions are
 * Copyright (C) 2000 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#define EVENT_ARGV_SIZE 16

struct event_entry {
    /* the entry */
    char event[128];
    char action[128];
    int repeat;

    /* pre-parsed action for do_command */
    char argbuf[128];
    int  argc;
    char *argv[EVENT_ARGV_SIZE];

    /* linked list */
    struct event_entry *next;
};

int event_register(char *event, char *action, int repeat);
int event_register_list(struct event_entry *entry);
int change_repeat_last_registered(int repeat);

void event_readconfig(void);
void event_writeconfig(FILE *fp);

int event_dispatch(char *event, int repeat);

void save_user_events(FILE *fp);
