/*****************************************************************************
 * $Id: audio-sun.c,v 1.6 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include "config.h"
#ifdef HAVE_SUNAUDIO
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/audioio.h>

#include "audio.h"
static char *device = "/dev/sound";
static int fd = -1;

static int sunaudio_check(void) {
  if(audio_dev) device=audio_dev;
  fd=open (device, O_WRONLY|O_NONBLOCK);
  if(fd<0) fd=open (device, O_RDONLY|O_NONBLOCK);
  if(fd<0) return 0;
  close(fd);
  fd = -1;
  return 1;
}

static int sunaudio_open(int mode, int fmtsample, int nchannels, int freq,
			 int nfrags, int fragsize) {
  audio_info_t info;
  int mode_to_flag[]= {
    [AUDIO_RO] = O_RDONLY,
    [AUDIO_WO] = O_WRONLY,
    [AUDIO_RW] = O_RDWR};
  if(audio_dev) device=audio_dev;
  if(fd!=-1) close(fd);
  fd=open (device, mode_to_flag[mode]);
  if(fd<0) {
    fprintf(stderr, "failed to open audio device %s:\n", device);
    perror("open");
    return -1;
  }
  ioctl(fd, AUDIO_DRAIN, 0);
  AUDIO_INITINFO (&info);
  info.play.sample_rate=info.record.sample_rate = freq;
  info.blocksize = fragsize;
  info.hiwat = nfrags;
  info.mode = 0; 
  if(mode&AUDIO_RO) info.mode |= AUMODE_RECORD;
  if(mode&AUDIO_WO) info.mode |= (AUMODE_PLAY | AUMODE_PLAY_ALL);
  info.play.channels=info.record.channels = nchannels;
  info.play.precision=info.record.precision = fmtsample == AUDIO_U8 ? 8 : 16;
  info.play.encoding=info.record.encoding = 
    fmtsample == AUDIO_U8 ? AUDIO_ENCODING_ULINEAR : AUDIO_ENCODING_SLINEAR_LE;
  info.record.port = AUDIO_LINE_IN; //normally choice is made in mixer.c....
  if (ioctl (fd, AUDIO_SETINFO, &info) == -1) {
    perror("AUDIO_SETINFO");
    return -1;
  }
  if(mode==AUDIO_RW) {
    int arg=1;
    if(ioctl (fd, AUDIO_SETFD, &arg) == -1) {
      perror("AUDIOSETFD");
      return -1;
    }
  }
  return 0;
}

static int sunaudio_close(void) {
  if(fd!=-1) close(fd);
  fd=-1;
  return 0;
}

static int sunaudio_read(void *r, int n) {
  n=read(fd,r,n);
  if(n<0) perror("sunaudio_read");
  return n;
}

static int sunaudio_write(void *w, int n) {
  n=write(fd,w,n);
  if(n<0) perror("sunaudio_read");
  return n;
}

struct AUDRIVER audio_sun = {
  "sunaudio",
  sunaudio_check,
  sunaudio_open,
  sunaudio_close,
  sunaudio_read,
  sunaudio_write,
};


#endif
