/**********************************************************************
** Copyright (C) 2002 Trolltech AS.  All rights reserved.
**
** This file is part of Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#include "advanced.h"
#include <qtopia/calc/doubleinstruction.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qpainter.h>

#include <qtopia/qpeapplication.h>
#include <qtopia/resource.h>

void FormAdvanced::fontChange() {
    updatePictures();
    update();
    updateGeometry();
}

void FormAdvanced::updatePictures() {
    QFont big(font());
    if(big.pointSize() <= 1)
	big.setPointSize(12);	// Correct for scaleable fonts.
    QColor bg = PBMPlus->backgroundColor();

    int fontSize = big.pixelSize();
    int fontSize05 = fontSize / 2;
    int fontSize10 = fontSize;
    int fontSize15 = fontSize + fontSize05;
    int fontSize20 = fontSize * 2;
    int fontSize25 = fontSize20 + fontSize05;

    int pixSize = fontSize25;

    PMPow = new QPixmap(pixSize,pixSize);
    PMPow->fill(bg);
    QPainter p(PMPow);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize10,fontSize20,"x");
    p.drawText(fontSize15,fontSize15,"y");
    p.end();
    PBPow->setPixmap(*PMPow);

    PMLog = new QPixmap(pixSize,pixSize);
    PMLog->fill(bg);
    p.begin(PMLog);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize10,fontSize20,"e");
    p.drawText(fontSize15,fontSize15,"x");
    p.end();
    PBLog->setPixmap(*PMLog);

    PMSquare = new QPixmap(pixSize,pixSize);
    PMSquare->fill(bg);
    p.begin(PMSquare);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize10,fontSize20,"x");
    p.drawText(fontSize15,fontSize15,"2");
    p.end();
    PBSquare->setPixmap(*PMSquare);

    PMXRootY = new QPixmap(pixSize,pixSize);
    PMXRootY->fill(bg);
    p.begin(PMXRootY);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize15,fontSize20,"x");
    p.drawText(fontSize05,fontSize,"y");
    p.drawLine(fontSize05,fontSize15,fontSize10,fontSize20);
    p.drawLine(fontSize10,fontSize20,fontSize15,fontSize10);
    p.drawLine(fontSize15,fontSize10,fontSize25,fontSize10);
    p.end();
    PBXRootY->setPixmap(*PMXRootY);

    PMOneOverX = new QPixmap(pixSize,pixSize);
    PMOneOverX->fill(bg);
    p.begin(PMOneOverX);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize10,fontSize10,"1");
    int between = (fontSize10 + fontSize15) / 2;
    p.drawLine(fontSize05,between,fontSize20,between);
    p.drawText(fontSize10,fontSize20,"x");
    p.end();
    PBOneOverX->setPixmap(*PMOneOverX);

    PMSquareRoot = new QPixmap(pixSize,pixSize);
    PMSquareRoot->fill(bg);
    p.begin(PMSquareRoot);
    p.setPen(black);
    p.setFont(big);
    p.drawText(fontSize15,fontSize20,"x");
    p.drawLine(fontSize05,fontSize15,fontSize10,fontSize20);
    p.drawLine(fontSize10,fontSize20,fontSize15,fontSize10);
    p.drawLine(fontSize15,fontSize10,fontSize25,fontSize10);
    p.end();
    PBSquareRoot->setPixmap(*PMSquareRoot);

    delete PMPow;
    delete PMLog;
    delete PMSquare;
    delete PMXRootY;
    delete PMOneOverX;
    delete PMSquareRoot;
} 

FormAdvanced::FormAdvanced(QWidget *parent) :QWidget(parent) {
    QSizePolicy mySizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred,FALSE);

    QWidget *d = QPEApplication::desktop();
    bool portrait;
    siw = new Type1DecimalInputWidget(this,"SIW"); //number keys
    
    if ( d->width() < d->height() ) { //portrait
        AdvancedLayout = new QGridLayout( this, 9, 4 );
        AdvancedLayout->addMultiCellWidget(siw, 5, 8, 0, 3);
        portrait = TRUE;
    } else { //landscape
        AdvancedLayout = new QGridLayout( this, 5, 7 );
        AdvancedLayout->addMultiCellWidget(siw, 1, 4, 3, 6);
        portrait = FALSE;
    }
    
    QFont fonty;
    int fontSize = fonty.pixelSize();
    if (fontSize == 12)
	fontSize = 14;

    PBMPlus = new QPushButton(this,"PBM+");
    PBMPlus->setSizePolicy(mySizePolicy);
    PBMPlus->setText(tr("M+"));
    if (portrait)
        AdvancedLayout->addWidget(PBMPlus, 0, 0);
    else
        AdvancedLayout->addWidget(PBMPlus, 0, 3); 

    PBMR = new QPushButton(this,"PBMR");
    PBMR->setSizePolicy(mySizePolicy);
    PBMR->setText(tr("MR"));
    if (portrait)
        AdvancedLayout->addWidget(PBMR, 0, 1);
    else
        AdvancedLayout->addWidget(PBMR, 0, 4); 

    PBMC = new QPushButton(this,"PBMC");
    PBMC->setSizePolicy(mySizePolicy);
    PBMC->setText(tr("MC"));
    if (portrait)
        AdvancedLayout->addWidget(PBMC, 0, 2);
    else
        AdvancedLayout->addWidget(PBMC, 0, 5); 

    PBC = new QPushButton(this,"PBC");
    PBC->setSizePolicy(mySizePolicy);
    PBC->setText(tr("CE/C"));
    if (portrait)
        AdvancedLayout->addWidget(PBC, 0, 3);
    else
        AdvancedLayout->addWidget(PBC, 0, 6); 

    PBASin = new QPushButton(this,"PBASin");
    PBASin->setSizePolicy(mySizePolicy);
    PBASin->setText(tr("asin"));
    if (portrait)
        AdvancedLayout->addWidget(PBASin,2,0);
    else
        AdvancedLayout->addWidget(PBASin,1,0);

    PBACos = new QPushButton(this,"PBACos");
    PBACos->setSizePolicy(mySizePolicy);
    PBACos->setText(tr("acos"));
    if (portrait)
        AdvancedLayout->addWidget(PBACos,2,1);
    else
        AdvancedLayout->addWidget(PBACos,1,1);

    PBATan = new QPushButton(this,"PBATan");
    PBATan->setSizePolicy(mySizePolicy); 
    PBATan->setText(tr("atan"));
    if (portrait)
        AdvancedLayout->addWidget(PBATan,2,2);
    else
        AdvancedLayout->addWidget(PBATan,1,2);

    PBPi = new QPushButton(this,"PBPi");
    PBPi->setSizePolicy(mySizePolicy);
    PBPi->setText(tr("PI"));
    if (portrait) {
        AdvancedLayout->addWidget(PBPi,1,3);
    } else
        PBPi->hide();
    

    PBSin = new QPushButton(this,"PBSin");
    PBSin->setSizePolicy(mySizePolicy);
    PBSin->setText(tr("sin"));
    if (portrait) 
        AdvancedLayout->addWidget(PBSin,1,0);
    else
        AdvancedLayout->addWidget(PBSin,0,0);

    PBCos = new QPushButton(this,"PBCos");
    PBCos->setSizePolicy(mySizePolicy);
    PBCos->setText(tr("cos"));
    if (portrait)
        AdvancedLayout->addWidget(PBCos,1,1);
    else
        AdvancedLayout->addWidget(PBCos,0,1);
        

    PBTan = new QPushButton(this,"PBTan");
    PBTan->setSizePolicy(mySizePolicy);
    PBTan->setText(tr("tan"));
    if (portrait)
        AdvancedLayout->addWidget(PBTan,1,2);
    else
        AdvancedLayout->addWidget(PBTan,0,2);
        

    PBFactorial = new QPushButton(this,"PBTan");
    PBFactorial->setSizePolicy(mySizePolicy);
    PBFactorial->setText(tr("n!"));
    if (portrait)
        AdvancedLayout->addWidget(PBFactorial,2,3);
    else
        AdvancedLayout->addWidget(PBFactorial,4,0);

    PBSquareRoot = new QPushButton(this,"PBSquareRoot");
    PBSquareRoot->setSizePolicy(mySizePolicy);
    if (portrait)
        AdvancedLayout->addWidget(PBSquareRoot,3,0);
    else
        AdvancedLayout->addWidget(PBSquareRoot,3,0);

    PBXRootY = new QPushButton(this,"PBXRootY");
    PBXRootY->setSizePolicy(mySizePolicy);
    if (portrait)
        AdvancedLayout->addWidget(PBXRootY,3,1);
    else
        AdvancedLayout->addWidget(PBXRootY,3,1);


    PBLn = new QPushButton(this,"PBLn");
    PBLn->setSizePolicy(mySizePolicy);
    PBLn->setText(tr("ln"));
    if (portrait)
        AdvancedLayout->addWidget(PBLn,3,2);
    else
        AdvancedLayout->addWidget(PBLn,3,2);

    PBNegate = new QPushButton(this,"PBNegate");
    PBNegate->setSizePolicy(mySizePolicy);
    PBNegate->setText(tr("+/-"));
    if (portrait)
        AdvancedLayout->addWidget(PBNegate,3,3);
    else
        AdvancedLayout->addWidget(PBNegate,4,2);

    PBSquare = new QPushButton(this,"PBSquare");
    PBSquare->setSizePolicy(mySizePolicy);
    if (portrait)
        AdvancedLayout->addWidget(PBSquare,4,0);
    else
        AdvancedLayout->addWidget(PBSquare,2,0);

    PBPow = new QPushButton(this,"PBPow");
    PBPow->setSizePolicy(mySizePolicy);
    if (portrait)
        AdvancedLayout->addWidget(PBPow,4,1);
    else
        AdvancedLayout->addWidget(PBPow,2,1);

    PBLog = new QPushButton(this,"PBLog");
    PBLog->setSizePolicy(mySizePolicy);
    PBLog->setText(tr("log"));
    if (portrait)
        AdvancedLayout->addWidget(PBLog,4,2);
    else
        AdvancedLayout->addWidget(PBLog,2,2);

    PBOneOverX = new QPushButton(this,"PBOneOverX");
    PBOneOverX->setSizePolicy(mySizePolicy);
    if (portrait)
        AdvancedLayout->addWidget(PBOneOverX,4,3);
    else
        AdvancedLayout->addWidget(PBOneOverX,4,1);
        

    updatePictures();

    connect (PBMR, SIGNAL(clicked()), this, SLOT(MRClicked()));
    connect (PBMC, SIGNAL(clicked()), this, SLOT(MCClicked()));
    connect (PBMPlus, SIGNAL(clicked()), this, SLOT(MPlusClicked()));
    connect (PBC, SIGNAL(clicked()), this, SLOT(CClicked()));

    connect (PBASin, SIGNAL(clicked()), this, SLOT(aSinGraClicked()));
    connect (PBACos, SIGNAL(clicked()), this, SLOT(aCosGraClicked()));
    connect (PBATan, SIGNAL(clicked()), this, SLOT(aTanGraClicked()));
    connect (PBPi, SIGNAL(clicked()), this, SLOT(PiClicked()));

    connect (PBSin, SIGNAL(clicked()), this, SLOT(SinGraClicked()));
    connect (PBCos, SIGNAL(clicked()), this, SLOT(CosGraClicked()));
    connect (PBTan, SIGNAL(clicked()), this, SLOT(TanGraClicked()));
    connect (PBOneOverX, SIGNAL(clicked()), this, SLOT(OneOverXClicked()));

    connect (PBLog, SIGNAL(clicked()), this, SLOT(LogClicked()));
    connect (PBLn, SIGNAL(clicked()), this, SLOT(LnClicked()));
    connect (PBFactorial, SIGNAL(clicked()), this, SLOT(FactorialClicked()));
    connect (PBNegate, SIGNAL(clicked()), this, SLOT(NegateClicked()));

    connect (PBSquare, SIGNAL(clicked()), this, SLOT(SquareClicked()));
    connect (PBPow, SIGNAL(clicked()), this, SLOT(PowClicked()));
    connect (PBSquareRoot, SIGNAL(clicked()), this, SLOT(SquareRootClicked()));
    connect (PBXRootY, SIGNAL(clicked()), this, SLOT(XRootYClicked()));
}

FormAdvanced::~FormAdvanced() {
    delete PBPi;
    delete PBC;
    delete PBMR;
    delete PBMC;
    delete PBMPlus;
    delete PBSin;
    delete PBCos;
    delete PBTan;
    delete PBOneOverX;
    delete PBLog;
    delete PBLn;
    delete PBFactorial;
    delete PBNegate;
    delete PBSquare;
    delete PBPow;
    delete PBSquareRoot;
    delete PBXRootY;

    delete siw;
    delete AdvancedLayout;
}

void FormAdvanced::showEvent ( QShowEvent *e ) {
    systemEngine->setAccType("Double"); // No tr
    QWidget::showEvent(e);
}
void FormAdvanced::MCClicked() {
    systemEngine->memoryReset();
}
void FormAdvanced::MRClicked() {
    systemEngine->memoryRecall();
}
void FormAdvanced::MPlusClicked() {
    systemEngine->memorySave();
}
void FormAdvanced::CClicked() {
    systemEngine->dualReset();
}

void FormAdvanced::aSinRadClicked() {
    systemEngine->pushInstruction(new DoubleASinRad());
}
void FormAdvanced::aSinGraClicked() {
    systemEngine->pushInstruction(new DoubleASinGra());
}
void FormAdvanced::aCosRadClicked() {
    systemEngine->pushInstruction(new DoubleACosRad());
}
void FormAdvanced::aCosGraClicked() {
    systemEngine->pushInstruction(new DoubleACosGra());
}
void FormAdvanced::aTanRadClicked() {
    systemEngine->pushInstruction(new DoubleATanRad());
}
void FormAdvanced::aTanGraClicked() {
    systemEngine->pushInstruction(new DoubleATanGra());
}
void FormAdvanced::DelClicked() {
    systemEngine->delChar();
}

void FormAdvanced::SinGraClicked() {
    systemEngine->pushInstruction(new DoubleSinGra());
}
void FormAdvanced::CosGraClicked() {
    systemEngine->pushInstruction(new DoubleCosGra());
}
void FormAdvanced::TanGraClicked() {
    systemEngine->pushInstruction(new DoubleTanGra());
}
void FormAdvanced::SinRadClicked() {
    systemEngine->pushInstruction(new DoubleSinRad());
}
void FormAdvanced::CosRadClicked() {
    systemEngine->pushInstruction(new DoubleCosRad());
}
void FormAdvanced::TanRadClicked() {
    systemEngine->pushInstruction(new DoubleTanRad());
}
void FormAdvanced::OneOverXClicked() {
    systemEngine->pushInstruction(new DoubleOneOverX());
}
void FormAdvanced::LogClicked() {
    systemEngine->pushInstruction(new DoubleExp());
}
void FormAdvanced::LnClicked() {
    systemEngine->pushInstruction(new DoubleLn());
}
void FormAdvanced::FactorialClicked() {
    systemEngine->pushInstruction(new DoubleFactorial());
}
void FormAdvanced::NegateClicked() {
    systemEngine->pushInstruction(new DoubleNegate());
}
void FormAdvanced::SquareClicked() {
    systemEngine->pushInstruction(new DoubleSquare());
}
void FormAdvanced::PowClicked() {
    systemEngine->pushInstruction(new DoublePow());
}
void FormAdvanced::PiClicked() {
    systemEngine->push(QString("3.14159265358979323846"));
}
void FormAdvanced::SquareRootClicked() {
    systemEngine->pushInstruction(new DoubleSquareRoot());
}
void FormAdvanced::XRootYClicked() {
    systemEngine->pushInstruction(new DoubleXRootY());
}
