/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#include "qvboxwidget.h"
#include "qlayout.h"
#ifndef QT_NO_VBOXWIDGET

/*!
    \class QVBoxWidget qvboxwidget.h
    \brief The QVBoxWidget widget provides vertical geometry management of
    its child widgets.

    \ingroup geomanagement
    \ingroup appearance
    \ingroup organizers

    All its child widgets will be placed vertically and sized
    according to their sizeHint()s. If you just need a layout (not a
    widget) use QVBoxLayout instead.

    \img qvbox-m.png QVBoxWidget

    \sa QHBoxWidget QGridWidget
*/


#ifdef QT_COMPAT
/*! \obsolete
    Constructs a vbox widget called \a name with parent \a parent and
    widget flags \a f.
 */
QVBoxWidget::QVBoxWidget(QWidget *parent, const char *name, Qt::WFlags f)
    :QHBoxWidget(Qt::Vertical, parent, f)
{
    QString nm(name);
    setObjectName(nm);
    layout()->setObjectName(nm);
}
#endif //QT_COMPAT

/*!
    Constructs a vbox widget with parent \a parent and
    widget flags \a f.
 */
QVBoxWidget::QVBoxWidget(QWidget *parent, Qt::WFlags f)
    :QHBoxWidget(Qt::Vertical, parent, f)
{
}

#endif
