/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QSPLITTER_P_H
#define QSPLITTER_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <private/qframe_p.h>

class QSplitterLayoutStruct;
class QSplitterPrivate : public QFramePrivate
{
    Q_DECLARE_PUBLIC(QSplitter)
public:
    QSplitterPrivate() : rubberBand(0), opaque(false), firstShow(true),
                         childrenCollapsible(true), compatMode(false), handleWidth(0) {}

    QPointer<QRubberBand> rubberBand;
    mutable QList<QSplitterLayoutStruct *> list;
    Qt::Orientation orient;
    bool opaque : 8;
    bool firstShow : 8;
    bool childrenCollapsible : 8;
    bool compatMode : 8;
    int handleWidth;

    inline QCOORD pick(const QPoint &p) const
    { return orient == Qt::Horizontal ? p.x() : p.y(); }
    inline QCOORD pick(const QSize &s) const
    { return orient == Qt::Horizontal ? s.width() : s.height(); }

    inline QCOORD trans(const QPoint &p) const
    { return orient == Qt::Vertical ? p.x() : p.y(); }
    inline QCOORD trans(const QSize &s) const
    { return orient == Qt::Vertical ? s.width() : s.height(); }

    void init();
    void recalc(bool update = false);
    void doResize();
    void storeSizes();
    void getRange(int id, int *, int *, int *, int *);
    void addContribution(int, int *, int *, bool);
    int adjustPos(int, int, int *, int *, int *, int *);
    bool collapsible(QSplitterLayoutStruct *);
    QSplitterLayoutStruct *findWidget(QWidget *);
    QSplitterLayoutStruct *addWidget(QWidget *, bool prepend = false);
    void recalcId();
    void doMove(bool backwards, int pos, int id, int delta,
                bool mayCollapse, int *positions, int *widths);
    void setGeo(QSplitterLayoutStruct *s, int pos, int size, bool splitterMoved);
    int findWidgetJustBeforeOrJustAfter(int id, int delta, int &collapsibleSize);
    void updateHandles();

};

#endif // QSPLITTER_P_H
