/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the painting module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QPAINTERPATH_P_H
#define QPAINTERPATH_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <qlist.h>
#include <qregion.h>
#include <qpainterpath.h>

class QPolygon;

class QPainterPathPrivate
{
    Q_DECLARE_PUBLIC(QPainterPath)
public:
    QPainterPathPrivate(QPainterPath *path) :
        q_ptr(path), cStart(0), fillRule(Qt::OddEvenFill)
    {
    }

    inline bool isClosed() const;
    inline void close();

    inline void makeDirty();

    QPainterPath *q_ptr;
    int cStart;
    Qt::FillRule fillRule;

    QRegion containsCache;
};

void qt_find_ellipse_coords(const QRectF &r, float angle, float length,
                            QPointF* startPoint, QPointF *endPoint);

inline bool QPainterPathPrivate::isClosed() const
{
    const QPainterPath::Element &first = q_func()->elements.at(cStart);
    const QPainterPath::Element &last = q_func()->elements.last();
    return first.x == last.x && first.y == last.y;
}

inline void QPainterPathPrivate::close()
{
    const QPainterPath::Element &first = q_func()->elements.at(cStart);
    const QPainterPath::Element &last = q_func()->elements.last();
    if (first.x != last.x || first.y != last.y)
        q_func()->lineTo(QPointF(first.x, first.y));
}

inline void QPainterPathPrivate::makeDirty()
{
    if (!containsCache.isEmpty())
        containsCache = QRegion();
}

#endif // QPAINTERPATH_P_H
