/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef GetImageReply_H
#define GetImageReply_H

#include "Message.h"

//
// Set the verbosity level.
//

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  DUMP

//
// Set default values.
//

#define GETIMAGEREPLY_ENABLE_CACHE                       1
#define GETIMAGEREPLY_ENABLE_DATA                        1
#define GETIMAGEREPLY_ENABLE_SPLIT                       0
#define GETIMAGEREPLY_ENABLE_COMPRESS                    1

#define GETIMAGEREPLY_DATA_LIMIT                         1048576 - 32
#define GETIMAGEREPLY_DATA_OFFSET                        32

#define GETIMAGEREPLY_CACHE_SLOTS                        1000
#define GETIMAGEREPLY_CACHE_THRESHOLD                    20
#define GETIMAGEREPLY_CACHE_LOWER_THRESHOLD              2

//
// The message class.
//

class GetImageReplyMessage : public Message
{
  friend class GetImageReplyStore;

  public:

  GetImageReplyMessage()
  {
  }

  ~GetImageReplyMessage()
  {
  }

  //
  // Put here the fields which constitute 
  // the 'identity' part of the message.
  //

  private:

  unsigned char depth;
  unsigned int  visual;
};

class GetImageReplyStore : public MessageStore
{
  //
  // Constructors and destructors.
  //

  public:

  GetImageReplyStore(Compressor *compressor, Decompressor *decompressor)

    : MessageStore(compressor, decompressor)
  {
    enableCache    = GETIMAGEREPLY_ENABLE_CACHE;
    enableData     = GETIMAGEREPLY_ENABLE_DATA;
    enableSplit    = GETIMAGEREPLY_ENABLE_SPLIT;
    enableCompress = GETIMAGEREPLY_ENABLE_COMPRESS;

    dataLimit  = GETIMAGEREPLY_DATA_LIMIT;
    dataOffset = GETIMAGEREPLY_DATA_OFFSET;

    cacheSlots          = GETIMAGEREPLY_CACHE_SLOTS;
    cacheThreshold      = GETIMAGEREPLY_CACHE_THRESHOLD;
    cacheLowerThreshold = GETIMAGEREPLY_CACHE_LOWER_THRESHOLD;

    messages_ -> resize(cacheSlots);

    for (T_messages::iterator i = messages_ -> begin();
             i < messages_ -> end(); i++)
    {
      *i = NULL;
    }

    temporary_ = NULL;
  }

  virtual ~GetImageReplyStore()
  {
    for (T_messages::iterator i = messages_ -> begin();
             i < messages_ -> end(); i++)
    {
      destroy(*i);
    }

    destroy(temporary_);
  }

  virtual const char *name() const
  {
    return "GetImageReply";
  }

  virtual unsigned char opcode() const
  {
    return X_GetImage;
  }

  virtual unsigned int storage() const
  {
    return sizeof(GetImageReplyMessage);
  }

  //
  // Message handling methods.
  //

  protected:

  virtual Message *create() const
  {
    return new GetImageReplyMessage();
  }

  virtual Message *create(const Message &message) const
  {
    return new GetImageReplyMessage((const GetImageReplyMessage &) message);
  }

  virtual void destroy(Message *message) const
  {
    delete (GetImageReplyMessage *) message;
  }

  virtual int parseIdentity(Message *message, const unsigned char *buffer, 
                                unsigned int size, int bigEndian) const;

  virtual int unparseIdentity(const Message *message, unsigned char *buffer, 
                                  unsigned int size, int bigEndian) const;

  virtual void updateIdentity(EncodeBuffer &encodeBuffer, const Message *message,
                                  const Message *cachedMessage,
                                      ChannelCache *channelCache) const;

  virtual void updateIdentity(DecodeBuffer &decodeBuffer, const Message *message,
                                  ChannelCache *channelCache) const;

  virtual void identityChecksum(const Message *message, const unsigned char *buffer, 
                                    unsigned int size, int bigEndian) const;

  virtual void dumpIdentity(const Message *message) const;
};

#endif /* GetImageReply_H */
