/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef ClientStore_H
#define ClientStore_H

#include "Message.h"
#include "Split.h"

#include "ChannelStore.h"

class Compressor;
class Decompressor;

class ClientStore : public ChannelStore
{
  public:

  ClientStore(Compressor *compressor, Decompressor *decompressor);

  virtual ~ClientStore();

  //
  // Get store according to message's opcode.
  //

  MessageStore *getRequestStore(unsigned char opcode) const
  {
    return requests_[opcode];
  }

  SplitStore *getSplitStore() const
  {
    return splits_;
  }

  //
  // Actually save the message store
  // to disk according to proxy mode.
  //

  int saveRequestStores(ostream *cachefs, md5_state_t *md5StateStream,
                            md5_state_t *md5StateClient, T_checksum_action checksumAction,
                                T_data_action dataAction) const;

  int loadRequestStores(istream *cachefs, md5_state_t *md5StateStream,
                            T_checksum_action checksumAction, T_data_action dataAction) const;

  private:

  //
  // A client store contains requests.
  //

  MessageStore *requests_[CHANNEL_STORE_OPCODE_LIMIT];

  //
  // Temporary storage used to parcelize
  // big requests in smaller chunks.
  //

  SplitStore *splits_;
};

#endif /* ClientStore_H */
